/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.predicateindex.AttributeNode;
import org.infinispan.objectfilter.impl.predicateindex.FilterEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.Predicate;
import org.infinispan.objectfilter.impl.predicateindex.be.PredicateNode;

public abstract class MatcherEvalContext<AttributeId extends Comparable<AttributeId>> {
    protected AttributeNode<AttributeId> currentNode;
    private final Map<FilterSubscriptionImpl, FilterEvalContext> filterContexts = new HashMap<FilterSubscriptionImpl, FilterEvalContext>();
    private final Map<Predicate<?>, AtomicInteger> suspendedSubscriptionCounts = new HashMap();
    private final Set<PredicateNode<AttributeId>> suspendedSubscriptions = new HashSet<PredicateNode<AttributeId>>();
    private final Object instance;
    protected String entityTypeName;

    protected MatcherEvalContext(Object instance) {
        this.instance = instance;
    }

    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    public Object getInstance() {
        return this.instance;
    }

    public FilterEvalContext getFilterEvalContext(FilterSubscriptionImpl filterSubscription) {
        FilterEvalContext filterEvalContext = this.filterContexts.get(filterSubscription);
        if (filterEvalContext == null) {
            Object[] projection = filterSubscription.getProjection() != null ? new Object[filterSubscription.getProjection().length] : null;
            Comparable[] sortProjection = filterSubscription.getSortFields() != null ? new Comparable[filterSubscription.getSortFields().length] : null;
            filterEvalContext = new FilterEvalContext(filterSubscription.getBETree(), this, projection, sortProjection);
            this.filterContexts.put(filterSubscription, filterEvalContext);
        }
        return filterEvalContext;
    }

    public void addSuspendedSubscription(PredicateNode<AttributeId> predicateNode) {
        this.suspendedSubscriptions.add(predicateNode);
        AtomicInteger counter = this.suspendedSubscriptionCounts.get(predicateNode.getPredicate());
        if (counter == null) {
            counter = new AtomicInteger();
            this.suspendedSubscriptionCounts.put(predicateNode.getPredicate(), counter);
        }
        counter.incrementAndGet();
    }

    public boolean isSuspendedSubscription(PredicateNode<AttributeId> predicateNode) {
        return this.suspendedSubscriptions.contains(predicateNode);
    }

    public int getSuspendedSubscriptionsCounter(Predicate<?> predicate) {
        AtomicInteger counter = this.suspendedSubscriptionCounts.get(predicate);
        return counter == null ? 0 : counter.get();
    }

    public void process(AttributeNode<AttributeId> node) {
        this.currentNode = node;
        this.processAttributes(this.currentNode, this.instance);
    }

    protected abstract void processAttributes(AttributeNode<AttributeId> var1, Object var2);
}

