/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.List;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.predicateindex.AttributeNode;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.Predicate;
import org.infinispan.objectfilter.impl.predicateindex.RootNode;
import org.infinispan.objectfilter.impl.predicateindex.be.PredicateNode;

public final class PredicateIndex<AttributeId extends Comparable<AttributeId>> {
    private final AttributeNode<AttributeId> root;

    public PredicateIndex(MetadataAdapter<?, AttributeId> metadataAdapter) {
        this.root = new RootNode<AttributeId>(metadataAdapter);
    }

    public AttributeNode<AttributeId> getRoot() {
        return this.root;
    }

    public Subscription addSubscriptionForPredicate(PredicateNode<AttributeId> predicateNode, Predicate.Callback callback) {
        AttributeNode<AttributeId> attributeNode = this.addAttributeNodeByPath(predicateNode.getAttributePath());
        Subscription subscription = new Subscription(predicateNode, callback);
        attributeNode.addPredicateSubscription(subscription);
        return subscription;
    }

    public AttributeNode<AttributeId> getAttributeNodeByPath(List<AttributeId> attributePath) {
        AttributeNode<Comparable> node = this.root;
        for (Comparable attribute : attributePath) {
            if ((node = node.getChild(attribute)) != null) continue;
            throw new IllegalStateException("Child not found : " + attribute);
        }
        return node;
    }

    public AttributeNode<AttributeId> addAttributeNodeByPath(List<AttributeId> attributePath) {
        AttributeNode<Comparable> node = this.root;
        for (Comparable attribute : attributePath) {
            node = node.addChild(attribute);
        }
        return node;
    }

    public final class Subscription {
        private final PredicateNode<AttributeId> predicateNode;
        private final Predicate.Callback callback;

        Subscription(PredicateNode<AttributeId> predicateNode, Predicate.Callback callback) {
            this.predicateNode = predicateNode;
            this.callback = callback;
        }

        public Predicate getPredicate() {
            return this.predicateNode.getPredicate();
        }

        public void suspend(MatcherEvalContext<AttributeId> ctx) {
            ctx.addSuspendedSubscription(this.predicateNode);
        }

        public void cancel() {
            AttributeNode current;
            current.removePredicateSubscription(this);
            for (current = PredicateIndex.this.getAttributeNodeByPath(this.predicateNode.getAttributePath()); current != PredicateIndex.this.root && current.getNumChildren() <= 0 && !current.hasPredicates() && !current.hasProjections(); current = current.getParent()) {
                Object childId = current.getAttribute();
                current.removeChild(childId);
            }
        }

        public void handleValue(MatcherEvalContext<AttributeId> ctx, boolean isMatching) {
            if (!ctx.isSuspendedSubscription(this.predicateNode)) {
                if (this.predicateNode.isNegated()) {
                    boolean bl = isMatching = !isMatching;
                }
                if (isMatching || !this.predicateNode.isRepeated()) {
                    this.callback.handleValue(ctx, isMatching);
                }
            }
        }
    }
}

