/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.Iterator;
import org.infinispan.objectfilter.impl.predicateindex.AttributeNode;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.util.ReflectionHelper;

public class ReflectionMatcherEvalContext
extends MatcherEvalContext<String> {
    public ReflectionMatcherEvalContext(Object instance) {
        super(instance);
        this.entityTypeName = instance.getClass().getCanonicalName();
    }

    @Override
    protected void processAttributes(AttributeNode<String> node, Object instance) {
        Iterator<AttributeNode<String>> children = node.getChildrenIterator();
        while (children.hasNext()) {
            AttributeNode<String> childAttribute = children.next();
            if (instance == null) {
                this.processAttribute(childAttribute, null);
                continue;
            }
            ReflectionHelper.PropertyAccessor accessor = (ReflectionHelper.PropertyAccessor)childAttribute.getMetadata();
            if (accessor.isMultiple()) {
                Iterator<Object> valuesIt = accessor.getValueIterator(instance);
                if (valuesIt == null) {
                    this.processAttribute(childAttribute, null);
                    continue;
                }
                while (valuesIt.hasNext()) {
                    Object attributeValue = valuesIt.next();
                    this.processAttribute(childAttribute, attributeValue);
                }
                continue;
            }
            Object attributeValue = accessor.getValue(instance);
            this.processAttribute(childAttribute, attributeValue);
        }
    }

    private void processAttribute(AttributeNode<String> attributeNode, Object attributeValue) {
        attributeNode.processValue(attributeValue, this);
        this.processAttributes(attributeNode, attributeValue);
    }
}

