/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex.be;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.predicateindex.IsNullCondition;
import org.infinispan.objectfilter.impl.predicateindex.Predicate;
import org.infinispan.objectfilter.impl.predicateindex.RegexCondition;
import org.infinispan.objectfilter.impl.predicateindex.be.AndNode;
import org.infinispan.objectfilter.impl.predicateindex.be.BENode;
import org.infinispan.objectfilter.impl.predicateindex.be.BETree;
import org.infinispan.objectfilter.impl.predicateindex.be.OrNode;
import org.infinispan.objectfilter.impl.predicateindex.be.PredicateNode;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanOperatorExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.RegexExpr;
import org.infinispan.objectfilter.impl.util.Interval;

public final class BETreeMaker<AttributeId extends Comparable<AttributeId>> {
    private final MetadataAdapter<?, AttributeId> attributePathTranslator;

    public BETreeMaker(MetadataAdapter<?, AttributeId> attributePathTranslator) {
        this.attributePathTranslator = attributePathTranslator;
    }

    public BETree make(BooleanExpr booleanExpr) {
        ArrayList<BENode> nodes = new ArrayList<BENode>();
        ArrayList<Integer> treeCounters = new ArrayList<Integer>();
        if (booleanExpr instanceof ConstantBooleanExpr) {
            treeCounters.add(((ConstantBooleanExpr)booleanExpr).getValue() ? 0 : -1);
        } else {
            this.preorderTraversal(null, booleanExpr, nodes, treeCounters);
        }
        int[] countersArray = new int[treeCounters.size()];
        for (int i = 0; i < countersArray.length; ++i) {
            countersArray[i] = (Integer)treeCounters.get(i);
        }
        return new BETree(nodes.toArray(new BENode[nodes.size()]), countersArray);
    }

    private void preorderTraversal(BENode parent, BooleanExpr child, List<BENode> nodes, List<Integer> treeCounters) {
        if (child instanceof NotExpr) {
            PrimaryPredicateExpr condition = (PrimaryPredicateExpr)((NotExpr)child).getChild();
            this.makePredicateNode(parent, nodes, treeCounters, condition, true);
        } else if (child instanceof PrimaryPredicateExpr) {
            PrimaryPredicateExpr condition = (PrimaryPredicateExpr)child;
            this.makePredicateNode(parent, nodes, treeCounters, condition, false);
        } else if (child instanceof OrExpr) {
            this.makeBooleanOperatorNode((OrExpr)child, nodes, treeCounters, new OrNode(parent));
        } else if (child instanceof AndExpr) {
            this.makeBooleanOperatorNode((AndExpr)child, nodes, treeCounters, new AndNode(parent));
        } else {
            throw new IllegalStateException("Unexpected *Expr node type: " + child);
        }
    }

    private void makePredicateNode(BENode parent, List<BENode> nodes, List<Integer> treeCounters, PrimaryPredicateExpr condition, boolean isNegated) {
        Predicate predicate = this.makePredicate(condition);
        List<String> propertyPath = ((PropertyValueExpr)condition.getChild()).getPropertyPath();
        List<AttributeId> translatedPath = this.attributePathTranslator.translatePropertyPath(propertyPath);
        boolean isRepeated = this.attributePathTranslator.isRepeatedProperty(propertyPath);
        PredicateNode<AttributeId> node = new PredicateNode<AttributeId>(parent, predicate, isNegated, translatedPath, isRepeated);
        node.setLocation(nodes.size(), nodes.size() + 1);
        nodes.add(node);
        treeCounters.add(1);
    }

    private Predicate makePredicate(PrimaryPredicateExpr condition) {
        if (condition instanceof ComparisonExpr) {
            Interval<Object> i;
            ComparisonExpr expr = (ComparisonExpr)condition;
            ConstantValueExpr right = (ConstantValueExpr)expr.getRightChild();
            switch (expr.getComparisonType()) {
                case EQUALS: {
                    i = new Interval<Object>(right.getConstantValue(), true, right.getConstantValue(), true);
                    break;
                }
                case LESS: {
                    i = new Interval<Object>(Interval.getMinusInf(), false, right.getConstantValue(), false);
                    break;
                }
                case LESS_OR_EQUAL: {
                    i = new Interval<Object>(Interval.getMinusInf(), false, right.getConstantValue(), true);
                    break;
                }
                case GREATER: {
                    i = new Interval<Object>(right.getConstantValue(), false, Interval.getPlusInf(), false);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    i = new Interval<Object>(right.getConstantValue(), true, Interval.getPlusInf(), false);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown comparison type: " + expr.getComparisonType());
                }
            }
            return new Predicate<Object>(i);
        }
        if (condition instanceof IsNullExpr) {
            return new Predicate<Object>(IsNullCondition.INSTANCE);
        }
        if (condition instanceof RegexExpr) {
            return new Predicate<String>(new RegexCondition(((RegexExpr)condition).getPattern()));
        }
        throw new IllegalStateException("Unexpected condition type: " + condition);
    }

    private void makeBooleanOperatorNode(BooleanOperatorExpr child, List<BENode> nodes, List<Integer> treeCounters, BENode node) {
        int index = nodes.size();
        nodes.add(node);
        List<BooleanExpr> children = child.getChildren();
        treeCounters.add(children.size());
        for (BooleanExpr c : children) {
            this.preorderTraversal(node, c, nodes, treeCounters);
        }
        node.setLocation(index, nodes.size());
    }
}

