/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex.be;

import java.util.List;
import org.infinispan.objectfilter.impl.predicateindex.FilterEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.Predicate;
import org.infinispan.objectfilter.impl.predicateindex.PredicateIndex;
import org.infinispan.objectfilter.impl.predicateindex.be.BENode;

public final class PredicateNode<AttributeId extends Comparable<AttributeId>>
extends BENode {
    private final Predicate predicate;
    private final boolean isNegated;
    private final boolean isRepeated;
    private final List<AttributeId> attributePath;
    private PredicateIndex.Subscription subscription;

    public PredicateNode(BENode parent, Predicate predicate, boolean isNegated, List<AttributeId> attributePath, boolean isRepeated) {
        super(parent);
        if (isNegated && predicate.getInterval() != null) {
            throw new IllegalArgumentException("Interval predicates should not be negated");
        }
        this.predicate = predicate;
        this.isNegated = isNegated;
        this.attributePath = attributePath;
        this.isRepeated = isRepeated;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public List<AttributeId> getAttributePath() {
        return this.attributePath;
    }

    public boolean isRepeated() {
        return this.isRepeated;
    }

    @Override
    public boolean handleChildValue(BENode child, boolean childValue, FilterEvalContext evalContext) {
        int value;
        if (child != null) {
            throw new IllegalArgumentException();
        }
        int n = value = childValue ? 0 : -1;
        if (evalContext.treeCounters[this.index] <= 0) {
            if (this.isRepeated && evalContext.treeCounters[this.index] == value) {
                return false;
            }
            throw new IllegalStateException("This should never be called again if the state of this node was previously decided.");
        }
        evalContext.treeCounters[this.index] = value;
        if (this.parent == null) {
            this.suspendSubscription(evalContext);
            return true;
        }
        return this.parent.handleChildValue(this, childValue, evalContext);
    }

    public void subscribe(PredicateIndex<AttributeId> predicateIndex, Predicate.Callback callback) {
        if (this.subscription != null) {
            throw new IllegalStateException("Already subscribed");
        }
        this.subscription = predicateIndex.addSubscriptionForPredicate(this, callback);
    }

    public void unsubscribe() {
        this.subscription.cancel();
        this.subscription = null;
    }

    @Override
    public void suspendSubscription(FilterEvalContext ctx) {
        this.subscription.suspend(ctx.matcherContext);
    }

    public String toString() {
        return "PredicateNode{attributePath=" + this.attributePath + ", predicate=" + this.predicate + ", isNegated=" + this.isNegated + ", isRepeated=" + this.isRepeated + '}';
    }
}

