/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan.impl;

import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.store.Directory;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.infinispan.CacheManagerService;
import org.hibernate.search.infinispan.InfinispanIntegration;
import org.hibernate.search.infinispan.logging.impl.Log;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.DirectoryProviderHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.infinispan.Cache;
import org.infinispan.lucene.directory.BuildContext;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;

public class InfinispanDirectoryProvider
implements DirectoryProvider<Directory> {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private ServiceManager serviceManager;
    private String directoryProviderName;
    private String metadataCacheName;
    private String dataCacheName;
    private String lockingCacheName;
    private Integer chunkSize;
    private Directory directory;
    private EmbeddedCacheManager cacheManager;

    public void initialize(String directoryProviderName, Properties properties, org.hibernate.search.spi.BuildContext context) {
        this.directoryProviderName = directoryProviderName;
        this.serviceManager = context.getServiceManager();
        this.cacheManager = ((CacheManagerService)this.serviceManager.requestService(CacheManagerService.class)).getEmbeddedCacheManager();
        this.metadataCacheName = InfinispanIntegration.getMetadataCacheName(properties);
        this.dataCacheName = InfinispanIntegration.getDataCacheName(properties);
        this.lockingCacheName = InfinispanIntegration.getLockingCacheName(properties);
        this.chunkSize = ConfigurationParseHelper.getIntValue((Properties)properties, (String)"chunk_size");
    }

    public void start(DirectoryBasedIndexManager indexManager) {
        log.debug("Starting InfinispanDirectory");
        this.cacheManager.startCaches(new String[]{this.metadataCacheName, this.dataCacheName, this.lockingCacheName});
        Cache metadataCache = this.cacheManager.getCache(this.metadataCacheName);
        Cache dataCache = this.cacheManager.getCache(this.dataCacheName);
        Cache lockingCache = this.cacheManager.getCache(this.lockingCacheName);
        BuildContext directoryBuildContext = DirectoryBuilder.newDirectoryInstance((Cache)metadataCache, (Cache)dataCache, (Cache)lockingCache, (String)this.directoryProviderName);
        if (this.chunkSize != null) {
            directoryBuildContext.chunkSize(this.chunkSize.intValue());
        }
        this.directory = directoryBuildContext.create();
        DirectoryProviderHelper.initializeIndexIfNeeded((Directory)this.directory);
        log.debugf("Initialized Infinispan index: '%s'", this.directoryProviderName);
    }

    public void stop() {
        try {
            this.directory.close();
        }
        catch (IOException e) {
            log.unableToCloseLuceneDirectory(this.directory, e);
        }
        this.serviceManager.releaseService(CacheManagerService.class);
        log.debug("Stopped InfinispanDirectory");
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }
}

