/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.BigDecimalBridge;
import org.hibernate.search.bridge.builtin.BigIntegerBridge;
import org.hibernate.search.bridge.builtin.BooleanBridge;
import org.hibernate.search.bridge.builtin.CharacterBridge;
import org.hibernate.search.bridge.builtin.ClassBridge;
import org.hibernate.search.bridge.builtin.DoubleBridge;
import org.hibernate.search.bridge.builtin.FloatBridge;
import org.hibernate.search.bridge.builtin.IntegerBridge;
import org.hibernate.search.bridge.builtin.LongBridge;
import org.hibernate.search.bridge.builtin.ShortBridge;
import org.hibernate.search.bridge.builtin.StringBridge;
import org.hibernate.search.bridge.builtin.UUIDBridge;
import org.hibernate.search.bridge.builtin.UriBridge;
import org.hibernate.search.bridge.builtin.UrlBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.impl.CalendarBridgeProvider;
import org.hibernate.search.bridge.impl.DateBridgeProvider;
import org.hibernate.search.bridge.spi.BridgeProvider;
import org.hibernate.search.engine.service.spi.ServiceManager;

public class BasicJDKTypesBridgeProvider
implements BridgeProvider {
    public static final TwoWayFieldBridge CHARACTER = new TwoWayString2FieldBridgeAdaptor(new CharacterBridge());
    public static final TwoWayFieldBridge DOUBLE = new TwoWayString2FieldBridgeAdaptor(new DoubleBridge());
    public static final TwoWayFieldBridge FLOAT = new TwoWayString2FieldBridgeAdaptor(new FloatBridge());
    public static final TwoWayFieldBridge SHORT = new TwoWayString2FieldBridgeAdaptor(new ShortBridge());
    public static final TwoWayFieldBridge INTEGER = new TwoWayString2FieldBridgeAdaptor(new IntegerBridge());
    public static final TwoWayFieldBridge LONG = new TwoWayString2FieldBridgeAdaptor(new LongBridge());
    public static final TwoWayFieldBridge BIG_INTEGER = new TwoWayString2FieldBridgeAdaptor(new BigIntegerBridge());
    public static final TwoWayFieldBridge BIG_DECIMAL = new TwoWayString2FieldBridgeAdaptor(new BigDecimalBridge());
    public static final TwoWayFieldBridge STRING = new TwoWayString2FieldBridgeAdaptor(new StringBridge());
    public static final TwoWayFieldBridge BOOLEAN = new TwoWayString2FieldBridgeAdaptor(new BooleanBridge());
    public static final TwoWayFieldBridge Url = new TwoWayString2FieldBridgeAdaptor(new UrlBridge());
    public static final TwoWayFieldBridge Uri = new TwoWayString2FieldBridgeAdaptor(new UriBridge());
    public static final TwoWayFieldBridge UUID = new TwoWayString2FieldBridgeAdaptor(new UUIDBridge());
    public volatile TwoWayFieldBridge clazz;
    private volatile Map<String, FieldBridge> builtInBridges = new HashMap<String, FieldBridge>();

    public BasicJDKTypesBridgeProvider(ServiceManager serviceManager) {
        this.clazz = new TwoWayString2FieldBridgeAdaptor(new ClassBridge(serviceManager));
        this.builtInBridges = new HashMap<String, FieldBridge>();
        this.builtInBridges.put(Character.class.getName(), CHARACTER);
        this.builtInBridges.put(Character.TYPE.getName(), CHARACTER);
        this.builtInBridges.put(Double.class.getName(), DOUBLE);
        this.builtInBridges.put(Double.TYPE.getName(), DOUBLE);
        this.builtInBridges.put(Float.class.getName(), FLOAT);
        this.builtInBridges.put(Float.TYPE.getName(), FLOAT);
        this.builtInBridges.put(Short.class.getName(), SHORT);
        this.builtInBridges.put(Short.TYPE.getName(), SHORT);
        this.builtInBridges.put(Integer.class.getName(), INTEGER);
        this.builtInBridges.put(Integer.TYPE.getName(), INTEGER);
        this.builtInBridges.put(Long.class.getName(), LONG);
        this.builtInBridges.put(Long.TYPE.getName(), LONG);
        this.builtInBridges.put(BigInteger.class.getName(), BIG_INTEGER);
        this.builtInBridges.put(BigDecimal.class.getName(), BIG_DECIMAL);
        this.builtInBridges.put(String.class.getName(), STRING);
        this.builtInBridges.put(Boolean.class.getName(), BOOLEAN);
        this.builtInBridges.put(Boolean.TYPE.getName(), BOOLEAN);
        this.builtInBridges.put(URL.class.getName(), Url);
        this.builtInBridges.put(URI.class.getName(), Uri);
        this.builtInBridges.put(UUID.class.getName(), UUID);
        this.builtInBridges.put(Date.class.getName(), DateBridgeProvider.DATE_MILLISECOND);
        this.builtInBridges.put(Calendar.class.getName(), CalendarBridgeProvider.CALENDAR_MILLISECOND);
        this.builtInBridges.put(Class.class.getName(), this.clazz);
    }

    @Override
    public FieldBridge provideFieldBridge(BridgeProvider.BridgeProviderContext bridgeProviderContext) {
        return this.builtInBridges.get(bridgeProviderContext.getReturnType().getName());
    }
}

