/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.lang.annotation.Annotation;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.DynamicBoost;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.DefaultBoostStrategy;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public final class AnnotationProcessingHelper {
    private AnnotationProcessingHelper() {
    }

    public static Field.Index getIndex(Index index, Analyze analyze, Norms norms) {
        if (Index.YES.equals((Object)index)) {
            if (Analyze.YES.equals((Object)analyze)) {
                if (Norms.YES.equals((Object)norms)) {
                    return Field.Index.ANALYZED;
                }
                return Field.Index.ANALYZED_NO_NORMS;
            }
            if (Norms.YES.equals((Object)norms)) {
                return Field.Index.NOT_ANALYZED;
            }
            return Field.Index.NOT_ANALYZED_NO_NORMS;
        }
        return Field.Index.NO;
    }

    public static Float getBoost(XProperty member, Annotation fieldAnn) {
        float computedBoost = 1.0f;
        Boost boostAnn = (Boost)member.getAnnotation(Boost.class);
        if (boostAnn != null) {
            computedBoost = boostAnn.value();
        }
        if (fieldAnn != null) {
            float boost;
            if (fieldAnn instanceof Field) {
                boost = ((Field)fieldAnn).boost().value();
            } else if (fieldAnn instanceof Spatial) {
                boost = ((Spatial)fieldAnn).boost().value();
            } else {
                AnnotationProcessingHelper.raiseAssertionOnIncorrectAnnotation(fieldAnn);
                boost = 0.0f;
            }
            computedBoost *= boost;
        }
        return Float.valueOf(computedBoost);
    }

    public static BoostStrategy getDynamicBoost(XAnnotatedElement element) {
        if (element == null) {
            return DefaultBoostStrategy.INSTANCE;
        }
        DynamicBoost boostAnnotation = (DynamicBoost)element.getAnnotation(DynamicBoost.class);
        if (boostAnnotation == null) {
            return DefaultBoostStrategy.INSTANCE;
        }
        Class<? extends BoostStrategy> boostStrategyClass = boostAnnotation.impl();
        return ClassLoaderHelper.instanceFromClass(BoostStrategy.class, boostStrategyClass, "boost strategy");
    }

    public static Field.TermVector getTermVector(TermVector vector) {
        switch (vector) {
            case NO: {
                return Field.TermVector.NO;
            }
            case YES: {
                return Field.TermVector.YES;
            }
            case WITH_OFFSETS: {
                return Field.TermVector.WITH_OFFSETS;
            }
            case WITH_POSITIONS: {
                return Field.TermVector.WITH_POSITIONS;
            }
            case WITH_POSITION_OFFSETS: {
                return Field.TermVector.WITH_POSITIONS_OFFSETS;
            }
        }
        throw new AssertionFailure("Unexpected TermVector: " + (Object)((Object)vector));
    }

    public static Analyzer getAnalyzer(org.hibernate.search.annotations.Analyzer analyzerAnn, ConfigContext configContext) {
        Class<Void> analyzerClass;
        Class<Void> clazz = analyzerClass = analyzerAnn == null ? Void.TYPE : analyzerAnn.impl();
        if (analyzerClass == Void.TYPE) {
            String definition;
            String string = definition = analyzerAnn == null ? "" : analyzerAnn.definition();
            if (StringHelper.isEmpty(definition)) {
                return null;
            }
            return configContext.buildLazyAnalyzer(definition);
        }
        try {
            return ClassLoaderHelper.analyzerInstanceFromClass(analyzerClass, configContext.getLuceneMatchVersion());
        }
        catch (ClassCastException e) {
            throw new SearchException("Lucene analyzer does not extend " + Analyzer.class.getName() + ": " + analyzerClass.getName(), e);
        }
        catch (Exception e) {
            throw new SearchException("Failed to instantiate lucene analyzer with type " + analyzerClass.getName(), e);
        }
    }

    public static Integer getPrecisionStep(NumericField numericFieldAnn) {
        return numericFieldAnn == null ? 4 : numericFieldAnn.precisionStep();
    }

    public static String getFieldName(Annotation fieldAnn) {
        String fieldName;
        if (fieldAnn instanceof Field) {
            fieldName = ((Field)fieldAnn).name();
        } else if (fieldAnn instanceof Spatial) {
            fieldName = ((Spatial)fieldAnn).name();
        } else {
            return AnnotationProcessingHelper.raiseAssertionOnIncorrectAnnotation(fieldAnn);
        }
        return fieldName;
    }

    private static String raiseAssertionOnIncorrectAnnotation(Annotation fieldAnn) {
        throw new AssertionFailure("Cannot instances other than @Field and @Spatial. Found: " + fieldAnn.getClass());
    }
}

