/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.query.dsl.SpatialMatchingContext;
import org.hibernate.search.query.dsl.SpatialTermination;
import org.hibernate.search.query.dsl.Unit;
import org.hibernate.search.query.dsl.WithinContext;
import org.hibernate.search.query.dsl.impl.ConnectedSpatialQueryBuilder;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.SpatialQueryContext;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;

public class ConnectedSpatialMatchingContext
implements SpatialMatchingContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final SpatialQueryContext spatialContext;

    public ConnectedSpatialMatchingContext(QueryBuildingContext queryContext, QueryCustomizer queryCustomizer, SpatialQueryContext spatialContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.spatialContext = spatialContext;
    }

    @Override
    public WithinContext within(double distance, Unit unit) {
        this.spatialContext.setRadius(distance, unit);
        return new ConnectedWithinContext(this);
    }

    private static final class ConnectedWithinContext
    implements WithinContext,
    WithinContext.LongitudeContext {
        private final ConnectedSpatialMatchingContext mother;
        private double latitude;

        public ConnectedWithinContext(ConnectedSpatialMatchingContext mother) {
            this.mother = mother;
        }

        @Override
        public SpatialTermination ofCoordinates(Coordinates coordinates) {
            this.mother.spatialContext.setCoordinates(coordinates);
            return new ConnectedSpatialQueryBuilder(this.mother.spatialContext, this.mother.queryCustomizer, this.mother.queryContext);
        }

        @Override
        public WithinContext.LongitudeContext ofLatitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        @Override
        public SpatialTermination andLongitude(double longitude) {
            this.mother.spatialContext.setCoordinates(Point.fromDegrees(this.latitude, longitude));
            return new ConnectedSpatialQueryBuilder(this.mother.spatialContext, this.mother.queryCustomizer, this.mother.queryContext);
        }
    }
}

