/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.query.fieldcache.impl.FieldLoadingStrategy;

public final class MultiStringFieldLoadingStrategy
implements FieldLoadingStrategy {
    private final String fieldName;
    private SortedSetDocValues sortedSetDocValues;

    public MultiStringFieldLoadingStrategy(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void loadNewCacheValues(AtomicReaderContext context) throws IOException {
        this.sortedSetDocValues = FieldCache.DEFAULT.getDocTermOrds(context.reader(), this.fieldName);
    }

    public String[] collect(int relativeDocId) {
        this.sortedSetDocValues.setDocument(relativeDocId);
        ArrayList<String> values = new ArrayList<String>();
        BytesRef bytesRef = new BytesRef();
        long ordinal = this.sortedSetDocValues.nextOrd();
        while (ordinal != -1L) {
            this.sortedSetDocValues.lookupOrd(ordinal, bytesRef);
            values.add(bytesRef.utf8ToString());
            ordinal = this.sortedSetDocValues.nextOrd();
        }
        return values.toArray(new String[values.size()]);
    }
}

