/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.impl;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.DirectoryProviderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class FSDirectoryProvider
implements DirectoryProvider<FSDirectory> {
    private static final Log log = LoggerFactory.make();
    private FSDirectory directory;
    private String indexName;

    @Override
    public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        boolean manual = "manual".equals(context.getIndexingStrategy());
        File indexDir = DirectoryProviderHelper.getVerifiedIndexDir(directoryProviderName, properties, !manual);
        try {
            this.indexName = indexDir.getCanonicalPath();
            this.directory = DirectoryProviderHelper.createFSIndex(indexDir, properties, context.getServiceManager());
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + directoryProviderName, e);
        }
    }

    @Override
    public void start(DirectoryBasedIndexManager indexManager) {
    }

    @Override
    public void stop() {
        try {
            this.directory.close();
        }
        catch (Exception e) {
            log.unableToCloseLuceneDirectory(this.directory.getDirectory(), e);
        }
    }

    @Override
    public FSDirectory getDirectory() {
        return this.directory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FSDirectoryProvider)) {
            return false;
        }
        return this.indexName.equals(((FSDirectoryProvider)obj).indexName);
    }

    public int hashCode() {
        int hash = 11;
        return 37 * hash + this.indexName.hashCode();
    }
}

