/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.hql.QueryParser;
import org.infinispan.objectfilter.FilterCallback;
import org.infinispan.objectfilter.FilterSubscription;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.FilterRegistry;
import org.infinispan.objectfilter.impl.FilterResultImpl;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.objectfilter.impl.hql.FilterProcessingChain;
import org.infinispan.objectfilter.impl.predicateindex.FilterEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.Predicate;
import org.infinispan.objectfilter.impl.predicateindex.PredicateIndex;
import org.infinispan.objectfilter.impl.predicateindex.be.BENode;
import org.infinispan.objectfilter.impl.predicateindex.be.PredicateNode;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanFilterNormalizer;
import org.infinispan.objectfilter.query.FilterQuery;
import org.infinispan.objectfilter.query.FilterQueryFactory;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;

abstract class BaseMatcher<TypeMetadata, AttributeId extends Comparable<AttributeId>>
implements Matcher {
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    private final QueryParser queryParser = new QueryParser();
    private final BooleanFilterNormalizer booleanFilterNormalizer = new BooleanFilterNormalizer();
    private final Map<String, FilterRegistry<AttributeId>> filtersByType = new HashMap<String, FilterRegistry<AttributeId>>();

    BaseMatcher() {
    }

    @Override
    public QueryFactory<Query> getQueryFactory() {
        return new FilterQueryFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void match(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        this.read.lock();
        try {
            MatcherEvalContext<AttributeId> ctx = this.startContext(instance, this.filtersByType.keySet());
            if (ctx != null) {
                FilterRegistry<AttributeId> filterRegistry = this.filtersByType.get(ctx.getEntityTypeName());
                filterRegistry.match(ctx);
            }
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public ObjectFilter getObjectFilter(Query query) {
        if (!(query instanceof FilterQuery)) {
            throw new IllegalArgumentException("The Query object must be created by a QueryFactory returned by this Matcher");
        }
        FilterQuery filterQuery = (FilterQuery)query;
        return this.getObjectFilter(filterQuery.getJpqlString());
    }

    @Override
    public ObjectFilter getObjectFilter(String jpaQuery) {
        FilterParsingResult<TypeMetadata> parsingResult = this.parse(jpaQuery);
        BooleanExpr normalizedFilter = this.booleanFilterNormalizer.normalize(parsingResult.getQuery());
        FilterRegistry<AttributeId> filterRegistry = this.createFilterRegistryForType(parsingResult.getTargetEntityMetadata());
        FilterSubscriptionImpl filterSubscriptionImpl = filterRegistry.addFilter(normalizedFilter, parsingResult.getProjections(), parsingResult.getSortFields(), new FilterCallback(){

            @Override
            public void onFilterResult(Object instance, Object[] projection, Comparable[] sortProjection) {
            }
        });
        return this.getObjectFilter(filterSubscriptionImpl);
    }

    @Override
    public ObjectFilter getObjectFilter(FilterSubscription filterSubscription) {
        final FilterSubscriptionImpl filterSubscriptionImpl = (FilterSubscriptionImpl)filterSubscription;
        final Set<String> knownTypes = Collections.singleton(filterSubscriptionImpl.getEntityTypeName());
        final PredicateIndex predicateIndex = new PredicateIndex(filterSubscriptionImpl.getMetadataAdapter());
        filterSubscriptionImpl.registerProjection(predicateIndex);
        for (BENode node : filterSubscriptionImpl.getBETree().getNodes()) {
            if (!(node instanceof PredicateNode)) continue;
            final PredicateNode predicateNode = (PredicateNode)node;
            Predicate.Callback predicateCallback = new Predicate.Callback(){

                @Override
                public void handleValue(MatcherEvalContext<?> ctx, boolean isMatching) {
                    FilterEvalContext filterEvalContext = ctx.getFilterEvalContext(filterSubscriptionImpl);
                    predicateNode.handleChildValue(null, isMatching, filterEvalContext);
                }
            };
            predicateIndex.addSubscriptionForPredicate(predicateNode, predicateCallback);
        }
        return new ObjectFilter(){

            @Override
            public String getEntityTypeName() {
                return filterSubscriptionImpl.getEntityTypeName();
            }

            @Override
            public String[] getProjection() {
                return filterSubscriptionImpl.getProjection();
            }

            @Override
            public SortField[] getSortFields() {
                return filterSubscriptionImpl.getSortFields();
            }

            @Override
            public Comparator<Comparable[]> getComparator() {
                return filterSubscriptionImpl.getComparator();
            }

            @Override
            public ObjectFilter.FilterResult filter(Object instance) {
                if (instance == null) {
                    throw new IllegalArgumentException("argument cannot be null");
                }
                MatcherEvalContext matcherEvalContext = BaseMatcher.this.startContext(instance, knownTypes);
                if (matcherEvalContext != null) {
                    FilterEvalContext filterEvalContext = matcherEvalContext.getFilterEvalContext(filterSubscriptionImpl);
                    matcherEvalContext.process(predicateIndex.getRoot());
                    if (filterEvalContext.getMatchResult()) {
                        return new FilterResultImpl(instance, filterEvalContext.getProjection(), filterEvalContext.getSortProjection());
                    }
                }
                return null;
            }
        };
    }

    @Override
    public FilterSubscription registerFilter(Query query, FilterCallback callback) {
        if (!(query instanceof FilterQuery)) {
            throw new IllegalArgumentException("The Query object must be created by a QueryFactory returned by this Matcher");
        }
        FilterQuery filterQuery = (FilterQuery)query;
        return this.registerFilter(filterQuery.getJpqlString(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterSubscription registerFilter(String jpaQuery, FilterCallback callback) {
        FilterParsingResult<TypeMetadata> parsingResult = this.parse(jpaQuery);
        BooleanExpr normalizedFilter = this.booleanFilterNormalizer.normalize(parsingResult.getQuery());
        this.write.lock();
        try {
            FilterRegistry<AttributeId> filterRegistry = this.filtersByType.get(parsingResult.getTargetEntityName());
            if (filterRegistry == null) {
                filterRegistry = this.createFilterRegistryForType(parsingResult.getTargetEntityMetadata());
                this.filtersByType.put(parsingResult.getTargetEntityName(), filterRegistry);
            }
            FilterSubscriptionImpl filterSubscriptionImpl = filterRegistry.addFilter(normalizedFilter, parsingResult.getProjections(), parsingResult.getSortFields(), callback);
            return filterSubscriptionImpl;
        }
        finally {
            this.write.unlock();
        }
    }

    private FilterParsingResult<TypeMetadata> parse(String jpaQuery) {
        return (FilterParsingResult)this.queryParser.parseQuery(jpaQuery, this.createFilterProcessingChain(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFilter(FilterSubscription filterSubscription) {
        FilterSubscriptionImpl filterSubscriptionImpl = (FilterSubscriptionImpl)filterSubscription;
        this.write.lock();
        try {
            FilterRegistry<AttributeId> filterRegistry = this.filtersByType.get(filterSubscriptionImpl.getEntityTypeName());
            if (filterRegistry == null) {
                throw new IllegalStateException("Reached illegal state");
            }
            filterRegistry.removeFilter(filterSubscription);
            if (filterRegistry.isEmpty()) {
                this.filtersByType.remove(filterRegistry.getTypeName());
            }
        }
        finally {
            this.write.unlock();
        }
    }

    protected abstract MatcherEvalContext<AttributeId> startContext(Object var1, Set<String> var2);

    protected abstract FilterProcessingChain<?> createFilterProcessingChain(Map<String, Object> var1);

    protected abstract FilterRegistry<AttributeId> createFilterRegistryForType(TypeMetadata var1);
}

