/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.objectfilter.FilterCallback;
import org.infinispan.objectfilter.FilterSubscription;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.predicateindex.FilterEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.Predicate;
import org.infinispan.objectfilter.impl.predicateindex.PredicateIndex;
import org.infinispan.objectfilter.impl.predicateindex.be.BENode;
import org.infinispan.objectfilter.impl.predicateindex.be.BETree;
import org.infinispan.objectfilter.impl.predicateindex.be.BETreeMaker;
import org.infinispan.objectfilter.impl.predicateindex.be.PredicateNode;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.util.StringHelper;

final class FilterRegistry<AttributeId extends Comparable<AttributeId>> {
    private final PredicateIndex<AttributeId> predicateIndex;
    private final List<FilterSubscriptionImpl> filterSubscriptions = new ArrayList<FilterSubscriptionImpl>();
    private final BETreeMaker<AttributeId> treeMaker;
    private final MetadataAdapter<?, AttributeId> metadataAdapter;

    public FilterRegistry(MetadataAdapter<?, AttributeId> metadataAdapter) {
        this.metadataAdapter = metadataAdapter;
        this.treeMaker = new BETreeMaker<AttributeId>(metadataAdapter);
        this.predicateIndex = new PredicateIndex<AttributeId>(metadataAdapter);
    }

    public String getTypeName() {
        return this.metadataAdapter.getTypeName();
    }

    public boolean isEmpty() {
        return this.filterSubscriptions.isEmpty();
    }

    public void match(MatcherEvalContext<AttributeId> ctx) {
        ctx.process(this.predicateIndex.getRoot());
        for (FilterSubscriptionImpl s : this.filterSubscriptions) {
            FilterEvalContext filterEvalContext = ctx.getFilterEvalContext(s);
            if (!filterEvalContext.getMatchResult()) continue;
            s.getCallback().onFilterResult(ctx.getInstance(), filterEvalContext.getProjection(), filterEvalContext.getSortProjection());
        }
    }

    public FilterSubscriptionImpl addFilter(BooleanExpr normalizedFilter, List<String> projection, List<SortField> sortFields, FilterCallback callback) {
        ArrayList translatedProjections = null;
        if (projection != null && !projection.isEmpty()) {
            translatedProjections = new ArrayList(projection.size());
            for (String projectionPath : projection) {
                translatedProjections.add(this.metadataAdapter.translatePropertyPath(StringHelper.splitPropertyPath(projectionPath)));
            }
        }
        ArrayList translatedSortFields = null;
        if (sortFields != null && !sortFields.isEmpty()) {
            translatedSortFields = new ArrayList(sortFields.size());
            for (SortField sortField : sortFields) {
                translatedSortFields.add(this.metadataAdapter.translatePropertyPath(StringHelper.splitPropertyPath(sortField.getPath())));
            }
        }
        BETree beTree = this.treeMaker.make(normalizedFilter);
        final FilterSubscriptionImpl<AttributeId> filterSubscription = new FilterSubscriptionImpl<AttributeId>(this.metadataAdapter, beTree, callback, projection, translatedProjections, sortFields, translatedSortFields);
        filterSubscription.registerProjection(this.predicateIndex);
        for (BENode node : beTree.getNodes()) {
            if (!(node instanceof PredicateNode)) continue;
            final PredicateNode predicateNode = (PredicateNode)node;
            Predicate.Callback predicateCallback = new Predicate.Callback(){

                @Override
                public void handleValue(MatcherEvalContext<?> ctx, boolean isMatching) {
                    FilterEvalContext filterEvalContext = ctx.getFilterEvalContext(filterSubscription);
                    predicateNode.handleChildValue(null, isMatching, filterEvalContext);
                }
            };
            predicateNode.subscribe(this.predicateIndex, predicateCallback);
        }
        this.filterSubscriptions.add(filterSubscription);
        return filterSubscription;
    }

    public void removeFilter(FilterSubscription filterSubscription) {
        FilterSubscriptionImpl filterSubscriptionImpl = (FilterSubscriptionImpl)filterSubscription;
        this.filterSubscriptions.remove(filterSubscriptionImpl);
        filterSubscriptionImpl.unregisterProjection(this.predicateIndex);
        for (BENode node : filterSubscriptionImpl.getBETree().getNodes()) {
            if (!(node instanceof PredicateNode)) continue;
            PredicateNode predicateNode = (PredicateNode)node;
            predicateNode.unsubscribe();
        }
    }
}

