/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.Comparator;
import java.util.List;
import org.infinispan.objectfilter.FilterCallback;
import org.infinispan.objectfilter.FilterSubscription;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.predicateindex.AttributeNode;
import org.infinispan.objectfilter.impl.predicateindex.PredicateIndex;
import org.infinispan.objectfilter.impl.predicateindex.be.BETree;
import org.infinispan.objectfilter.impl.util.ComparableArrayComparator;

public final class FilterSubscriptionImpl<AttributeId extends Comparable<AttributeId>>
implements FilterSubscription {
    private final MetadataAdapter metadataAdapter;
    private final BETree beTree;
    private final FilterCallback callback;
    private final String[] projection;
    private final List<List<AttributeId>> translatedProjection;
    private final SortField[] sortFields;
    private final List<List<AttributeId>> translatedSortProjection;
    private Comparator<Comparable[]> comparator;

    public FilterSubscriptionImpl(MetadataAdapter metadataAdapter, BETree beTree, FilterCallback callback, List<String> projection, List<List<AttributeId>> translatedProjection, List<SortField> sortFields, List<List<AttributeId>> translatedSortProjection) {
        this.metadataAdapter = metadataAdapter;
        this.beTree = beTree;
        this.callback = callback;
        this.projection = projection != null && !projection.isEmpty() ? projection.toArray(new String[projection.size()]) : null;
        this.sortFields = sortFields != null && !sortFields.isEmpty() ? sortFields.toArray(new SortField[sortFields.size()]) : null;
        this.translatedProjection = translatedProjection;
        this.translatedSortProjection = translatedSortProjection;
    }

    public BETree getBETree() {
        return this.beTree;
    }

    @Override
    public String getEntityTypeName() {
        return this.metadataAdapter.getTypeName();
    }

    public MetadataAdapter getMetadataAdapter() {
        return this.metadataAdapter;
    }

    @Override
    public FilterCallback getCallback() {
        return this.callback;
    }

    @Override
    public String[] getProjection() {
        return this.projection;
    }

    @Override
    public SortField[] getSortFields() {
        return this.sortFields;
    }

    @Override
    public Comparator<Comparable[]> getComparator() {
        if (this.sortFields != null && this.comparator == null) {
            boolean[] direction = new boolean[this.sortFields.length];
            for (int i = 0; i < this.sortFields.length; ++i) {
                direction[i] = this.sortFields[i].isAscending();
            }
            this.comparator = new ComparableArrayComparator(direction);
        }
        return this.comparator;
    }

    public void registerProjection(PredicateIndex<AttributeId> predicateIndex) {
        int i = 0;
        if (this.translatedProjection != null) {
            i = this.addProjections(predicateIndex, this.translatedProjection, i);
        }
        if (this.translatedSortProjection != null) {
            this.addProjections(predicateIndex, this.translatedSortProjection, i);
        }
    }

    public void unregisterProjection(PredicateIndex<AttributeId> predicateIndex) {
        if (this.translatedProjection != null) {
            this.removeProjections(predicateIndex, this.translatedProjection);
        }
        if (this.translatedSortProjection != null) {
            this.removeProjections(predicateIndex, this.translatedSortProjection);
        }
    }

    private int addProjections(PredicateIndex<AttributeId> predicateIndex, List<List<AttributeId>> projection, int i) {
        for (List<AttributeId> projectionPath : projection) {
            AttributeNode<AttributeId> node = predicateIndex.addAttributeNodeByPath(projectionPath);
            node.addProjection(this, i++);
        }
        return i;
    }

    private void removeProjections(PredicateIndex<AttributeId> predicateIndex, List<List<AttributeId>> projection) {
        for (List<AttributeId> projectionPath : projection) {
            AttributeNode<AttributeId> node = predicateIndex.getAttributeNodeByPath(projectionPath);
            node.removeProjections(this);
        }
    }
}

