/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql.predicate;

import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.RegexExpr;

class FilterLikePredicate
extends LikePredicate<BooleanExpr> {
    public FilterLikePredicate(String propertyName, String patternValue) {
        super(propertyName, patternValue, null);
    }

    public BooleanExpr getQuery() {
        return new RegexExpr(new PropertyValueExpr(this.propertyName), this.jpaWildcardToRegex(this.patternValue));
    }

    private String jpaWildcardToRegex(String jpaPattern) {
        StringBuilder sb = new StringBuilder(jpaPattern.length());
        sb.append('^');
        block5: for (int i = 0; i < jpaPattern.length(); ++i) {
            char c = jpaPattern.charAt(i);
            switch (c) {
                case '%': {
                    sb.append(".*");
                    continue block5;
                }
                case '_': {
                    sb.append('.');
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\');
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('$');
        return sb.toString();
    }
}

