/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.Predicate;
import org.infinispan.objectfilter.impl.predicateindex.PredicateIndex;
import org.infinispan.objectfilter.impl.util.ComparableComparator;
import org.infinispan.objectfilter.impl.util.IntervalTree;

final class Predicates<AttributeDomain> {
    private final boolean valueIsComparable;
    private IntervalTree<AttributeDomain, Subscriptions> orderedPredicates;
    private Map<Predicate<AttributeDomain>, Subscriptions> unorderedPredicates;

    Predicates(boolean valueIsComparable) {
        this.valueIsComparable = valueIsComparable;
    }

    public void notifyMatchingSubscribers(MatcherEvalContext<?> ctx, AttributeDomain attributeValue) {
        Subscriptions subscriptions;
        if (attributeValue instanceof Comparable && this.orderedPredicates != null) {
            for (IntervalTree.Node node : this.orderedPredicates.stab(attributeValue)) {
                subscriptions = (Subscriptions)node.value;
                if (!subscriptions.isActive(ctx)) continue;
                for (PredicateIndex.Subscription s : subscriptions.subscriptions) {
                    s.handleValue(ctx, true);
                }
            }
        }
        if (this.unorderedPredicates != null) {
            for (Map.Entry entry : this.unorderedPredicates.entrySet()) {
                subscriptions = (Subscriptions)entry.getValue();
                if (!subscriptions.isActive(ctx)) continue;
                boolean conditionSatisfied = ((Predicate)entry.getKey()).getCondition().match(attributeValue);
                for (PredicateIndex.Subscription s : subscriptions.subscriptions) {
                    s.handleValue(ctx, conditionSatisfied);
                }
            }
        }
    }

    public void addPredicate(PredicateIndex.Subscription subscription) {
        Subscriptions subscriptions;
        if (subscription.getPredicate().getInterval() != null) {
            if (this.orderedPredicates == null) {
                this.orderedPredicates = new IntervalTree(new ComparableComparator());
            }
            IntervalTree.Node<AttributeDomain, Subscriptions> n = this.orderedPredicates.add(subscription.getPredicate().getInterval());
            if (n.value == null) {
                subscriptions = new Subscriptions(subscription.getPredicate());
                n.value = subscriptions;
            } else {
                subscriptions = (Subscriptions)n.value;
            }
        } else {
            if (this.unorderedPredicates == null) {
                this.unorderedPredicates = new HashMap<Predicate<AttributeDomain>, Subscriptions>();
            }
            if ((subscriptions = this.unorderedPredicates.get(subscription.getPredicate())) == null) {
                subscriptions = new Subscriptions(subscription.getPredicate());
                this.unorderedPredicates.put(subscription.getPredicate(), subscriptions);
            }
        }
        subscriptions.add(subscription);
    }

    public void removePredicate(PredicateIndex.Subscription subscription) {
        if (subscription.getPredicate().getInterval() != null) {
            if (this.orderedPredicates != null) {
                IntervalTree.Node<AttributeDomain, Subscriptions> n = this.orderedPredicates.findNode(subscription.getPredicate().getInterval());
                if (n != null) {
                    ((Subscriptions)n.value).remove(subscription);
                    if (((Subscriptions)n.value).subscriptions.isEmpty()) {
                        this.orderedPredicates.remove(n);
                    }
                } else {
                    Predicates.throwIllegalStateException();
                }
            } else {
                Predicates.throwIllegalStateException();
            }
        } else if (this.unorderedPredicates != null) {
            Subscriptions subscriptions = this.unorderedPredicates.get(subscription.getPredicate());
            if (subscriptions != null) {
                subscriptions.remove(subscription);
                if (subscriptions.subscriptions.isEmpty()) {
                    this.unorderedPredicates.remove(subscription.getPredicate());
                }
            } else {
                Predicates.throwIllegalStateException();
            }
        } else {
            Predicates.throwIllegalStateException();
        }
    }

    public boolean isEmpty() {
        return !(this.unorderedPredicates != null && !this.unorderedPredicates.isEmpty() || this.orderedPredicates != null && !this.orderedPredicates.isEmpty());
    }

    private static void throwIllegalStateException() throws IllegalStateException {
        throw new IllegalStateException("Reached an invalid state");
    }

    private static class Subscriptions {
        private final Predicate predicate;
        private final List<PredicateIndex.Subscription> subscriptions = new ArrayList<PredicateIndex.Subscription>();

        private Subscriptions(Predicate predicate) {
            this.predicate = predicate;
        }

        void add(PredicateIndex.Subscription subscription) {
            this.subscriptions.add(subscription);
        }

        void remove(PredicateIndex.Subscription subscription) {
            this.subscriptions.remove(subscription);
        }

        boolean isActive(MatcherEvalContext<?> ctx) {
            return ctx.getSuspendedSubscriptionsCounter(this.predicate) < this.subscriptions.size();
        }
    }
}

