/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.predicateindex.FilterEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;

final class Projections {
    private List<Subscription> subscriptions = new ArrayList<Subscription>();

    Projections() {
    }

    void addProjection(FilterSubscriptionImpl filterSubscription, int position) {
        this.subscriptions.add(new Subscription(filterSubscription, position));
    }

    void removeProjections(FilterSubscriptionImpl filterSubscription) {
        Iterator<Subscription> it = this.subscriptions.iterator();
        while (it.hasNext()) {
            Subscription s = it.next();
            if (s.filterSubscription != filterSubscription) continue;
            it.remove();
        }
    }

    void processProjections(MatcherEvalContext<?> ctx, Object attributeValue) {
        for (Subscription s : this.subscriptions) {
            FilterEvalContext c = ctx.getFilterEvalContext(s.filterSubscription);
            Object[] projection = c.getProjection();
            int position = s.position;
            if (projection == null) {
                projection = c.getSortProjection();
            } else if (position >= projection.length) {
                position -= projection.length;
                projection = c.getSortProjection();
            }
            if (projection[position] != null) continue;
            projection[position] = attributeValue;
        }
    }

    public boolean hasProjections() {
        return !this.subscriptions.isEmpty();
    }

    private class Subscription {
        private final FilterSubscriptionImpl filterSubscription;
        private final int position;

        private Subscription(FilterSubscriptionImpl filterSubscription, int position) {
            this.filterSubscription = filterSubscription;
            this.position = position;
        }
    }
}

