/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import java.util.ArrayList;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.NoOpVisitor;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.RegexExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;

public final class BooleanFilterNormalizer {
    private final Visitor simplifierVisitor = new NoOpVisitor(){

        @Override
        public BooleanExpr visit(NotExpr notExpr) {
            return (BooleanExpr)notExpr.getChild().acceptVisitor(BooleanFilterNormalizer.this.deMorganVisitor);
        }

        @Override
        public BooleanExpr visit(OrExpr orExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(orExpr.getChildren().size());
            for (BooleanExpr child : orExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (!((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.TRUE;
                }
                if (child instanceof OrExpr) {
                    children.addAll(((OrExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new OrExpr(children);
        }

        @Override
        public BooleanExpr visit(AndExpr andExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(andExpr.getChildren().size());
            for (BooleanExpr child : andExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.FALSE;
                }
                if (child instanceof AndExpr) {
                    children.addAll(((AndExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new AndExpr(children);
        }

        @Override
        public BooleanExpr visit(ComparisonExpr comparisonExpr) {
            ValueExpr leftChild = comparisonExpr.getLeftChild();
            leftChild = (ValueExpr)leftChild.acceptVisitor(this);
            ValueExpr rightChild = comparisonExpr.getRightChild();
            rightChild = (ValueExpr)rightChild.acceptVisitor(this);
            ComparisonPredicate.Type comparisonType = comparisonExpr.getComparisonType();
            if (leftChild instanceof ConstantValueExpr) {
                if (rightChild instanceof ConstantValueExpr) {
                    Comparable leftValue = (Comparable)((ConstantValueExpr)leftChild).getConstantValue();
                    Comparable rightValue = (Comparable)((ConstantValueExpr)rightChild).getConstantValue();
                    int compRes = leftValue.compareTo(rightValue);
                    switch (comparisonType) {
                        case LESS: {
                            return ConstantBooleanExpr.forBoolean(compRes < 0);
                        }
                        case LESS_OR_EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes <= 0);
                        }
                        case EQUALS: {
                            return ConstantBooleanExpr.forBoolean(compRes == 0);
                        }
                        case GREATER_OR_EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes >= 0);
                        }
                        case GREATER: {
                            return ConstantBooleanExpr.forBoolean(compRes > 0);
                        }
                    }
                    throw new IllegalStateException("Unknown comparison type: " + comparisonType);
                }
                ValueExpr temp = rightChild;
                rightChild = leftChild;
                leftChild = temp;
                switch (comparisonType) {
                    case LESS: {
                        comparisonType = ComparisonPredicate.Type.GREATER;
                        break;
                    }
                    case LESS_OR_EQUAL: {
                        comparisonType = ComparisonPredicate.Type.GREATER_OR_EQUAL;
                        break;
                    }
                    case GREATER_OR_EQUAL: {
                        comparisonType = ComparisonPredicate.Type.LESS_OR_EQUAL;
                        break;
                    }
                    case GREATER: {
                        comparisonType = ComparisonPredicate.Type.LESS;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown comparison type: " + comparisonType);
                    }
                }
            }
            return new ComparisonExpr(leftChild, rightChild, comparisonType);
        }
    };
    private final Visitor deMorganVisitor = new NoOpVisitor(){

        @Override
        public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
            return constantBooleanExpr.negate();
        }

        @Override
        public BooleanExpr visit(NotExpr notExpr) {
            return (BooleanExpr)notExpr.getChild().acceptVisitor(BooleanFilterNormalizer.this.simplifierVisitor);
        }

        @Override
        public BooleanExpr visit(OrExpr orExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(orExpr.getChildren().size());
            for (BooleanExpr child : orExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.FALSE;
                }
                if (child instanceof AndExpr) {
                    children.addAll(((AndExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new AndExpr(children);
        }

        @Override
        public BooleanExpr visit(AndExpr andExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(andExpr.getChildren().size());
            for (BooleanExpr child : andExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (!((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.TRUE;
                }
                if (child instanceof OrExpr) {
                    children.addAll(((OrExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new OrExpr(children);
        }

        @Override
        public BooleanExpr visit(ComparisonExpr comparisonExpr) {
            BooleanExpr booleanExpr = comparisonExpr.acceptVisitor(BooleanFilterNormalizer.this.simplifierVisitor);
            if (booleanExpr instanceof ConstantBooleanExpr) {
                return ((ConstantBooleanExpr)booleanExpr).negate();
            }
            if (booleanExpr instanceof NotExpr) {
                return ((NotExpr)booleanExpr).getChild();
            }
            if (booleanExpr instanceof ComparisonExpr) {
                ComparisonExpr c = (ComparisonExpr)booleanExpr;
                switch (c.getComparisonType()) {
                    case LESS: {
                        return new ComparisonExpr(c.getLeftChild(), c.getRightChild(), ComparisonPredicate.Type.GREATER_OR_EQUAL);
                    }
                    case LESS_OR_EQUAL: {
                        return new ComparisonExpr(c.getLeftChild(), c.getRightChild(), ComparisonPredicate.Type.GREATER);
                    }
                    case GREATER_OR_EQUAL: {
                        return new ComparisonExpr(c.getLeftChild(), c.getRightChild(), ComparisonPredicate.Type.LESS);
                    }
                    case GREATER: {
                        return new ComparisonExpr(c.getLeftChild(), c.getRightChild(), ComparisonPredicate.Type.LESS_OR_EQUAL);
                    }
                    case EQUALS: {
                        return new OrExpr(new ComparisonExpr(c.getLeftChild(), c.getRightChild(), ComparisonPredicate.Type.LESS), new ComparisonExpr(c.getLeftChild(), c.getRightChild(), ComparisonPredicate.Type.GREATER), new IsNullExpr(c.getLeftChild()));
                    }
                }
                throw new IllegalStateException("Unknown comparison type: " + c.getComparisonType());
            }
            return new NotExpr(booleanExpr);
        }

        @Override
        public BooleanExpr visit(IsNullExpr isNullExpr) {
            return new NotExpr(isNullExpr);
        }

        @Override
        public BooleanExpr visit(RegexExpr regexExpr) {
            return new NotExpr(regexExpr);
        }
    };

    public BooleanExpr normalize(BooleanExpr booleanExpr) {
        return (BooleanExpr)booleanExpr.acceptVisitor(this.simplifierVisitor);
    }
}

