/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.Collections;
import java.util.List;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.Option;

public final class EnumValueDescriptor {
    private final String name;
    private final int number;
    private final List<Option> options;
    private FileDescriptor fileDescriptor;

    private EnumValueDescriptor(Builder builder) {
        this.name = builder.name;
        this.number = builder.number;
        this.options = Collections.unmodifiableList(builder.options);
    }

    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.number;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
    }

    public static class Builder {
        private String name;
        private int number;
        private List<Option> options;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withTag(int tag) {
            this.number = tag;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public EnumValueDescriptor build() {
            return new EnumValueDescriptor(this);
        }
    }
}

