/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TakeOfflineConfigurationBuilder;
import org.infinispan.configuration.cache.XSiteStateTransferConfigurationBuilder;

public class BackupConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<BackupConfiguration> {
    private String site;
    private BackupConfiguration.BackupStrategy strategy = BackupConfiguration.BackupStrategy.ASYNC;
    private long replicationTimeout = 10000L;
    private BackupFailurePolicy backupFailurePolicy = BackupFailurePolicy.WARN;
    private String failurePolicyClass;
    private boolean useTwoPhaseCommit = false;
    private TakeOfflineConfigurationBuilder takeOfflineBuilder;
    private boolean enabled = true;
    private XSiteStateTransferConfigurationBuilder stateTransferBuilder;

    public BackupConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.takeOfflineBuilder = new TakeOfflineConfigurationBuilder(builder, this);
        this.stateTransferBuilder = new XSiteStateTransferConfigurationBuilder(builder, this);
    }

    public BackupConfigurationBuilder site(String site) {
        this.site = site;
        return this;
    }

    public String site() {
        return this.site;
    }

    public String failurePolicyClass() {
        return this.failurePolicyClass;
    }

    public BackupConfigurationBuilder failurePolicyClass(String failurePolicy) {
        this.failurePolicyClass = failurePolicy;
        return this;
    }

    public BackupConfigurationBuilder replicationTimeout(long replicationTimeout) {
        this.replicationTimeout = replicationTimeout;
        return this;
    }

    public long replicationTimeout() {
        return this.replicationTimeout;
    }

    public BackupConfigurationBuilder strategy(BackupConfiguration.BackupStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public BackupConfiguration.BackupStrategy strategy() {
        return this.strategy;
    }

    public TakeOfflineConfigurationBuilder takeOffline() {
        return this.takeOfflineBuilder;
    }

    public BackupConfigurationBuilder backupFailurePolicy(BackupFailurePolicy backupFailurePolicy) {
        this.backupFailurePolicy = backupFailurePolicy;
        return this;
    }

    public BackupFailurePolicy backupFailurePolicy() {
        return this.backupFailurePolicy;
    }

    public BackupConfigurationBuilder useTwoPhaseCommit(boolean useTwoPhaseCommit) {
        this.useTwoPhaseCommit = useTwoPhaseCommit;
        return this;
    }

    public BackupConfigurationBuilder enabled(boolean isEnabled) {
        this.enabled = isEnabled;
        return this;
    }

    public XSiteStateTransferConfigurationBuilder stateTransfer() {
        return this.stateTransferBuilder;
    }

    public void validate() {
        this.takeOfflineBuilder.validate();
        this.stateTransferBuilder.validate();
        if (this.site == null) {
            throw new CacheConfigurationException("The 'site' must be specified!");
        }
        if (this.backupFailurePolicy == BackupFailurePolicy.CUSTOM && this.failurePolicyClass == null) {
            throw new CacheConfigurationException("It is required to specify a 'failurePolicyClass' when using a custom backup failure policy!");
        }
    }

    public BackupConfiguration create() {
        return new BackupConfiguration(this.site, this.strategy, this.replicationTimeout, this.backupFailurePolicy, this.failurePolicyClass, this.useTwoPhaseCommit, this.takeOfflineBuilder.create(), this.stateTransferBuilder.create(), this.enabled);
    }

    public Builder read(BackupConfiguration template) {
        this.takeOfflineBuilder.read(template.takeOffline());
        this.stateTransferBuilder.read(template.stateTransfer());
        this.site = template.site();
        this.strategy = template.strategy();
        this.backupFailurePolicy = template.backupFailurePolicy();
        this.replicationTimeout = template.replicationTimeout();
        this.failurePolicyClass = template.failurePolicyClass();
        this.useTwoPhaseCommit = template.isTwoPhaseCommit();
        this.enabled = template.enabled();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupConfigurationBuilder)) {
            return false;
        }
        BackupConfigurationBuilder that = (BackupConfigurationBuilder)o;
        if (this.replicationTimeout != that.replicationTimeout) {
            return false;
        }
        if (this.backupFailurePolicy != that.backupFailurePolicy) {
            return false;
        }
        if (this.failurePolicyClass != null ? !this.failurePolicyClass.equals(that.failurePolicyClass) : that.failurePolicyClass != null) {
            return false;
        }
        if (this.site != null ? !this.site.equals(that.site) : that.site != null) {
            return false;
        }
        if (this.strategy != that.strategy) {
            return false;
        }
        if (this.takeOfflineBuilder != null ? !this.takeOfflineBuilder.equals(that.takeOfflineBuilder) : that.takeOfflineBuilder != null) {
            return false;
        }
        if (this.useTwoPhaseCommit != that.useTwoPhaseCommit) {
            return false;
        }
        if (this.enabled != that.enabled) {
            return false;
        }
        return !(this.stateTransferBuilder != null ? !this.stateTransferBuilder.equals(that.stateTransferBuilder) : that.stateTransferBuilder != null);
    }

    public int hashCode() {
        int result = this.site != null ? this.site.hashCode() : 0;
        result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
        result = 31 * result + (int)(this.replicationTimeout ^ this.replicationTimeout >>> 32);
        result = 31 * result + (this.backupFailurePolicy != null ? this.backupFailurePolicy.hashCode() : 0);
        result = 31 * result + (this.failurePolicyClass != null ? this.failurePolicyClass.hashCode() : 0);
        result = 31 * result + (this.takeOfflineBuilder != null ? this.takeOfflineBuilder.hashCode() : 0);
        result = 31 * result + (this.stateTransferBuilder != null ? this.stateTransferBuilder.hashCode() : 0);
        result = 31 * result + (this.useTwoPhaseCommit ? 1 : 0);
        return result;
    }

    public String toString() {
        return "BackupConfigurationBuilder{site='" + this.site + '\'' + ", strategy=" + (Object)((Object)this.strategy) + ", replicationTimeout=" + this.replicationTimeout + ", useTwoPhaseCommit=" + this.useTwoPhaseCommit + ", backupFailurePolicy=" + (Object)((Object)this.backupFailurePolicy) + ", failurePolicyClass='" + this.failurePolicyClass + '\'' + ", takeOfflineBuilder=" + this.takeOfflineBuilder + ", stateTransferBuilder=" + this.stateTransferBuilder + ", enabled=" + this.enabled + '}';
    }
}

