/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PartitionHandlingConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<PartitionHandlingConfiguration> {
    private static Log log = LogFactory.getLog(PartitionHandlingConfigurationBuilder.class);
    private boolean enabled;

    public PartitionHandlingConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public PartitionHandlingConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void validate() {
        if (this.enabled && this.clustering().cacheMode().isReplicated()) {
            log.warnPartitionHandlingForReplicatedCaches();
        }
    }

    public PartitionHandlingConfiguration create() {
        return new PartitionHandlingConfiguration(this.enabled);
    }

    public Builder<?> read(PartitionHandlingConfiguration template) {
        this.enabled = template.enabled();
        return this;
    }
}

