/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<StateTransferConfiguration> {
    private static final Log log = LogFactory.getLog(StateTransferConfigurationBuilder.class);
    private Boolean fetchInMemoryState = null;
    private Boolean awaitInitialTransfer = null;
    private int chunkSize = 512;
    private long timeout = TimeUnit.MINUTES.toMillis(4L);

    StateTransferConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public StateTransferConfigurationBuilder fetchInMemoryState(boolean b) {
        this.fetchInMemoryState = b;
        return this;
    }

    public StateTransferConfigurationBuilder awaitInitialTransfer(boolean b) {
        this.awaitInitialTransfer = b;
        return this;
    }

    public StateTransferConfigurationBuilder chunkSize(int i) {
        this.chunkSize = i;
        return this;
    }

    public StateTransferConfigurationBuilder timeout(long l) {
        this.timeout = l;
        return this;
    }

    public StateTransferConfigurationBuilder timeout(long l, TimeUnit unit) {
        return this.timeout(unit.toMillis(l));
    }

    public void validate() {
        if (this.chunkSize <= 0) {
            throw new CacheConfigurationException("chunkSize can not be <= 0");
        }
        if (this.awaitInitialTransfer != null && this.awaitInitialTransfer.booleanValue() && !this.getClusteringBuilder().cacheMode().isReplicated() && !this.getClusteringBuilder().cacheMode().isDistributed()) {
            throw new CacheConfigurationException("awaitInitialTransfer can be enabled only if cache mode is distributed or replicated.");
        }
    }

    public StateTransferConfiguration create() {
        boolean _awaitInitialTransfer;
        boolean _fetchInMemoryState;
        CacheMode cacheMode = this.getClusteringBuilder().cacheMode();
        if (this.fetchInMemoryState != null) {
            _fetchInMemoryState = this.fetchInMemoryState;
        } else if (cacheMode.isReplicated() || cacheMode.isDistributed()) {
            log.trace("Cache is distributed or replicated but state transfer was not defined, enabling it by default");
            _fetchInMemoryState = true;
        } else {
            _fetchInMemoryState = false;
        }
        if (this.awaitInitialTransfer != null) {
            _awaitInitialTransfer = this.awaitInitialTransfer;
        } else if (cacheMode.isClustered()) {
            log.trace("Cache is distributed or replicated but awaitInitialTransfer was not defined, enabling it by default");
            _awaitInitialTransfer = true;
        } else {
            _awaitInitialTransfer = false;
        }
        return new StateTransferConfiguration(_fetchInMemoryState, this.fetchInMemoryState, this.timeout, this.chunkSize, _awaitInitialTransfer, this.awaitInitialTransfer);
    }

    public StateTransferConfigurationBuilder read(StateTransferConfiguration template) {
        this.fetchInMemoryState = template.originalFetchInMemoryState();
        this.awaitInitialTransfer = template.originalAwaitInitialTransfer();
        this.timeout = template.timeout();
        this.chunkSize = template.chunkSize();
        return this;
    }

    public String toString() {
        return "StateTransferConfigurationBuilder{chunkSize=" + this.chunkSize + ", fetchInMemoryState=" + this.fetchInMemoryState + ", awaitInitialTransfer=" + this.awaitInitialTransfer + ", timeout=" + this.timeout + '}';
    }
}

