/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.CancelCommand;
import org.infinispan.commands.CancellationService;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.read.MapCombineCommand;
import org.infinispan.commands.read.ReduceCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.FutureListener;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.commons.util.concurrent.NotifyingFutureImpl;
import org.infinispan.commons.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.distexec.mapreduce.Collator;
import org.infinispan.distexec.mapreduce.MapReduceManager;
import org.infinispan.distexec.mapreduce.MapReduceManagerImpl;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distexec.mapreduce.SecurityActions;
import org.infinispan.distexec.mapreduce.spi.MapReduceTaskLifecycleService;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptionsBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MapReduceTask<KIn, VIn, KOut, VOut> {
    private static final Log log = LogFactory.getLog(MapReduceTask.class);
    public static final String DEFAULT_TMP_CACHE_CONFIGURATION_NAME = "__tmpMapReduce";
    protected Mapper<KIn, VIn, KOut, VOut> mapper;
    protected Reducer<KOut, VOut> reducer;
    protected Reducer<KOut, VOut> combiner;
    protected final boolean distributeReducePhase;
    protected boolean useIntermediateSharedCache;
    protected final Collection<KIn> keys;
    protected final AdvancedCache<KIn, VIn> cache;
    protected final Marshaller marshaller;
    protected final MapReduceManager mapReduceManager;
    protected final CancellationService cancellationService;
    protected final List<CancellableTaskPart> cancellableTasks;
    protected final UUID taskId;
    protected final ClusteringDependentLogic clusteringDependentLogic;
    protected final boolean isLocalOnly;
    protected RpcOptionsBuilder rpcOptionsBuilder;
    protected String customIntermediateCacheName;
    protected String intermediateCacheConfigurationName = "__tmpMapReduce";
    private static final int MAX_COLLECTOR_SIZE = 1000;

    public MapReduceTask(Cache<KIn, VIn> masterCacheNode) {
        this(masterCacheNode, false, false);
    }

    public MapReduceTask(Cache<KIn, VIn> masterCacheNode, boolean distributeReducePhase) {
        this(masterCacheNode, distributeReducePhase, true);
    }

    public MapReduceTask(Cache<KIn, VIn> masterCacheNode, boolean distributeReducePhase, boolean useIntermediateSharedCache) {
        if (masterCacheNode == null) {
            throw new IllegalArgumentException("Can not use null cache for MapReduceTask");
        }
        this.ensureAccessPermissions(masterCacheNode.getAdvancedCache());
        this.ensureProperCacheState(masterCacheNode.getAdvancedCache());
        this.cache = masterCacheNode.getAdvancedCache();
        this.keys = new LinkedList<KIn>();
        ComponentRegistry componentRegistry = SecurityActions.getCacheComponentRegistry(this.cache);
        this.marshaller = (Marshaller)componentRegistry.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
        this.mapReduceManager = componentRegistry.getComponent(MapReduceManager.class);
        this.cancellationService = componentRegistry.getComponent(CancellationService.class);
        this.taskId = UUID.randomUUID();
        this.customIntermediateCacheName = useIntermediateSharedCache ? DEFAULT_TMP_CACHE_CONFIGURATION_NAME : this.taskId.toString();
        this.distributeReducePhase = distributeReducePhase;
        this.useIntermediateSharedCache = useIntermediateSharedCache;
        this.cancellableTasks = Collections.synchronizedList(new ArrayList());
        this.clusteringDependentLogic = componentRegistry.getComponent(ClusteringDependentLogic.class);
        this.isLocalOnly = SecurityActions.getCacheRpcManager(this.cache) == null;
        RpcOptionsBuilder rpcOptionsBuilder = this.rpcOptionsBuilder = this.isLocalOnly ? null : new RpcOptionsBuilder(SecurityActions.getCacheRpcManager(this.cache).getDefaultRpcOptions(true));
        if (!this.isLocalOnly) {
            this.rpcOptionsBuilder.timeout(0L, TimeUnit.MILLISECONDS);
        }
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> onKeys(KIn ... input) {
        Collections.addAll(this.keys, input);
        return this;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> mappedWith(Mapper<KIn, VIn, KOut, VOut> mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("A valid reference of Mapper is needed");
        }
        this.mapper = mapper;
        return this;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> reducedWith(Reducer<KOut, VOut> reducer) {
        if (reducer == null) {
            throw new IllegalArgumentException("A valid reference of Reducer is needed");
        }
        this.reducer = reducer;
        return this;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> combinedWith(Reducer<KOut, VOut> combiner) {
        if (combiner == null) {
            throw new IllegalArgumentException("A valid reference of Reducer/Combiner is needed");
        }
        this.combiner = combiner;
        return this;
    }

    public final MapReduceTask<KIn, VIn, KOut, VOut> timeout(long timeout, TimeUnit unit) {
        this.rpcOptionsBuilder.timeout(timeout, unit);
        return this;
    }

    public final long timeout(TimeUnit outputTimeUnit) {
        return this.rpcOptionsBuilder.timeout(outputTimeUnit);
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> usingIntermediateCache(String cacheConfigurationName) {
        if (cacheConfigurationName == null || cacheConfigurationName.isEmpty()) {
            throw new IllegalArgumentException("Invalid configuration name " + cacheConfigurationName + ", cacheConfigurationName cannot be null or empty");
        }
        this.intermediateCacheConfigurationName = cacheConfigurationName;
        this.useIntermediateSharedCache = false;
        return this;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> usingSharedIntermediateCache(String cacheName) {
        if (cacheName == null || cacheName.isEmpty()) {
            throw new IllegalArgumentException("Invalid cache name" + cacheName + ", cache name cannot be null or empty");
        }
        this.customIntermediateCacheName = cacheName;
        this.useIntermediateSharedCache = true;
        return this;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> usingSharedIntermediateCache(String cacheName, String cacheConfigurationName) {
        if (cacheConfigurationName == null || cacheConfigurationName.isEmpty()) {
            throw new IllegalArgumentException("Invalid configuration name " + cacheConfigurationName + ", cacheConfigurationName cannot be null or empty");
        }
        if (cacheName == null || cacheName.isEmpty()) {
            throw new IllegalArgumentException("Invalid cache name" + cacheName + ", cache name cannot be null or empty");
        }
        this.customIntermediateCacheName = cacheName;
        this.intermediateCacheConfigurationName = cacheConfigurationName;
        this.useIntermediateSharedCache = true;
        return this;
    }

    public Map<KOut, VOut> execute() throws CacheException {
        return this.executeHelper(null);
    }

    public void execute(Cache<KOut, VOut> resultsCache) throws CacheException {
        this.executeHelper(resultsCache.getName());
    }

    public void execute(String resultsCache) throws CacheException {
        if (resultsCache == null || resultsCache.isEmpty()) {
            throw new IllegalArgumentException("Results cache can not be " + resultsCache);
        }
        this.executeHelper(resultsCache);
    }

    protected Map<KOut, VOut> executeHelper(String resultCache) throws NullPointerException, CacheException {
        this.ensureAccessPermissions(this.cache);
        if (this.mapper == null) {
            throw new NullPointerException("A valid reference of Mapper is not set " + this.mapper);
        }
        if (this.reducer == null) {
            throw new NullPointerException("A valid reference of Reducer is not set " + this.reducer);
        }
        Map<Object, Object> result = null;
        if (!this.isLocalOnly && this.distributeReducePhase()) {
            try {
                this.executeTaskInit(this.getIntermediateCacheName());
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
            Set<KOut> allMapPhasesResponses = null;
            try {
                allMapPhasesResponses = this.executeMapPhase();
                result = this.executeReducePhase(resultCache, allMapPhasesResponses, this.useIntermediateSharedCache());
            }
            catch (Exception cause) {
                throw new CacheException((Throwable)cause);
            }
            finally {
                EmbeddedCacheManager cm = this.cache.getCacheManager();
                String intermediateCache = this.getIntermediateCacheName();
                if (this.useIntermediatePerTaskCache()) {
                    cm.removeCache(intermediateCache);
                } else {
                    Cache sharedTmpCache = cm.getCache(intermediateCache);
                    if (sharedTmpCache != null && allMapPhasesResponses != null) {
                        for (KOut k : allMapPhasesResponses) {
                            sharedTmpCache.removeAsync(new MapReduceManagerImpl.IntermediateKey<KOut>(this.taskId.toString(), k));
                        }
                    }
                }
            }
        }
        try {
            if (resultCache == null || resultCache.isEmpty()) {
                result = new HashMap();
                this.executeMapPhaseWithLocalReduction(result);
            } else {
                EmbeddedCacheManager cm = this.cache.getCacheManager();
                Cache c = cm.getCache(resultCache);
                this.executeMapPhaseWithLocalReduction((Map<KOut, VOut>)((Object)c));
            }
        }
        catch (Exception cause) {
            throw new CacheException((Throwable)cause);
        }
        return result;
    }

    protected String getIntermediateCacheName() {
        return this.customIntermediateCacheName;
    }

    protected boolean distributeReducePhase() {
        return this.distributeReducePhase;
    }

    protected boolean useIntermediateSharedCache() {
        return this.useIntermediateSharedCache;
    }

    protected boolean useIntermediatePerTaskCache() {
        return !this.useIntermediateSharedCache();
    }

    protected void executeTaskInit(String tmpCacheName) throws Exception {
        RpcManager rpc = this.cache.getRpcManager();
        CommandsFactory factory = this.cache.getComponentRegistry().getComponent(CommandsFactory.class);
        final CreateCacheCommand ccc = factory.buildCreateCacheCommand(tmpCacheName, this.intermediateCacheConfigurationName, true, rpc.getMembers().size());
        log.debugf("Invoking %s across members %s ", ccc, this.cache.getRpcManager().getMembers());
        Future<Object> future = this.mapReduceManager.getExecutorService().submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ccc.init(MapReduceTask.this.cache.getCacheManager());
                try {
                    return ccc.perform(null);
                }
                catch (Throwable e) {
                    throw new CacheException("Could not initialize temporary caches for MapReduce task on remote nodes ", e);
                }
            }
        });
        future.get();
        rpc.invokeRemotely(this.cache.getRpcManager().getMembers(), (ReplicableCommand)ccc, this.rpcOptionsBuilder.build());
        Map<Address, Response> map = rpc.invokeRemotely(this.cache.getRpcManager().getMembers(), (ReplicableCommand)ccc, this.rpcOptionsBuilder.build());
        for (Map.Entry<Address, Response> e : map.entrySet()) {
            if (e.getValue().isSuccessful()) continue;
            throw new IllegalStateException("Could not initialize tmp cache " + tmpCacheName + " at " + e.getKey() + " for  " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<KOut> executeMapPhase() throws InterruptedException, ExecutionException {
        RpcManager rpc = this.cache.getRpcManager();
        MapCombineCommand<KIn, VIn, KOut, VOut> cmd = null;
        HashSet mapPhasesResult = new HashSet();
        ArrayList futures = new ArrayList();
        if (this.inputTaskKeysEmpty()) {
            for (Address address : rpc.getMembers()) {
                cmd = address.equals(rpc.getAddress()) ? this.buildMapCombineCommand(this.taskId.toString(), this.clone(this.mapper), this.clone(this.combiner), this.getIntermediateCacheName(), null, true, this.useIntermediateSharedCache()) : this.buildMapCombineCommand(this.taskId.toString(), this.mapper, this.combiner, this.getIntermediateCacheName(), null, true, this.useIntermediateSharedCache());
                MapTaskPart part = this.createTaskMapPart(cmd, address, true);
                part.execute();
                futures.add(part);
            }
        } else {
            Map<Address, Collection<KIn>> keysToNodes = this.mapKeysToNodes(this.keys);
            for (Map.Entry<Address, Collection<KIn>> e : keysToNodes.entrySet()) {
                Address address = e.getKey();
                Collection<KIn> keys = e.getValue();
                cmd = address.equals(rpc.getAddress()) ? this.buildMapCombineCommand(this.taskId.toString(), this.clone(this.mapper), this.clone(this.combiner), this.getIntermediateCacheName(), keys, true, this.useIntermediateSharedCache()) : this.buildMapCombineCommand(this.taskId.toString(), this.mapper, this.combiner, this.getIntermediateCacheName(), keys, true, this.useIntermediateSharedCache());
                MapTaskPart part = this.createTaskMapPart(cmd, address, true);
                part.execute();
                futures.add(part);
            }
        }
        try {
            for (MapTaskPart mapTaskPart : futures) {
                Set result = null;
                try {
                    result = (Set)mapTaskPart.get();
                }
                catch (ExecutionException ee) {
                    Throwable cause = ee.getCause();
                    if (cause instanceof org.infinispan.util.concurrent.TimeoutException) {
                        throw new ExecutionException("Map phase executing at " + mapTaskPart.getAddress() + " did not complete within " + this.rpcOptionsBuilder.timeout(TimeUnit.SECONDS) + " sec timeout", cause);
                    }
                    throw ee;
                }
                mapPhasesResult.addAll(result);
            }
        }
        finally {
            this.cancellableTasks.clear();
        }
        return mapPhasesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeMapPhaseWithLocalReduction(Map<KOut, VOut> reducedResult) throws InterruptedException, ExecutionException {
        RpcManager rpc = SecurityActions.getCacheRpcManager(this.cache);
        MapCombineCommand<KIn, VIn, KOut, VOut> cmd = null;
        HashMap mapPhasesResult = new HashMap();
        ArrayList futures = new ArrayList();
        Address localAddress = this.clusteringDependentLogic.getAddress();
        if (this.inputTaskKeysEmpty()) {
            List<Address> targets = this.isLocalOnly ? Collections.singletonList(localAddress) : rpc.getMembers();
            for (Address address : targets) {
                cmd = address.equals(localAddress) ? this.buildMapCombineCommand(this.taskId.toString(), this.clone(this.mapper), this.clone(this.combiner), this.getIntermediateCacheName(), null, false, false) : this.buildMapCombineCommand(this.taskId.toString(), this.mapper, this.combiner, this.getIntermediateCacheName(), null, false, false);
                MapTaskPart part = this.createTaskMapPart(cmd, address, false);
                part.execute();
                futures.add(part);
            }
        } else {
            Map<Address, Collection<KIn>> keysToNodes = this.mapKeysToNodes(this.keys);
            for (Map.Entry<Address, Collection<KIn>> entry : keysToNodes.entrySet()) {
                Address address = entry.getKey();
                Collection<KIn> keys = entry.getValue();
                cmd = address.equals(localAddress) ? this.buildMapCombineCommand(this.taskId.toString(), this.clone(this.mapper), this.clone(this.combiner), this.getIntermediateCacheName(), keys, false, false) : this.buildMapCombineCommand(this.taskId.toString(), this.mapper, this.combiner, this.getIntermediateCacheName(), keys, false, false);
                MapTaskPart part = this.createTaskMapPart(cmd, address, false);
                part.execute();
                futures.add(part);
            }
        }
        try {
            for (MapTaskPart mapTaskPart : futures) {
                Map map;
                Object var9_18 = null;
                try {
                    map = (Map)mapTaskPart.get();
                }
                catch (ExecutionException ee) {
                    Throwable cause = ee.getCause();
                    if (cause instanceof org.infinispan.util.concurrent.TimeoutException) {
                        throw new ExecutionException("Map phase executing at " + mapTaskPart.getAddress() + " did not complete within " + this.rpcOptionsBuilder.timeout(TimeUnit.SECONDS) + " sec timeout", cause);
                    }
                    throw ee;
                }
                this.mergeResponse(mapPhasesResult, map);
            }
        }
        finally {
            this.cancellableTasks.clear();
        }
        MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
        log.tracef("For m/r task %s invoking %s locally", this.taskId, this.reducer);
        try {
            taskLifecycleService.onPreExecute(this.reducer, this.cache);
            for (Map.Entry entry : mapPhasesResult.entrySet()) {
                reducedResult.put(entry.getKey(), this.reducer.reduce(entry.getKey(), ((List)entry.getValue()).iterator()));
            }
        }
        finally {
            taskLifecycleService.onPostExecute(this.reducer);
        }
    }

    protected <V> MapTaskPart<V> createTaskMapPart(MapCombineCommand<KIn, VIn, KOut, VOut> cmd, Address target, boolean distributedReduce) {
        MapTaskPart mapTaskPart = new MapTaskPart(target, cmd, distributedReduce);
        this.cancellableTasks.add(mapTaskPart);
        return mapTaskPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<KOut, VOut> executeReducePhase(String resultCache, Set<KOut> allMapPhasesResponses, boolean useIntermediateSharedCache) throws InterruptedException, ExecutionException {
        RpcManager rpc = this.cache.getRpcManager();
        String destCache = this.getIntermediateCacheName();
        Cache dstCache = this.cache.getCacheManager().getCache(destCache);
        Map<Address, Collection<KOut>> keysToNodes = this.mapKeysToNodes(dstCache.getAdvancedCache().getDistributionManager(), allMapPhasesResponses, useIntermediateSharedCache);
        HashMap reduceResult = new HashMap();
        ArrayList reduceTasks = new ArrayList();
        ReduceCommand<KOut, VOut> reduceCommand = null;
        for (Map.Entry<Address, Collection<KOut>> entry : keysToNodes.entrySet()) {
            Address address = entry.getKey();
            Collection<KOut> keys = entry.getValue();
            reduceCommand = address.equals(rpc.getAddress()) ? this.buildReduceCommand(resultCache, this.taskId.toString(), destCache, this.clone(this.reducer), keys, useIntermediateSharedCache) : this.buildReduceCommand(resultCache, this.taskId.toString(), destCache, this.reducer, keys, useIntermediateSharedCache);
            ReduceTaskPart part = this.createReducePart(reduceCommand, address, destCache);
            part.execute();
            reduceTasks.add(part);
        }
        try {
            for (ReduceTaskPart reduceTaskPart : reduceTasks) {
                Map result = null;
                try {
                    result = (Map)reduceTaskPart.get();
                }
                catch (ExecutionException ee) {
                    Throwable cause = ee.getCause();
                    if (cause instanceof org.infinispan.util.concurrent.TimeoutException) {
                        throw new ExecutionException("Reduce phase executing at " + reduceTaskPart.getAddress() + " did not complete within " + this.rpcOptionsBuilder.timeout(TimeUnit.SECONDS) + " sec timeout", cause);
                    }
                    throw ee;
                }
                reduceResult.putAll(result);
            }
        }
        finally {
            this.cancellableTasks.clear();
        }
        return reduceResult;
    }

    protected <V> ReduceTaskPart<V> createReducePart(ReduceCommand<KOut, VOut> cmd, Address target, String destCacheName) {
        ReduceTaskPart part = new ReduceTaskPart(target, cmd, destCacheName);
        this.cancellableTasks.add(part);
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> void mergeResponse(Map<K, List<V>> result, Map<K, List<V>> m) {
        for (Map.Entry<K, List<V>> entry : m.entrySet()) {
            Map<K, List<List<V>>> map = result;
            synchronized (map) {
                List<V> list = result.get(entry.getKey());
                if (list != null) {
                    list.addAll((Collection)entry.getValue());
                } else {
                    list = new ArrayList<V>();
                    list.addAll((Collection)entry.getValue());
                }
                result.put(entry.getKey(), list);
            }
        }
    }

    private MapCombineCommand<KIn, VIn, KOut, VOut> buildMapCombineCommand(String taskId, Mapper<KIn, VIn, KOut, VOut> m, Reducer<KOut, VOut> r, String intermediateCacheName, Collection<KIn> keys, boolean reducePhaseDistributed, boolean useIntermediateSharedCache) {
        ComponentRegistry registry = SecurityActions.getCacheComponentRegistry(this.cache);
        CommandsFactory factory = registry.getComponent(CommandsFactory.class);
        MapCombineCommand<KIn, VIn, KOut, VOut> c = factory.buildMapCombineCommand(taskId, m, r, keys);
        c.setReducePhaseDistributed(reducePhaseDistributed);
        c.setUseIntermediateSharedCache(useIntermediateSharedCache);
        c.setIntermediateCacheName(intermediateCacheName);
        c.setMaxCollectorSize(1000);
        return c;
    }

    private ReduceCommand<KOut, VOut> buildReduceCommand(String resultCacheName, String taskId, String destinationCache, Reducer<KOut, VOut> r, Collection<KOut> keys, boolean useIntermediateSharedCache) {
        ComponentRegistry registry = this.cache.getComponentRegistry();
        CommandsFactory factory = registry.getComponent(CommandsFactory.class);
        ReduceCommand<KOut, VOut> reduceCommand = factory.buildReduceCommand(taskId, destinationCache, r, keys);
        reduceCommand.setUseIntermediateSharedCache(useIntermediateSharedCache);
        reduceCommand.setResultCacheName(resultCacheName);
        return reduceCommand;
    }

    private CancelCommand buildCancelCommand(CancellableTaskPart taskPart) {
        ComponentRegistry registry = this.cache.getComponentRegistry();
        CommandsFactory factory = registry.getComponent(CommandsFactory.class);
        return factory.buildCancelCommandCommand(taskPart.getUUID());
    }

    public Future<Map<KOut, VOut>> executeAsynchronously() {
        final MapReduceTaskFuture result = new MapReduceTaskFuture();
        ExecutorService executor = this.mapReduceManager.getExecutorService();
        Future returnValue = executor.submit(new Callable<Map<KOut, VOut>>(){

            @Override
            public Map<KOut, VOut> call() throws Exception {
                try {
                    Map retval = MapReduceTask.this.execute();
                    try {
                        result.notifyDone(retval);
                        log.trace("Finished notifying");
                    }
                    catch (Throwable e) {
                        log.trace("Exception while notifying the future", e);
                    }
                    return retval;
                }
                catch (Exception e) {
                    try {
                        result.notifyException(e);
                        log.trace("Finished notifying exception");
                    }
                    catch (Throwable e2) {
                        log.trace("Exception while notifying the future", e2);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(returnValue);
        return result;
    }

    public <R> R execute(Collator<KOut, VOut, R> collator) {
        Map<KOut, VOut> execute = this.execute();
        return collator.collate(execute);
    }

    public <R> Future<R> executeAsynchronously(final Collator<KOut, VOut, R> collator) {
        final MapReduceTaskFuture result = new MapReduceTaskFuture();
        ExecutorService executor = this.mapReduceManager.getExecutorService();
        Future returnValue = executor.submit(new Callable<R>(){

            @Override
            public R call() throws Exception {
                try {
                    Object retval = MapReduceTask.this.execute(collator);
                    try {
                        result.notifyDone(retval);
                        log.trace("Finished notifying");
                    }
                    catch (Throwable e) {
                        log.trace("Exception while notifying the future", e);
                    }
                    return retval;
                }
                catch (Exception e) {
                    try {
                        result.notifyException(e);
                        log.trace("Finished notifying");
                    }
                    catch (Throwable e2) {
                        log.trace("Exception while notifying the future", e2);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(returnValue);
        return result;
    }

    protected void aggregateReducedResult(Map<KOut, List<VOut>> finalReduced, Map<KOut, VOut> mapReceived) {
        for (Map.Entry<KOut, VOut> entry : mapReceived.entrySet()) {
            List<Object> l;
            if (!finalReduced.containsKey(entry.getKey())) {
                l = new LinkedList();
                finalReduced.put(entry.getKey(), l);
            } else {
                l = finalReduced.get(entry.getKey());
            }
            l.add(entry.getValue());
        }
    }

    protected <T> Map<Address, ? extends Collection<T>> mapKeysToNodes(DistributionManager dm, Collection<T> keysToMap, boolean useIntermediateCompositeKey) {
        if (this.isLocalOnly) {
            return Collections.singletonMap(this.clusteringDependentLogic.getAddress(), keysToMap);
        }
        return this.mapReduceManager.mapKeysToNodes(dm, this.taskId.toString(), keysToMap);
    }

    protected <T> Map<Address, ? extends Collection<T>> mapKeysToNodes(Collection<T> keysToMap, boolean useIntermediateCompositeKey) {
        return this.mapKeysToNodes(this.cache.getDistributionManager(), keysToMap, useIntermediateCompositeKey);
    }

    protected <T> Map<Address, ? extends Collection<T>> mapKeysToNodes(Collection<T> keysToMap) {
        return this.mapKeysToNodes(keysToMap, false);
    }

    protected Mapper<KIn, VIn, KOut, VOut> clone(Mapper<KIn, VIn, KOut, VOut> mapper) {
        return (Mapper)Util.cloneWithMarshaller((Marshaller)this.marshaller, mapper);
    }

    protected Reducer<KOut, VOut> clone(Reducer<KOut, VOut> reducer) {
        return (Reducer)Util.cloneWithMarshaller((Marshaller)this.marshaller, reducer);
    }

    private void ensureAccessPermissions(AdvancedCache<?, ?> cache) {
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager(cache);
        if (authorizationManager != null) {
            authorizationManager.checkPermission(AuthorizationPermission.EXEC);
        }
    }

    private void ensureProperCacheState(AdvancedCache<KIn, VIn> cache) throws NullPointerException, IllegalStateException {
        if (cache.getStatus() != ComponentStatus.RUNNING) {
            throw log.invalidCacheState(cache.getStatus().toString());
        }
        if (SecurityActions.getCacheRpcManager(cache) != null && SecurityActions.getCacheDistributionManager(cache) == null) {
            throw log.requireDistOrReplCache(cache.getCacheConfiguration().clustering().cacheModeString());
        }
    }

    protected boolean inputTaskKeysEmpty() {
        return this.keys == null || this.keys.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapReduceTask)) {
            return false;
        }
        MapReduceTask other = (MapReduceTask)obj;
        return !(this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId));
    }

    public String toString() {
        return "MapReduceTask [mapper=" + this.mapper + ", reducer=" + this.reducer + ", combiner=" + this.combiner + ", keys=" + this.keys + ", taskId=" + this.taskId + "]";
    }

    private static interface CancellableTaskPart {
        public UUID getUUID();

        public Address getExecutionTarget();
    }

    private class ReduceTaskPart<V>
    extends TaskPart<V> {
        private final ReduceCommand<KOut, VOut> rc;
        private final String cacheName;

        public ReduceTaskPart(Address executionTarget, ReduceCommand<KOut, VOut> command, String destinationCacheName) {
            super(executionTarget);
            this.rc = command;
            this.cacheName = destinationCacheName;
        }

        @Override
        public void execute() {
            if (this.locallyExecuted()) {
                Callable<Map<Address, ? extends Response>> callable = new Callable<Map<Address, ? extends Response>>(){

                    @Override
                    public Map<Address, ? extends Response> call() throws Exception {
                        Cache dstCache = MapReduceTask.this.cache.getCacheManager().getCache(ReduceTaskPart.this.cacheName);
                        Map result = ReduceTaskPart.this.invokeReduceLocally(dstCache);
                        return Collections.singletonMap(ReduceTaskPart.this.getAddress(), SuccessfulResponse.create(result));
                    }
                };
                FutureTask<Map<Address, ? extends Response>> futureTask = new FutureTask<Map<Address, ? extends Response>>(callable);
                this.setFuture(futureTask);
                MapReduceTask.this.mapReduceManager.getExecutorService().submit(futureTask);
            } else {
                RpcManager rpc = MapReduceTask.this.cache.getRpcManager();
                try {
                    log.debugf("Invoking %s on %s", this.rc, this.getExecutionTarget());
                    rpc.invokeRemotelyInFuture(Collections.singleton(this.getExecutionTarget()), this.rc, MapReduceTask.this.rpcOptionsBuilder.build(), (NotifyingNotifiableFuture<Object>)this);
                    log.debugf("Invoked %s on %s ", this.rc, this.getExecutionTarget());
                }
                catch (Exception ex) {
                    throw new CacheException("Could not invoke map phase of MapReduceTask on remote node " + this.getExecutionTarget(), (Throwable)ex);
                }
            }
        }

        private Map<KOut, VOut> invokeReduceLocally(Cache<Object, Object> dstCache) {
            this.rc.init(MapReduceTask.this.mapReduceManager);
            Map<Object, Object> localReduceResult = null;
            try {
                log.debugf("Invoking %s locally ", this.rc);
                if (this.rc.emitsIntoResultingCache()) {
                    MapReduceTask.this.mapReduceManager.reduce(this.rc, this.rc.getResultCacheName());
                    localReduceResult = Collections.emptyMap();
                } else {
                    localReduceResult = MapReduceTask.this.mapReduceManager.reduce(this.rc);
                }
                log.debugf("Invoked %s locally", this.rc);
            }
            catch (Throwable e1) {
                throw new CacheException("Could not invoke MapReduce task locally ", e1);
            }
            return localReduceResult;
        }

        @Override
        public UUID getUUID() {
            return this.rc.getUUID();
        }
    }

    private class MapTaskPart<V>
    extends TaskPart<V> {
        private final MapCombineCommand<KIn, VIn, KOut, VOut> mcc;
        private final boolean distributedReduce;

        public MapTaskPart(Address executionTarget, MapCombineCommand<KIn, VIn, KOut, VOut> command, boolean distributedReduce) {
            super(executionTarget);
            this.mcc = command;
            this.distributedReduce = distributedReduce;
        }

        @Override
        public void execute() {
            if (this.locallyExecuted()) {
                Callable<Map<Address, ? extends Response>> callable = this.distributedReduce ? new Callable<Map<Address, ? extends Response>>(){

                    @Override
                    public Map<Address, ? extends Response> call() throws Exception {
                        Set result = MapTaskPart.this.invokeMapCombineLocally();
                        return Collections.singletonMap(MapTaskPart.this.getAddress(), SuccessfulResponse.create(result));
                    }
                } : new Callable<Map<Address, ? extends Response>>(){

                    @Override
                    public Map<Address, ? extends Response> call() throws Exception {
                        Map result = MapTaskPart.this.invokeMapCombineLocallyForLocalReduction();
                        return Collections.singletonMap(MapTaskPart.this.getAddress(), SuccessfulResponse.create(result));
                    }
                };
                FutureTask<Map<Address, ? extends Response>> futureTask = new FutureTask<Map<Address, ? extends Response>>(callable);
                this.setFuture(futureTask);
                MapReduceTask.this.mapReduceManager.getExecutorService().submit(futureTask);
            } else {
                RpcManager rpc = SecurityActions.getCacheRpcManager(MapReduceTask.this.cache);
                try {
                    log.debugf("Invoking %s on %s", this.mcc, this.getExecutionTarget());
                    rpc.invokeRemotelyInFuture(Collections.singleton(this.getExecutionTarget()), this.mcc, MapReduceTask.this.rpcOptionsBuilder.build(), (NotifyingNotifiableFuture<Object>)this);
                    log.debugf("Invoked %s on %s ", this.mcc, this.getExecutionTarget());
                }
                catch (Exception ex) {
                    throw new CacheException("Could not invoke map phase of MapReduceTask on remote node " + this.getExecutionTarget(), (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<KOut, List<VOut>> invokeMapCombineLocallyForLocalReduction() throws InterruptedException {
            log.debugf("Invoking %s locally", this.mcc);
            try {
                MapReduceTask.this.cancellationService.register(Thread.currentThread(), this.mcc.getUUID());
                this.mcc.init(MapReduceTask.this.mapReduceManager);
                Map map = MapReduceTask.this.mapReduceManager.mapAndCombineForLocalReduction(this.mcc);
                return map;
            }
            finally {
                MapReduceTask.this.cancellationService.unregister(this.mcc.getUUID());
                log.debugf("Invoked %s locally", this.mcc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<KOut> invokeMapCombineLocally() throws InterruptedException {
            log.debugf("Invoking %s locally", this.mcc);
            try {
                MapReduceTask.this.cancellationService.register(Thread.currentThread(), this.mcc.getUUID());
                this.mcc.init(MapReduceTask.this.mapReduceManager);
                Set set = MapReduceTask.this.mapReduceManager.mapAndCombineForDistributedReduction(this.mcc);
                return set;
            }
            finally {
                MapReduceTask.this.cancellationService.unregister(this.mcc.getUUID());
                log.debugf("Invoked %s locally", this.mcc);
            }
        }

        @Override
        public UUID getUUID() {
            return this.mcc.getUUID();
        }
    }

    private abstract class TaskPart<V>
    implements NotifyingNotifiableFuture<V>,
    CancellableTaskPart {
        private Future<V> f;
        private final Address executionTarget;

        public TaskPart(Address executionTarget) {
            this.executionTarget = executionTarget;
        }

        @Override
        public Address getExecutionTarget() {
            return this.executionTarget;
        }

        public NotifyingFuture<V> attachListener(FutureListener<V> listener) {
            throw new UnsupportedOperationException();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return false;
        }

        public V get() throws InterruptedException, ExecutionException {
            return this.retrieveResult(this.f.get());
        }

        protected Address getAddress() {
            return MapReduceTask.this.clusteringDependentLogic.getAddress();
        }

        protected boolean locallyExecuted() {
            return this.getAddress().equals(this.getExecutionTarget());
        }

        public abstract void execute();

        private V retrieveResult(Object response) throws ExecutionException {
            if (response == null) {
                throw new ExecutionException("Execution returned null value", new NullPointerException());
            }
            if (response instanceof Exception) {
                throw new ExecutionException((Exception)response);
            }
            Map mapResult = (Map)response;
            assert (mapResult.size() == 1);
            for (Map.Entry e : mapResult.entrySet()) {
                if (!(e.getValue() instanceof SuccessfulResponse)) continue;
                return (V)((SuccessfulResponse)e.getValue()).getResponseValue();
            }
            throw new ExecutionException(new IllegalStateException("Invalid response " + response));
        }

        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.retrieveResult(this.f.get(timeout, unit));
        }

        public void notifyDone(V result) {
        }

        public void notifyException(Throwable exception) {
        }

        public void setFuture(Future<V> future) {
            this.f = future;
        }
    }

    private class MapReduceTaskFuture<R>
    extends NotifyingFutureImpl<R> {
        private volatile boolean cancelled = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.isCancelled()) {
                RpcManager rpc = MapReduceTask.this.cache.getRpcManager();
                List<CancellableTaskPart> list = MapReduceTask.this.cancellableTasks;
                synchronized (list) {
                    for (CancellableTaskPart task : MapReduceTask.this.cancellableTasks) {
                        boolean sendingToSelf = task.getExecutionTarget().equals(rpc.getTransport().getAddress());
                        CancelCommand cc = MapReduceTask.this.buildCancelCommand(task);
                        if (sendingToSelf) {
                            cc.init(MapReduceTask.this.cancellationService);
                            try {
                                cc.perform(null);
                            }
                            catch (Throwable e) {
                                log.couldNotExecuteCancellationLocally(e.getLocalizedMessage());
                            }
                        } else {
                            rpc.invokeRemotely(Collections.singletonList(task.getExecutionTarget()), (ReplicableCommand)cc, MapReduceTask.this.rpcOptionsBuilder.build());
                        }
                        this.cancelled = true;
                    }
                }
                return this.cancelled;
            }
            return false;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }
}

