/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partionhandling.impl;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.partionhandling.impl.PartitionContext;
import org.infinispan.partionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.ClusterCacheStatus;

public class PartitionContextImpl
implements PartitionContext {
    private final PartitionHandlingManager partitionHandlingManager;
    private final boolean isMissingData;
    private final List<Address> oldMembers;
    private final List<Address> newMembers;
    private final ClusterCacheStatus clusterCacheStatus;
    private boolean rebalance;
    private final Cache cache;

    public PartitionContextImpl(PartitionHandlingManager partitionHandlingManager, List<Address> oldMembers, List<Address> newMembers, boolean isMissingData, ClusterCacheStatus clusterCacheStatus, Cache c) {
        this.partitionHandlingManager = partitionHandlingManager;
        this.oldMembers = oldMembers;
        this.newMembers = newMembers;
        this.isMissingData = isMissingData;
        this.clusterCacheStatus = clusterCacheStatus;
        this.cache = c;
    }

    @Override
    public List<Address> getOldMembers() {
        return this.oldMembers;
    }

    @Override
    public List<Address> getNewMembers() {
        return this.newMembers;
    }

    @Override
    public boolean isMissingData() {
        return this.isMissingData;
    }

    @Override
    public void enterDegradedMode() {
        this.partitionHandlingManager.enterDegradedMode();
    }

    @Override
    public void rebalance() {
        this.rebalance = true;
    }

    public boolean isRebalance() {
        return this.rebalance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionContextImpl that = (PartitionContextImpl)o;
        if (this.isMissingData != that.isMissingData) {
            return false;
        }
        if (this.rebalance != that.rebalance) {
            return false;
        }
        if (this.clusterCacheStatus != null ? !this.clusterCacheStatus.equals(that.clusterCacheStatus) : that.clusterCacheStatus != null) {
            return false;
        }
        if (this.newMembers != null ? !this.newMembers.equals(that.newMembers) : that.newMembers != null) {
            return false;
        }
        if (this.oldMembers != null ? !this.oldMembers.equals(that.oldMembers) : that.oldMembers != null) {
            return false;
        }
        return !(this.partitionHandlingManager != null ? !this.partitionHandlingManager.equals(that.partitionHandlingManager) : that.partitionHandlingManager != null);
    }

    public int hashCode() {
        int result = this.partitionHandlingManager != null ? this.partitionHandlingManager.hashCode() : 0;
        result = 31 * result + (this.isMissingData ? 1 : 0);
        result = 31 * result + (this.oldMembers != null ? this.oldMembers.hashCode() : 0);
        result = 31 * result + (this.newMembers != null ? this.newMembers.hashCode() : 0);
        result = 31 * result + (this.clusterCacheStatus != null ? this.clusterCacheStatus.hashCode() : 0);
        result = 31 * result + (this.rebalance ? 1 : 0);
        return result;
    }

    public String toString() {
        return "PartitionContextImpl{partitionHandlingManager=" + this.partitionHandlingManager + ", isMissingData=" + this.isMissingData + ", oldMembers=" + this.oldMembers + ", newMembers=" + this.newMembers + ", clusterCacheStatus=" + this.clusterCacheStatus + ", rebalance=" + this.rebalance + '}';
    }
}

