/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partionhandling.impl;

import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.partionhandling.impl.PartitionHandlingManager;

public class PartitionHandlingInterceptor
extends CommandInterceptor {
    PartitionHandlingManager partitionHandlingManager;

    @Inject
    void init(PartitionHandlingManager partitionHandlingManager) {
        this.partitionHandlingManager = partitionHandlingManager;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        this.partitionHandlingManager.checkWrite(command.getKey());
        return super.visitPutKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        this.partitionHandlingManager.checkWrite(command.getKey());
        return super.visitRemoveCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        this.partitionHandlingManager.checkWrite(command.getKey());
        return super.visitReplaceCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        for (Object k : command.getAffectedKeys()) {
            this.partitionHandlingManager.checkWrite(k);
        }
        return super.visitPutMapCommand(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        this.partitionHandlingManager.checkClear();
        return super.visitClearCommand(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        this.partitionHandlingManager.checkWrite(command.getKey());
        return super.visitApplyDeltaCommand(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        this.partitionHandlingManager.checkRead(command.getKey());
        return super.visitGetKeyValueCommand(ctx, command);
    }
}

