/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partionhandling.impl;

import java.util.Collections;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.partionhandling.impl.DegradedModePartitionHandlingStrategy;
import org.infinispan.partionhandling.impl.PartitionContextImpl;
import org.infinispan.partionhandling.impl.PartitionHandlingStrategy;
import org.infinispan.partionhandling.impl.PartitionStateControlCommand;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.ClusterCacheStatus;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PartitionHandlingManager {
    private static final Log log = LogFactory.getLog(PartitionHandlingManager.class);
    private static final boolean trace = log.isTraceEnabled();
    private volatile List<Address> lastStableCluster = Collections.emptyList();
    private Cache cache;
    private PartitionHandlingStrategy partitionHandlingStrategy;
    private PartitionState state = PartitionState.AVAILABLE;
    private DistributionManager distributionManager;
    private RpcManager rpcManager;
    private Configuration configuration;

    @Inject
    void init(Cache cache, DistributionManager distributionManager, RpcManager rpcManager, Configuration configuration) {
        this.cache = cache;
        this.distributionManager = distributionManager;
        this.rpcManager = rpcManager;
        this.configuration = configuration;
    }

    @Start
    void start() {
        this.partitionHandlingStrategy = new DegradedModePartitionHandlingStrategy();
    }

    public void setState(PartitionState state) {
        if (trace) {
            log.tracef("Updating partition state: %s -> %s", (Object)this.state, (Object)state);
        }
        this.state = state;
    }

    public void setLastStableCluster(List<Address> members) {
        this.lastStableCluster = members;
    }

    public List<Address> getLastStableCluster() {
        return this.lastStableCluster;
    }

    public PartitionState getState() {
        return this.state;
    }

    public boolean handleViewChange(List<Address> newMembers, ClusterCacheStatus topologyManager) {
        boolean missingData = this.isMissingData(newMembers, this.lastStableCluster);
        if (trace) {
            log.tracef("handleViewChange(old:%s -> new:%s). Is missing data? %s", this.lastStableCluster, newMembers, missingData);
        }
        PartitionContextImpl pci = new PartitionContextImpl(this, this.lastStableCluster, newMembers, missingData, topologyManager, this.cache);
        log.debugf("Invoking partition handling %s", pci);
        this.partitionHandlingStrategy.onMembershipChanged(pci);
        return pci.isRebalance();
    }

    private boolean isMissingData(List<Address> newMembers, List<Address> oldMembers) {
        int missingMembers = 0;
        for (Address a : oldMembers) {
            if (newMembers.contains(a)) continue;
            ++missingMembers;
        }
        int numOwners = this.configuration.clustering().hash().numOwners();
        return missingMembers >= numOwners;
    }

    public void enterDegradedMode() {
        log.debug("Entering in degraded mode.");
        if (this.state == PartitionState.DEGRADED_MODE) {
            throw new IllegalStateException("Already in degraded mode!");
        }
        if (this.state == PartitionState.UNAVAILABLE) {
            return;
        }
        this.setState(PartitionState.DEGRADED_MODE);
        PartitionStateControlCommand stateUpdateCommand = new PartitionStateControlCommand(this.cache.getName(), PartitionState.DEGRADED_MODE);
        this.rpcManager.invokeRemotely(null, (ReplicableCommand)stateUpdateCommand, this.rpcManager.getDefaultRpcOptions(true));
    }

    public void checkWrite(Object key) {
        this.doCheck(key);
    }

    public void checkRead(Object key) {
        this.doCheck(key);
    }

    private void doCheck(Object key) {
        if (trace) {
            log.tracef("Checking availability for key=%s, status=%s", key, (Object)this.state);
        }
        if (this.state == PartitionState.AVAILABLE) {
            return;
        }
        if (this.state == PartitionState.UNAVAILABLE) {
            throw log.partitionUnavailable();
        }
        List<Address> owners = this.distributionManager.locate(key);
        if (!this.rpcManager.getTransport().getMembers().containsAll(owners)) {
            if (trace) {
                log.tracef("Partition is in %s mode, access is not allowed for key %s", (Object)this.state, key);
            }
            throw log.degradedModeKeyUnavailable(key);
        }
        if (trace) {
            log.tracef("Key %s is available.", key);
        }
    }

    public void checkClear() {
        if (this.state != PartitionState.AVAILABLE) {
            throw log.clearDisallowedWhilePartitioned();
        }
    }

    public static enum PartitionState {
        AVAILABLE,
        UNAVAILABLE,
        DEGRADED_MODE;

    }
}

