/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partionhandling.impl;

import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.partionhandling.impl.PartitionHandlingManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PartitionStateControlCommand
extends BaseRpcCommand {
    private static final Log log = LogFactory.getLog(PartitionStateControlCommand.class);
    public static final byte COMMAND_ID = 44;
    private PartitionHandlingManager.PartitionState state;
    private PartitionHandlingManager phm;

    private PartitionStateControlCommand() {
        super(null);
    }

    public PartitionStateControlCommand(String ownerCacheName) {
        super(ownerCacheName);
    }

    public PartitionStateControlCommand(String ownerCacheName, PartitionHandlingManager.PartitionState state) {
        super(ownerCacheName);
        this.state = state;
    }

    public void init(PartitionHandlingManager phm) {
        this.phm = phm;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        this.phm.setState(this.state);
        return null;
    }

    @Override
    public byte getCommandId() {
        return 44;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.state};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 44) {
            throw new IllegalStateException("Invalid method id " + commandId + " but " + this.getClass() + " has id " + this.getCommandId());
        }
        this.state = (PartitionHandlingManager.PartitionState)((Object)parameters[0]);
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionStateControlCommand that = (PartitionStateControlCommand)o;
        return this.state == that.state;
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    @Override
    public String toString() {
        return "PartitionStateControlCommand [state=" + (Object)((Object)this.state) + "]";
    }
}

