/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.partionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyControlCommand;
import org.infinispan.topology.RebalanceConfirmationCollector;
import org.infinispan.topology.RebalancePolicy;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterCacheStatus {
    private static final Log log = LogFactory.getLog(ClusterCacheStatus.class);
    private static boolean trace = log.isTraceEnabled();
    private final String cacheName;
    private final CacheJoinInfo joinInfo;
    private final RebalancePolicy rebalancePolicy;
    private final PartitionHandlingManager partitionHandlingManager;
    private volatile List<Address> members;
    private volatile Map<Address, Float> capacityFactors;
    private volatile List<Address> joiners;
    private volatile CacheTopology cacheTopology;
    private volatile RebalanceConfirmationCollector rebalanceStatus;
    private Transport transport;
    private GlobalConfiguration globalConfiguration;
    private ExecutorService asyncTransportExecutor;
    private GlobalComponentRegistry gcr;

    public ClusterCacheStatus(String cacheName, CacheJoinInfo joinInfo, Transport transport, GlobalConfiguration globalConfiguration, ExecutorService asyncTransportExecutor, GlobalComponentRegistry gcr, RebalancePolicy rebalancePolicy) {
        ComponentRegistry namedComponentRegistry;
        this.cacheName = cacheName;
        this.joinInfo = joinInfo;
        this.cacheTopology = new CacheTopology(-1, null, null);
        this.members = InfinispanCollections.emptyList();
        this.capacityFactors = InfinispanCollections.emptyMap();
        this.joiners = InfinispanCollections.emptyList();
        this.transport = transport;
        this.globalConfiguration = globalConfiguration;
        this.asyncTransportExecutor = asyncTransportExecutor;
        this.gcr = gcr;
        this.rebalancePolicy = rebalancePolicy;
        if (trace) {
            log.tracef("Cache %s initialized, join info is %s", cacheName, joinInfo);
        }
        this.partitionHandlingManager = (namedComponentRegistry = gcr.getNamedComponentRegistry(cacheName)) == null ? null : namedComponentRegistry.getComponent(PartitionHandlingManager.class);
    }

    public CacheJoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    public List<Address> getMembers() {
        return this.members;
    }

    public boolean hasMembers() {
        return !this.members.isEmpty();
    }

    public List<Address> getJoiners() {
        return this.joiners;
    }

    public boolean hasJoiners() {
        return !this.joiners.isEmpty();
    }

    public boolean isTotalOrder() {
        return this.joinInfo.isTotalOrder();
    }

    public boolean isDistributed() {
        return this.joinInfo.isDistributed();
    }

    public Map<Address, Float> getCapacityFactors() {
        return this.capacityFactors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMember(Address joiner, float capacityFactor) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.members.contains(joiner)) {
                if (trace) {
                    log.tracef("Trying to add node %s to cache %s, but it is already a member: members = %s, joiners = %s", new Object[]{joiner, this.cacheName, this.members, this.joiners});
                }
                return false;
            }
            HashMap<Address, Float> newCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
            newCapacityFactors.put(joiner, Float.valueOf(capacityFactor));
            this.capacityFactors = Immutables.immutableMapWrap(newCapacityFactors);
            this.members = this.immutableAdd(this.members, joiner);
            this.joiners = this.immutableAdd(this.joiners, joiner);
            if (trace) {
                log.tracef("Added joiner %s to cache %s: members = %s, joiners = %s", new Object[]{joiner, this.cacheName, this.members, this.joiners});
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMember(Address leaver) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (!this.members.contains(leaver)) {
                if (trace) {
                    log.tracef("Trying to remove node %s from cache %s, but it is not a member: members = %s", leaver, this.cacheName, this.members);
                }
                return false;
            }
            this.members = this.immutableRemove(this.members, leaver);
            HashMap<Address, Float> newCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
            newCapacityFactors.remove(leaver);
            this.capacityFactors = Immutables.immutableMapWrap(newCapacityFactors);
            this.joiners = this.immutableRemove(this.joiners, leaver);
            if (trace) {
                log.tracef("Removed node %s from cache %s: members = %s, joiners = %s", new Object[]{leaver, this.cacheName, this.members, this.joiners});
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateClusterMembers(List<Address> newClusterMembers) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (newClusterMembers.containsAll(this.members)) {
                if (trace) {
                    log.tracef("Cluster members updated for cache %s, no leavers detected: cache members = %s. Existing members = %s", this.cacheName, newClusterMembers, this.members);
                }
                return false;
            }
            this.members = this.immutableRetainAll(this.members, newClusterMembers);
            this.joiners = this.immutableRetainAll(this.joiners, newClusterMembers);
            if (trace) {
                log.tracef("Cluster members updated for cache %s: members = %s, joiners = %s", this.cacheName, this.members, this.joiners);
            }
            return true;
        }
    }

    public CacheTopology getCacheTopology() {
        return this.cacheTopology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCacheTopology(CacheTopology newTopology) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            this.cacheTopology = newTopology;
            if (!this.members.containsAll(this.cacheTopology.getMembers())) {
                throw new IllegalStateException(String.format("Trying to set a topology with invalid members for cache %s: members = %s, topology = %s", this.cacheName, this.members, this.cacheTopology));
            }
            if (newTopology.getCurrentCH() != null) {
                this.joiners = this.immutableRemoveAll(this.members, newTopology.getCurrentCH().getMembers());
            }
            if (trace) {
                log.tracef("Cache %s topology updated: members = %s, joiners = %s, topology = %s", new Object[]{this.cacheName, this.members, this.joiners, this.cacheTopology});
            }
        }
    }

    public boolean needConsistentHashUpdate() {
        return !this.members.containsAll(this.cacheTopology.getMembers());
    }

    public List<Address> pruneInvalidMembers(List<Address> possibleMembers) {
        return this.immutableRetainAll(possibleMembers, this.members);
    }

    public boolean isRebalanceInProgress() {
        return this.rebalanceStatus != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startRebalance(CacheTopology newTopology) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceStatus != null) {
                return false;
            }
            this.rebalanceStatus = new RebalanceConfirmationCollector(this.cacheName, newTopology.getTopologyId(), newTopology.getMembers());
            this.updateCacheTopology(newTopology);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean confirmRebalanceOnNode(Address member, int receivedTopologyId) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceStatus == null) {
                return false;
            }
            return this.rebalanceStatus.confirmRebalance(member, receivedTopologyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRebalanceMembersList() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceStatus == null) {
                return false;
            }
            return this.rebalanceStatus.updateMembers(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRebalanceStatus() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceStatus == null) {
                throw new IllegalStateException("Can't end rebalance, there is no rebalance in progress");
            }
            this.rebalanceStatus = null;
        }
    }

    public void processMembershipChange(List<Address> newClusterMembers) throws Exception {
        boolean cacheMembersModified;
        if ((this.partitionHandlingManager == null || this.partitionHandlingManager.handleViewChange(newClusterMembers, this)) && (cacheMembersModified = this.updateClusterMembers(newClusterMembers))) {
            this.updateTopologyAndBroadcastChUpdate();
        }
    }

    public boolean updateTopologyAndBroadcastChUpdate() throws Exception {
        boolean topologyChanged = this.updateTopologyAfterMembershipChange();
        if (!topologyChanged) {
            return true;
        }
        boolean rebalanceCompleted = this.updateRebalanceMembersList();
        if (rebalanceCompleted) {
            this.endRebalance();
        }
        this.broadcastConsistentHashUpdate();
        this.rebalancePolicy.updateCacheStatus(this.cacheName, this);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRebalance() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            CacheTopology currentTopology = this.getCacheTopology();
            int currentTopologyId = currentTopology.getTopologyId();
            log.debugf("Finished cluster-wide rebalance for cache %s, topology id = %d", this.cacheName, currentTopologyId);
            int newTopologyId = currentTopologyId + 1;
            ConsistentHash newCurrentCH = currentTopology.getPendingCH();
            CacheTopology newTopology = new CacheTopology(newTopologyId, newCurrentCH, null, this.getCacheTopology().isMissingData());
            this.updateCacheTopology(newTopology);
            this.setRebalanceStatus();
        }
    }

    public void broadcastConsistentHashUpdate() throws Exception {
        CacheTopology cacheTopology = this.getCacheTopology();
        log.debugf("Updating cluster-wide consistent hash for cache %s, topology = %s", this.cacheName, cacheTopology);
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(this.cacheName, CacheTopologyControlCommand.Type.CH_UPDATE, this.transport.getAddress(), cacheTopology, this.transport.getViewId());
        this.executeOnClusterAsync(command, this.getGlobalTimeout());
    }

    public void executeOnClusterAsync(final ReplicableCommand command, int timeout) throws Exception {
        if (!this.isTotalOrder()) {
            this.asyncTransportExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    ClusterCacheStatus.this.gcr.wireDependencies(command);
                    try {
                        if (log.isTraceEnabled()) {
                            log.tracef("Attempting to execute command on self: %s", command);
                        }
                        command.perform(null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        this.transport.invokeRemotely(null, command, ResponseMode.ASYNCHRONOUS_WITH_SYNC_MARSHALLING, timeout, true, null, this.isTotalOrder(), this.isDistributed());
    }

    private int getGlobalTimeout() {
        return (int)this.globalConfiguration.transport().distributedSyncTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateTopologyAfterMembershipChange() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            ConsistentHashFactory consistentHashFactory = this.getJoinInfo().getConsistentHashFactory();
            int topologyId = this.getCacheTopology().getTopologyId();
            ConsistentHash currentCH = this.getCacheTopology().getCurrentCH();
            ConsistentHash pendingCH = this.getCacheTopology().getPendingCH();
            if (!this.needConsistentHashUpdate()) {
                log.tracef("Cache %s members list was updated, but the cache topology doesn't need to change: %s", this.cacheName, this.getCacheTopology());
                return false;
            }
            List<Address> newCurrentMembers = this.pruneInvalidMembers(currentCH.getMembers());
            if (newCurrentMembers.isEmpty()) {
                CacheTopology newTopology = new CacheTopology(topologyId + 1, null, null, false);
                this.updateCacheTopology(newTopology);
                log.tracef("Initial topology installed for cache %s: %s", this.cacheName, newTopology);
                return false;
            }
            ConsistentHash newCurrentCH = consistentHashFactory.updateMembers(currentCH, newCurrentMembers, this.getCapacityFactors());
            ConsistentHash newPendingCH = null;
            if (pendingCH != null) {
                List<Address> newPendingMembers = this.pruneInvalidMembers(pendingCH.getMembers());
                newPendingCH = consistentHashFactory.updateMembers(pendingCH, newPendingMembers, this.getCapacityFactors());
            }
            boolean missingSegments = this.isDataLost(currentCH, this.members);
            log.tracef("Is missing segments? %s", missingSegments);
            CacheTopology newTopology = new CacheTopology(topologyId + 1, newCurrentCH, newPendingCH, missingSegments);
            this.updateCacheTopology(newTopology);
            log.tracef("Cache %s topology updated: %s", this.cacheName, newTopology);
            newTopology.logRoutingTableInformation();
            return true;
        }
    }

    private <T> List<T> immutableAdd(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.add(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemove(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.remove(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemoveAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.removeAll(otherList);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRetainAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.retainAll(otherList);
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return "ClusterCacheStatus{cacheName='" + this.cacheName + '\'' + ", members=" + this.members + ", joiners=" + this.joiners + ", cacheTopology=" + this.cacheTopology + ", rebalanceStatus=" + this.rebalanceStatus + '}';
    }

    public synchronized void reconcileCacheTopology(List<Address> clusterMembers, List<CacheTopology> partitionTopologies, boolean isMergeView) throws Exception {
        try {
            if (partitionTopologies.isEmpty()) {
                return;
            }
            CacheTopology cacheTopology = isMergeView && this.partitionHandlingManager != null ? this.buildCacheTopologyForMerge(clusterMembers, partitionTopologies) : this.buildCacheTopology(clusterMembers, partitionTopologies);
            if (cacheTopology == null) {
                return;
            }
            if (this.isRebalanceInProgress()) {
                this.endRebalance();
            }
            this.updateCacheTopology(cacheTopology);
            this.broadcastConsistentHashUpdate();
            this.rebalancePolicy.updateCacheStatus(this.cacheName, this);
        }
        catch (Exception e) {
            log.failedToRecoverCacheState(this.cacheName, e);
        }
    }

    private CacheTopology buildCacheTopologyForMerge(List<Address> clusterMembers, List<CacheTopology> partitionTopologies) {
        log.trace("Building cache topology for merge.");
        int maxTopology = 0;
        ConsistentHash agreedCh = null;
        ConsistentHashFactory chFactory = this.getJoinInfo().getConsistentHashFactory();
        for (CacheTopology topology : partitionTopologies) {
            if (topology.getTopologyId() <= maxTopology) continue;
            maxTopology = topology.getTopologyId();
            agreedCh = topology.getCurrentCH();
        }
        this.updateClusterMembers(clusterMembers);
        List<Address> members = this.getMembers();
        if (members.isEmpty()) {
            log.tracef("Cache %s has no members left, skipping topology update", this.cacheName);
            return null;
        }
        if (agreedCh != null) {
            agreedCh = chFactory.updateMembers(agreedCh, members, this.getCapacityFactors());
            log.tracef("Agreed routing table is %s", agreedCh.getRoutingTableAsString());
        }
        CacheTopology cacheTopology = new CacheTopology(maxTopology += 2, agreedCh, null);
        return cacheTopology;
    }

    private CacheTopology buildCacheTopology(List<Address> clusterMembers, List<CacheTopology> partitionTopologies) {
        log.trace("buildCacheTopology");
        int unionTopologyId = 0;
        ConsistentHash currentCHUnion = null;
        ConsistentHashFactory chFactory = this.getJoinInfo().getConsistentHashFactory();
        ConsistentHash latestTopologyCh = null;
        for (CacheTopology topology : partitionTopologies) {
            if (topology.getTopologyId() > unionTopologyId) {
                unionTopologyId = topology.getTopologyId();
                latestTopologyCh = topology.getCurrentCH();
            }
            if (currentCHUnion == null) {
                currentCHUnion = topology.getCurrentCH();
                continue;
            }
            currentCHUnion = chFactory.union(currentCHUnion, topology.getCurrentCH());
        }
        this.updateClusterMembers(clusterMembers);
        List<Address> members = this.getMembers();
        if (members.isEmpty()) {
            log.tracef("Cache %s has no members left, skipping topology update", this.cacheName);
            return null;
        }
        if (currentCHUnion != null) {
            currentCHUnion = chFactory.updateMembers(currentCHUnion, members, this.getCapacityFactors());
        }
        return new CacheTopology(unionTopologyId += 2, currentCHUnion, null, this.isDataLost(latestTopologyCh, clusterMembers));
    }

    public synchronized void reconcileCacheTopologyWhenBecomingCoordinator(List<Address> clusterMembers, List<CacheTopology> partitionTopologies, boolean mergeView) throws Exception {
        log.tracef("reconcileCacheTopologyWhenBecomingCoordinator: members = %s, topologies = %s, mergeView = %s", clusterMembers, partitionTopologies, mergeView);
        if (this.partitionHandlingManager == null || this.partitionHandlingManager.handleViewChange(clusterMembers, this)) {
            this.reconcileCacheTopology(clusterMembers, partitionTopologies, mergeView);
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public boolean isDataLost(ConsistentHash consistentHash, List<Address> newMembers) {
        if (consistentHash == null) {
            log.trace("No previous CH, missingData returns false.");
            return false;
        }
        log.tracef("isMissingData: consistentHash == %s, routingTable == %s, newMembers == %s ", consistentHash, consistentHash.getRoutingTableAsString(), newMembers);
        List<Address> allMembers = consistentHash.getMembers();
        HashMap<Address, Set> nodeOwnsSegments = new HashMap<Address, Set>();
        HashSet allSegments = new HashSet();
        for (Address a : allMembers) {
            Set segments = consistentHash.getSegmentsForOwner(a);
            nodeOwnsSegments.put(a, segments);
            allSegments.addAll(segments);
        }
        for (Address a : consistentHash.getMembers()) {
            if (newMembers.contains(a)) continue;
            nodeOwnsSegments.remove(a);
        }
        HashSet existingSegments = new HashSet();
        for (Set segments : nodeOwnsSegments.values()) {
            existingSegments.addAll(segments);
        }
        allSegments.removeAll(existingSegments);
        if (!allSegments.isEmpty()) {
            log.tracef("Segments have been lost: %s", allSegments);
        }
        return !allSegments.isEmpty();
    }

    public boolean isMissingData() {
        return this.getCacheTopology() != null && this.getCacheTopology().isMissingData();
    }
}

