/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.remoting.transport.Address;

public final class XSiteStateTransferCollector {
    private final Set<Address> collector;

    public XSiteStateTransferCollector(Collection<Address> confirmationPending) {
        if (confirmationPending == null) {
            throw new NullPointerException("Pending confirmations must be non-null.");
        }
        if (confirmationPending.isEmpty()) {
            throw new IllegalArgumentException("Pending confirmations must be non-empty.");
        }
        this.collector = new HashSet<Address>(confirmationPending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean confirmStateTransfer(Address node) {
        Set<Address> set = this.collector;
        synchronized (set) {
            return this.collector.remove(node) && this.collector.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateMembers(Collection<Address> members) {
        Set<Address> set = this.collector;
        synchronized (set) {
            return this.collector.retainAll(members) && this.collector.isEmpty();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XSiteStateTransferCollector that = (XSiteStateTransferCollector)o;
        return this.collector.equals(that.collector);
    }

    public int hashCode() {
        return this.collector.hashCode();
    }

    public String toString() {
        return "XSiteStateTransferCollector{collector=" + this.collector + '}';
    }
}

