/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.query.backend.ReadIntensiveClusterRegistryWrapper;
import org.infinispan.query.backend.TransactionHelper;

class SearchFactoryHandler {
    private final SearchFactoryIntegrator searchFactory;
    private final ReadIntensiveClusterRegistryWrapper<String, Class<?>, Boolean> clusterRegistry;
    private final TransactionHelper transactionHelper;
    private final ReentrantLock mutating = new ReentrantLock();

    SearchFactoryHandler(SearchFactoryIntegrator searchFactory, ReadIntensiveClusterRegistryWrapper<String, Class<?>, Boolean> clusterRegistry, TransactionHelper transactionHelper) {
        this.searchFactory = searchFactory;
        this.clusterRegistry = clusterRegistry;
        this.transactionHelper = transactionHelper;
    }

    boolean updateKnownTypesIfNeeded(Object value) {
        if (value != null) {
            Class<?> potentialNewType = value.getClass();
            if (!this.clusterRegistry.containsKey(potentialNewType)) {
                this.handleOnDemandRegistration(potentialNewType);
            }
            return this.clusterRegistry.get(potentialNewType);
        }
        return false;
    }

    private void handleOnDemandRegistration(Class<?> ... classes) {
        Class<?>[] toAdd = this.filterAlreadyIndexed(classes);
        if (toAdd.length == 0) {
            return;
        }
        this.updateSearchFactory(toAdd);
        this.updateClusterRegistry(toAdd);
    }

    private void updateClusterRegistry(Class<?> ... classes) {
        for (Class<?> c : classes) {
            this.clusterRegistry.put(c, this.isIndexed(c));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSearchFactory(final Class<?> ... classes) {
        this.mutating.lock();
        try {
            this.transactionHelper.runSuspendingTx(new TransactionHelper.Operation(){

                @Override
                public void execute() {
                    boolean isStatisticsEnabled = SearchFactoryHandler.this.searchFactory.getStatistics().isStatisticsEnabled();
                    SearchFactoryHandler.this.searchFactory.addClasses(classes);
                    SearchFactoryHandler.this.searchFactory.getStatistics().setStatisticsEnabled(isStatisticsEnabled);
                }
            });
        }
        finally {
            this.mutating.unlock();
        }
    }

    public SearchFactoryIntegrator getSearchFactory() {
        return this.searchFactory;
    }

    Worker getWorker() {
        return this.searchFactory.getWorker();
    }

    boolean isIndexed(Class<?> c) {
        return this.searchFactory.getIndexBinding(c) != null;
    }

    private Class<?>[] filterAlreadyIndexed(Class ... classes) {
        ArrayList<Class> toAdd = new ArrayList<Class>(classes.length);
        for (Class type : classes) {
            if (this.clusterRegistry.containsKey(type)) continue;
            toAdd.add(type);
        }
        return toAdd.toArray(new Class[toAdd.size()]);
    }

    void handleClusterRegistryRegistration(Class<?> clazz) {
        if (this.isIndexed(clazz)) {
            return;
        }
        this.updateSearchFactory(clazz);
    }

    void enableClasses(Class[] classes) {
        this.handleOnDemandRegistration(classes);
    }
}

