/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.impl.FileListCacheValue;
import org.infinispan.lucene.impl.InfinispanIndexOutput;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class FileListOperations {
    private static final Log log = LogFactory.getLog(InfinispanIndexOutput.class);
    private final boolean trace = log.isTraceEnabled();
    private final FileListCacheKey fileListCacheKey;
    private final AdvancedCache<FileListCacheKey, Object> cache;
    private final String indexName;
    private final AdvancedCache<FileListCacheKey, FileListCacheValue> cacheNoRetrieve;

    public FileListOperations(AdvancedCache<?, ?> cache, String indexName) {
        this.cache = cache;
        this.cacheNoRetrieve = cache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
        this.indexName = indexName;
        this.fileListCacheKey = new FileListCacheKey(indexName);
    }

    void addFileName(String fileName) {
        FileListCacheValue fileList = this.getFileList();
        boolean done = fileList.add(fileName);
        if (done) {
            this.cacheNoRetrieve.put((Object)this.fileListCacheKey, (Object)fileList);
            if (this.trace) {
                log.trace((Object)("Updated file listing: added " + fileName));
            }
        }
    }

    public FileMetadata getFileMetadata(String fileName) {
        FileCacheKey key = new FileCacheKey(this.indexName, fileName);
        FileMetadata metadata = (FileMetadata)this.cache.get((Object)key);
        return metadata;
    }

    public void removeAndAdd(String toRemove, String toAdd) {
        FileListCacheValue fileList = this.getFileList();
        boolean done = fileList.addAndRemove(toAdd, toRemove);
        if (done) {
            this.cacheNoRetrieve.put((Object)this.fileListCacheKey, (Object)fileList);
            if (this.trace && done) {
                log.trace((Object)("Updated file listing: added " + toAdd + " and removed " + toRemove));
            }
        }
    }

    public String[] listFilenames() {
        return this.getFileList().toArray();
    }

    public boolean fileExists(String fileName) {
        return this.getFileList().contains(fileName);
    }

    public void deleteFileName(String fileName) {
        FileListCacheValue fileList = this.getFileList();
        boolean done = fileList.remove(fileName);
        if (done) {
            this.cacheNoRetrieve.put((Object)this.fileListCacheKey, (Object)fileList);
            if (this.trace) {
                log.trace((Object)("Updated file listing: removed " + fileName));
            }
        }
    }

    private FileListCacheValue getFileList() {
        FileListCacheValue prev;
        FileListCacheValue fileList = (FileListCacheValue)this.cache.get((Object)this.fileListCacheKey);
        if (fileList == null && (prev = (FileListCacheValue)this.cache.putIfAbsent((Object)this.fileListCacheKey, (Object)(fileList = new FileListCacheValue()))) != null) {
            fileList = prev;
        }
        if (this.trace) {
            log.trace((Object)"Refreshed file listing view");
        }
        return fileList;
    }
}

