/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Future;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.PingData;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.Buffer;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.Responses;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="Protocol to discover subgroups existing due to a network partition")
public class MERGE3
extends Protocol {
    protected long min_interval = 1000L;
    protected long max_interval = 10000L;
    @Property(description="The max number of merge participants to be involved in a merge. 0 sets this to unlimited.")
    protected int max_participants_in_merge = 100;
    @Property(description="Interval (in ms) after which we check for view inconsistencies")
    protected long check_interval = 0L;
    protected Address local_addr = null;
    protected volatile View view;
    protected TimeScheduler timer;
    protected Future<?> info_sender;
    protected Future<?> view_consistency_checker;
    protected final ConcurrentMap<ViewId, Set<Address>> views = new ConcurrentHashMap<ViewId, Set<Address>>(this.view != null ? this.view.size() : 16);
    protected final ResponseCollector<View> view_rsps = new ResponseCollector();
    protected boolean transport_supports_multicasting = true;
    protected String cluster_name;
    @ManagedAttribute(description="Whether or not the current member is the coordinator")
    protected volatile boolean is_coord = false;
    @ManagedAttribute(description="Number of times a MERGE event was sent up the stack")
    protected int num_merge_events = 0;

    @ManagedAttribute(description="Number of cached ViewIds")
    public int getViews() {
        return this.views.size();
    }

    @ManagedAttribute(description="Is the view consistency checker task running")
    public synchronized boolean isViewConsistencyCheckerRunning() {
        return this.view_consistency_checker != null && !this.view_consistency_checker.isDone();
    }

    @ManagedAttribute(description="Is the view consistency checker task running")
    public boolean isMergeTaskRunning() {
        return this.isViewConsistencyCheckerRunning();
    }

    @ManagedAttribute(description="Is the info sender task running")
    public synchronized boolean isInfoSenderRunning() {
        return this.info_sender != null && !this.info_sender.isDone();
    }

    @ManagedOperation(description="Lists the contents of the cached views")
    public String dumpViews() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.views.entrySet()) {
            sb.append(entry.getKey()).append(": [").append(Util.printListWithDelimiter((Collection)entry.getValue(), ", ", Util.MAX_LIST_PRINT_SIZE)).append("]\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Clears the views cache")
    public void clearViews() {
        this.views.clear();
    }

    @ManagedOperation(description="Send INFO")
    public void sendInfo() {
        new InfoSender().run();
    }

    @ManagedOperation(description="Check views for inconsistencies")
    public void checkInconsistencies() {
        new ViewConsistencyChecker().run();
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved");
        }
        if (this.min_interval >= this.max_interval) {
            throw new IllegalArgumentException("min_interval (" + this.min_interval + ") has to be < max_interval (" + this.max_interval + ")");
        }
        if (this.check_interval == 0L) {
            this.check_interval = this.computeCheckInterval();
        } else if (this.check_interval <= this.max_interval) {
            this.log.warn("set check_interval=%d as it is <= max_interval", this.computeCheckInterval());
            this.check_interval = this.computeCheckInterval();
        }
        if (this.max_interval <= 0L) {
            throw new Exception("max_interval must be > 0");
        }
        this.transport_supports_multicasting = this.getTransport().supportsMulticasting();
    }

    @Override
    public void stop() {
        super.stop();
        this.is_coord = false;
        this.stopViewConsistencyChecker();
        this.stopInfoSender();
    }

    public long getMinInterval() {
        return this.min_interval;
    }

    @Property(description="Minimum time in ms before sending an info message")
    public void setMinInterval(long i) {
        if (this.min_interval < 0L || this.min_interval >= this.max_interval) {
            throw new IllegalArgumentException("min_interval (" + this.min_interval + ") has to be < max_interval (" + this.max_interval + ")");
        }
        this.min_interval = i;
    }

    public long getMaxInterval() {
        return this.max_interval;
    }

    @Property(description="Interval (in milliseconds) when the next info message will be sent. A random value is picked from range [1..max_interval]")
    public void setMaxInterval(long val) {
        if (val <= 0L) {
            throw new IllegalArgumentException("max_interval must be > 0");
        }
        this.max_interval = val;
        this.check_interval = this.computeCheckInterval();
    }

    protected long computeCheckInterval() {
        return (long)((double)this.max_interval * 1.6);
    }

    protected boolean isMergeRunning() {
        Object retval = this.up_prot.up(new Event(100));
        return retval instanceof Boolean && (Boolean)retval != false;
    }

    protected synchronized void startInfoSender() {
        if (this.info_sender == null || this.info_sender.isDone()) {
            this.info_sender = this.timer.scheduleWithDynamicInterval(new InfoSender());
        }
    }

    protected synchronized void stopInfoSender() {
        if (this.info_sender != null) {
            this.info_sender.cancel(true);
            this.info_sender = null;
        }
    }

    protected synchronized void startViewConsistencyChecker() {
        if (this.view_consistency_checker == null || this.view_consistency_checker.isDone()) {
            this.view_consistency_checker = this.timer.scheduleWithDynamicInterval(new ViewConsistencyChecker());
        }
    }

    protected synchronized void stopViewConsistencyChecker() {
        if (this.view_consistency_checker != null) {
            this.view_consistency_checker.cancel(true);
            this.view_consistency_checker = null;
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.cluster_name = (String)evt.getArg();
                break;
            }
            case 4: {
                this.stopViewConsistencyChecker();
                this.stopInfoSender();
                break;
            }
            case 15: {
                this.stopViewConsistencyChecker();
                this.stopInfoSender();
                break;
            }
            case 6: {
                Address coord;
                this.stopViewConsistencyChecker();
                this.stopInfoSender();
                Object ret = this.down_prot.down(evt);
                this.view = (View)evt.getArg();
                this.clearViews();
                if (this.ergonomics && this.max_participants_in_merge > 0) {
                    this.max_participants_in_merge = Math.max(100, this.view.size() / 3);
                }
                this.startInfoSender();
                List<Address> mbrs = this.view.getMembers();
                Address address = coord = mbrs.isEmpty() ? null : mbrs.get(0);
                if (coord != null && coord.equals(this.local_addr)) {
                    this.is_coord = true;
                    this.startViewConsistencyChecker();
                } else {
                    this.is_coord = false;
                    this.clearViews();
                }
                return ret;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                MergeHeader hdr = (MergeHeader)msg.getHeader(this.getId());
                if (hdr == null) break;
                Address sender = msg.getSrc();
                switch (hdr.type) {
                    case INFO: {
                        this.addInfo(sender, hdr.view_id, hdr.logical_name, hdr.physical_addr);
                        break;
                    }
                    case VIEW_REQ: {
                        Message view_rsp = new Message(sender).setFlag(Message.Flag.INTERNAL).putHeader(this.getId(), MergeHeader.createViewResponse()).setBuffer(MERGE3.marshal(this.view));
                        this.down_prot.down(new Event(1, view_rsp));
                        break;
                    }
                    case VIEW_RSP: {
                        View tmp_view = this.readView(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                        if (tmp_view == null) break;
                        this.view_rsps.add(sender, tmp_view);
                        break;
                    }
                    default: {
                        this.log.error("Type %s not known", new Object[]{hdr.type});
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    public static List<View> detectDifferentViews(Map<Address, View> map) {
        ArrayList<View> ret = new ArrayList<View>();
        for (View view : map.values()) {
            ViewId vid;
            if (view == null || Util.containsViewId(ret, vid = view.getViewId())) continue;
            ret.add(view);
        }
        return ret;
    }

    public static Buffer marshal(View view) {
        return Util.streamableToBuffer(view);
    }

    protected View readView(byte[] buffer, int offset, int length) {
        try {
            return buffer != null ? Util.streamableFromBuffer(View.class, buffer, offset, length) : null;
        }
        catch (Exception ex) {
            this.log.error("%s: failed reading View from message: %s", this.local_addr, ex);
            return null;
        }
    }

    protected MergeHeader createInfo() {
        PhysicalAddress physical_addr = this.local_addr != null ? (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr)) : null;
        return MergeHeader.createInfo(this.view.getViewId(), UUID.get(this.local_addr), physical_addr);
    }

    protected void addInfo(Address sender, ViewId view_id, String logical_name, PhysicalAddress physical_addr) {
        Set tmp;
        Set<Address> existing;
        if (logical_name != null && sender instanceof UUID) {
            UUID.add(sender, logical_name);
        }
        if (physical_addr != null) {
            this.down(new Event(89, new Tuple<Address, PhysicalAddress>(sender, physical_addr)));
        }
        if ((existing = (ConcurrentSkipListSet<Address>)this.views.get(view_id)) == null && (tmp = (Set)this.views.putIfAbsent(view_id, existing = new ConcurrentSkipListSet<Address>())) != null) {
            existing = tmp;
        }
        existing.add(sender);
        for (Set set : this.views.values()) {
            if (set == existing) continue;
            set.remove(sender);
        }
    }

    public static class MergeHeader
    extends Header {
        protected Type type = Type.INFO;
        protected ViewId view_id;
        protected String logical_name;
        protected PhysicalAddress physical_addr;

        public MergeHeader() {
        }

        public static MergeHeader createInfo(ViewId view_id, String logical_name, PhysicalAddress physical_addr) {
            return new MergeHeader(Type.INFO, view_id, logical_name, physical_addr);
        }

        public static MergeHeader createViewRequest() {
            return new MergeHeader(Type.VIEW_REQ, null, null, null);
        }

        public static MergeHeader createViewResponse() {
            return new MergeHeader(Type.VIEW_RSP, null, null, null);
        }

        protected MergeHeader(Type type, ViewId view_id, String logical_name, PhysicalAddress physical_addr) {
            this.type = type;
            this.view_id = view_id;
            this.logical_name = logical_name;
            this.physical_addr = physical_addr;
        }

        @Override
        public int size() {
            int retval = 1;
            retval += Util.size(this.view_id);
            ++retval;
            if (this.logical_name != null) {
                retval += this.logical_name.length() + 2;
            }
            return retval += Util.size(this.physical_addr);
        }

        @Override
        public void writeTo(DataOutput outstream) throws Exception {
            outstream.writeByte(this.type.ordinal());
            Util.writeViewId(this.view_id, outstream);
            Bits.writeString(this.logical_name, outstream);
            Util.writeAddress(this.physical_addr, outstream);
        }

        @Override
        public void readFrom(DataInput instream) throws Exception {
            this.type = Type.values()[instream.readByte()];
            this.view_id = Util.readViewId(instream);
            this.logical_name = Bits.readString(instream);
            this.physical_addr = (PhysicalAddress)Util.readAddress(instream);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)((Object)this.type) + ": ");
            if (this.view_id != null) {
                sb.append("view_id=" + this.view_id);
            }
            sb.append(", logical_name=" + this.logical_name + ", physical_addr=" + this.physical_addr);
            return sb.toString();
        }

        protected static enum Type {
            INFO,
            VIEW_REQ,
            VIEW_RSP;

        }
    }

    protected class ViewConsistencyChecker
    implements TimeScheduler.Task {
        protected ViewConsistencyChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MergeHeader hdr = MERGE3.this.createInfo();
                MERGE3.this.addInfo(MERGE3.this.local_addr, hdr.view_id, hdr.logical_name, hdr.physical_addr);
                if (MERGE3.this.views.size() <= 1) {
                    MERGE3.this.log.trace("%s: found no inconsistent views: %s", MERGE3.this.local_addr, MERGE3.this.dumpViews());
                    return;
                }
                this._run();
            }
            finally {
                MERGE3.this.clearViews();
            }
        }

        protected void _run() {
            Address merge_leader;
            TreeSet<Address> coords = new TreeSet<Address>();
            for (Map.Entry entry : MERGE3.this.views.entrySet()) {
                Address coord = ((ViewId)entry.getKey()).getCreator();
                Set members = (Set)entry.getValue();
                if (members == null || !members.contains(coord)) continue;
                coords.add(coord);
            }
            Address address = merge_leader = coords.isEmpty() ? null : (Address)coords.first();
            if (merge_leader == null || MERGE3.this.local_addr == null || !merge_leader.equals(MERGE3.this.local_addr)) {
                MERGE3.this.log.trace("I (%s) won't be the merge leader", MERGE3.this.local_addr);
                return;
            }
            MERGE3.this.log.debug("I (%s) will be the merge leader", MERGE3.this.local_addr);
            for (Set set : MERGE3.this.views.values()) {
                if (set.isEmpty()) continue;
                coords.add((Address)set.iterator().next());
            }
            if (coords.size() <= 1) {
                MERGE3.this.log.trace("cancelling merge as we only have 1 coordinator: %s", coords);
                return;
            }
            MERGE3.this.log.trace("merge participants are %s", coords);
            if (MERGE3.this.max_participants_in_merge > 0 && coords.size() > MERGE3.this.max_participants_in_merge) {
                int old_size = coords.size();
                Iterator it = coords.iterator();
                while (it.hasNext()) {
                    Address next = (Address)it.next();
                    if (next.equals(merge_leader) || coords.size() <= MERGE3.this.max_participants_in_merge) continue;
                    it.remove();
                }
                MERGE3.this.log.trace("%s: reduced %d coords to %d", MERGE3.this.local_addr, old_size, MERGE3.this.max_participants_in_merge);
            }
            MERGE3.this.view_rsps.reset(coords);
            for (Address target : coords) {
                if (target.equals(MERGE3.this.local_addr)) {
                    if (MERGE3.this.view == null) continue;
                    MERGE3.this.view_rsps.add(MERGE3.this.local_addr, MERGE3.this.view);
                    continue;
                }
                Message view_req = new Message(target).setFlag(Message.Flag.INTERNAL).putHeader(MERGE3.this.getId(), MergeHeader.createViewRequest());
                MERGE3.this.down_prot.down(new Event(1, view_req));
            }
            MERGE3.this.view_rsps.waitForAllResponses(MERGE3.this.check_interval / 10L);
            Map<Address, View> results = MERGE3.this.view_rsps.getResults();
            HashMap<Address, View> merge_views = new HashMap<Address, View>();
            for (Map.Entry<Address, View> entry : results.entrySet()) {
                if (entry.getValue() == null) continue;
                merge_views.put(entry.getKey(), entry.getValue());
            }
            MERGE3.this.view_rsps.reset();
            if (merge_views.size() >= 2) {
                Collection tmp_views = merge_views.values();
                if (Util.allEqual(tmp_views)) {
                    MERGE3.this.log.trace("%s: all views are the same, suppressing sending MERGE up. Views: %s", MERGE3.this.local_addr, tmp_views);
                    return;
                }
                MERGE3.this.up_prot.up(new Event(14, merge_views));
                ++MERGE3.this.num_merge_events;
            }
        }

        @Override
        public long nextInterval() {
            return MERGE3.this.check_interval;
        }

        public String toString() {
            return MERGE3.class.getSimpleName() + ": " + this.getClass().getSimpleName();
        }
    }

    protected class InfoSender
    implements TimeScheduler.Task {
        protected final long discovery_timeout;

        protected InfoSender() {
            this.discovery_timeout = (MERGE3.this.max_interval + MERGE3.this.min_interval) / 2L;
        }

        @Override
        public void run() {
            if (MERGE3.this.view == null) {
                MERGE3.this.log.warn("view is null, cannot send INFO message");
                return;
            }
            MergeHeader hdr = MERGE3.this.createInfo();
            if (MERGE3.this.transport_supports_multicasting) {
                Message msg = new Message().setFlag(Message.Flag.INTERNAL).putHeader(MERGE3.this.getId(), hdr).setTransientFlag(Message.TransientFlag.DONT_LOOPBACK);
                MERGE3.this.down_prot.down(new Event(1, msg));
                return;
            }
            Responses rsps = (Responses)MERGE3.this.down_prot.down(Event.FIND_MBRS_EVT);
            rsps.waitFor(this.discovery_timeout);
            if (rsps.isEmpty()) {
                return;
            }
            MERGE3.this.log.trace("discovery protocol returned %d responses: %s", rsps.size(), rsps);
            for (PingData rsp : rsps) {
                PhysicalAddress dest;
                Address target = rsp.getAddress();
                if (MERGE3.this.local_addr.equals(target) || (dest = rsp.getPhysicalAddr()) == null) continue;
                Message info = new Message(dest).setFlag(Message.Flag.INTERNAL).putHeader(MERGE3.this.getId(), hdr);
                MERGE3.this.down_prot.down(new Event(1, info));
            }
        }

        @Override
        public long nextInterval() {
            return Math.max(MERGE3.this.min_interval, Util.random(MERGE3.this.max_interval) + MERGE3.this.max_interval / 2L);
        }

        public String toString() {
            return MERGE3.class.getSimpleName() + ": " + this.getClass().getSimpleName();
        }
    }
}

