/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jgroups.util.AsciiString;

public class Bits {
    public static void writeChar(char ch, ByteBuffer buf) {
    }

    public static void writeChar(char ch, DataOutput out) throws IOException {
    }

    public static char readChar(ByteBuffer buf) {
        return '\u0000';
    }

    public static char readChar(DataInput in) throws IOException {
        return '\u0000';
    }

    public static int size(char ch) {
        return 0;
    }

    public static void writeShort(short num, ByteBuffer buf) {
    }

    public static void writeShort(short num, DataOutput out) throws IOException {
    }

    public static short readShort(ByteBuffer buf) {
        return 0;
    }

    public static short readShort(DataInput in) throws IOException {
        return 0;
    }

    public static int readUnsignedShort(ByteBuffer buf) {
        return 0;
    }

    public static int readUnsignedShort(DataInput in) throws IOException {
        return 0;
    }

    public static int size(short num) {
        return 0;
    }

    public static short makeShort(byte a, byte b) {
        return (short)(a << 8 | b & 0xFF);
    }

    public static short makeShort(byte a) {
        return (short)(a & 0xFF);
    }

    public static void writeInt(int num, ByteBuffer buf) {
    }

    public static void writeInt(int num, DataOutput out) throws IOException {
    }

    public static int readInt(ByteBuffer buf) {
        return 0;
    }

    public static int readInt(DataInput in) throws IOException {
        return 0;
    }

    public static int size(int num) {
        return 0;
    }

    public static void writeLong(long num, ByteBuffer buf) {
    }

    public static void writeLong(long num, DataOutput out) throws IOException {
        if (num == 0L) {
            out.write(0);
            return;
        }
        int bytes_needed = Bits.bytesRequiredForLong(num);
        out.write(bytes_needed);
        for (int i = 0; i < bytes_needed; ++i) {
            out.write(Bits.getByteAt(num, i));
        }
    }

    public static long readLong(ByteBuffer buf) {
        return 0L;
    }

    public static long readLong(DataInput in) throws IOException {
        byte len = in.readByte();
        if (len == 0) {
            return 0L;
        }
        byte[] buf = new byte[len];
        in.readFully(buf, 0, len);
        return Bits.makeLong(buf, 0, len);
    }

    public static int size(long num) {
        return (byte)(num == 0L ? 1 : Bits.bytesRequiredForLong(num) + 1);
    }

    public static void writeLongSequence(long hd, long hr, ByteBuffer buf) {
    }

    public static void writeLongSequence(long hd, long hr, DataOutput out) throws IOException {
        int i;
        if (hr < hd) {
            throw new IllegalArgumentException("hr (" + hr + ") has to be >= hd (" + hd + ")");
        }
        if (hd == 0L && hr == 0L) {
            out.write(0);
            return;
        }
        long delta = hr - hd;
        int bytes_for_hd = Bits.bytesRequiredForLong(hd);
        int bytes_for_delta = Bits.bytesRequiredForLong(delta);
        byte bytes_needed = Bits.encodeLength((byte)bytes_for_hd, (byte)bytes_for_delta);
        out.write(bytes_needed);
        for (i = 0; i < bytes_for_hd; ++i) {
            out.write(Bits.getByteAt(hd, i));
        }
        for (i = 0; i < bytes_for_delta; ++i) {
            out.write(Bits.getByteAt(delta, i));
        }
    }

    public static long[] readLongSequence(ByteBuffer buf) {
        return null;
    }

    public static long[] readLongSequence(DataInput in) throws IOException {
        byte len = in.readByte();
        if (len == 0) {
            return new long[]{0L, 0L};
        }
        byte[] lengths = Bits.decodeLength(len);
        long[] seqnos = new long[2];
        byte[] buf = new byte[lengths[0] + lengths[1]];
        in.readFully(buf, 0, buf.length);
        seqnos[0] = Bits.makeLong(buf, 0, lengths[0]);
        seqnos[1] = Bits.makeLong(buf, lengths[0], lengths[1]) + seqnos[0];
        return seqnos;
    }

    public static byte size(long hd, long hr) {
        if (hd == 0L && hr == 0L) {
            return 1;
        }
        byte num_bytes_for_hd = Bits.bytesRequiredForLong(hd);
        byte num_bytes_for_delta = Bits.bytesRequiredForLong(hr - hd);
        return (byte)(num_bytes_for_hd + num_bytes_for_delta + 1);
    }

    public static long makeLong(byte[] buf, int offset, int bytes_to_read) {
        long retval = 0L;
        for (int i = 0; i < bytes_to_read; ++i) {
            byte b = buf[offset + i];
            retval |= ((long)b & 0xFFL) << i * 8;
        }
        return retval;
    }

    public static void writeFloat(float num, ByteBuffer buf) {
    }

    public static void writeFloat(float num, DataOutput out) throws IOException {
    }

    public static float readFloat(ByteBuffer buf) {
        return 0.0f;
    }

    public static float readFloat(DataInput in) throws IOException {
        return 0.0f;
    }

    public static int size(float num) {
        return 0;
    }

    public static void writeDouble(double num, ByteBuffer buf) {
    }

    public static void writeDouble(double num, DataOutput out) throws IOException {
    }

    public static double readDouble(ByteBuffer buf) {
        return 0.0;
    }

    public static double readDouble(DataInput in) throws IOException {
        return 0.0;
    }

    public static int size(double num) {
        return 0;
    }

    public static void writeString(String s, ByteBuffer buf) {
    }

    public static void writeString(String s, DataOutput out) throws IOException {
        if (s != null) {
            out.write(1);
            out.writeUTF(s);
        } else {
            out.write(0);
        }
    }

    public static String readString(ByteBuffer buf) {
        return null;
    }

    public static String readString(DataInput in) throws IOException {
        byte b = in.readByte();
        if (b == 1) {
            return in.readUTF();
        }
        return null;
    }

    public static int sizeUTF(String str) {
        int len = str != null ? str.length() : 0;
        int utflen = 2;
        if (len == 0) {
            return utflen;
        }
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public static void writeAsciiString(AsciiString s, ByteBuffer buf) {
        short length = (short)(s != null ? s.length() : -1);
        buf.putShort(length);
        if (s != null) {
            buf.put(s.chars());
        }
    }

    public static void writeAsciiString(AsciiString s, DataOutput out) throws IOException {
        short length = (short)(s != null ? s.length() : -1);
        out.writeShort(length);
        if (s != null) {
            out.write(s.chars());
        }
    }

    public static AsciiString readAsciiString(ByteBuffer buf) {
        short len = buf.getShort();
        if (len < 0) {
            return null;
        }
        AsciiString retval = new AsciiString(len);
        buf.get(retval.chars());
        return retval;
    }

    public static AsciiString readAsciiString(DataInput in) throws IOException {
        short len = in.readShort();
        if (len < 0) {
            return null;
        }
        AsciiString retval = new AsciiString(len);
        in.readFully(retval.chars());
        return retval;
    }

    public static int size(AsciiString str) {
        return str == null ? 2 : 2 + str.length();
    }

    protected static byte encodeLength(byte len1, byte len2) {
        byte retval = len2;
        retval = (byte)(retval | len1 << 4);
        return retval;
    }

    protected static byte[] decodeLength(byte len) {
        return new byte[]{(byte)((len & 0xFF) >> 4), (byte)(len & 0xFFFFFF0F)};
    }

    protected static byte bytesRequiredForLong(long number) {
        if (number >> 56 != 0L) {
            return 8;
        }
        if (number >> 48 != 0L) {
            return 7;
        }
        if (number >> 40 != 0L) {
            return 6;
        }
        if (number >> 32 != 0L) {
            return 5;
        }
        if (number >> 24 != 0L) {
            return 4;
        }
        if (number >> 16 != 0L) {
            return 3;
        }
        if (number >> 8 != 0L) {
            return 2;
        }
        if (number != 0L) {
            return 1;
        }
        return 1;
    }

    protected static byte getByteAt(long num, int index) {
        return (byte)(num >> index * 8);
    }
}

