/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.impl;

import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.cfg.impl.SearchConfigurationFromHibernateCore;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.Version;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.hcore.impl.SearchFactoryReference;
import org.hibernate.search.jmx.IndexControlMBean;
import org.hibernate.search.jmx.impl.IndexControl;
import org.hibernate.search.jmx.impl.JMXRegistrar;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class HibernateSearchSessionFactoryObserver
implements SessionFactoryObserver {
    public static final String SESSION_FACTORY_PROPERTY_KEY = "hibernate.search.hcore.session_factory";
    private static final Log log;
    private Configuration configuration;
    private ClassLoaderService classLoaderService;
    private final FullTextIndexEventListener listener;
    private String indexControlMBeanName;
    private SearchFactoryImplementor searchFactoryImplementor;

    public HibernateSearchSessionFactoryObserver(Configuration configuration, FullTextIndexEventListener listener, ClassLoaderService classLoaderService) {
        this.configuration = configuration;
        this.listener = listener;
        this.classLoaderService = classLoaderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionFactoryCreated(SessionFactory factory) {
        boolean failedBoot = true;
        try {
            String enableJMX;
            SessionFactoryImplementor factoryImplementor = (SessionFactoryImplementor)factory;
            this.configuration.getProperties().put(SESSION_FACTORY_PROPERTY_KEY, factory);
            if (this.searchFactoryImplementor == null) {
                this.searchFactoryImplementor = new SearchFactoryBuilder().configuration((SearchConfiguration)new SearchConfigurationFromHibernateCore(this.configuration, this.classLoaderService)).buildSearchFactory();
            }
            if ("true".equalsIgnoreCase(enableJMX = this.configuration.getProperty("hibernate.search.jmx_enabled"))) {
                this.enableIndexControlBean();
            }
            this.configuration = null;
            this.listener.initialize(this.searchFactoryImplementor);
            ((SearchFactoryReference)factoryImplementor.getServiceRegistry().getService(SearchFactoryReference.class)).initialize(this.searchFactoryImplementor);
            failedBoot = false;
        }
        finally {
            if (failedBoot) {
                factory.close();
            }
        }
    }

    public void sessionFactoryClosed(SessionFactory factory) {
        if (this.searchFactoryImplementor != null) {
            this.searchFactoryImplementor.close();
        }
        if (this.indexControlMBeanName != null) {
            JMXRegistrar.unRegisterMBean((String)this.indexControlMBeanName);
        }
    }

    private void enableIndexControlBean() {
        if (StringHelper.isEmpty((String)this.configuration.getProperty("hibernate.session_factory_name"))) {
            log.debug((Object)"In order to bind the IndexControlMBean the Hibernate SessionFactory has to be available via JNDI");
            return;
        }
        String mbeanNameSuffix = this.configuration.getProperty("hibernate.search.jmx_bean_suffix");
        String objectName = JMXRegistrar.buildMBeanName((String)"org.hibernate.search.jmx:type=IndexControlMBean", (String)mbeanNameSuffix);
        if (JMXRegistrar.isNameRegistered((String)objectName)) {
            JMXRegistrar.unRegisterMBean((String)objectName);
        }
        IndexControl indexCtrlBean = new IndexControl(this.configuration.getProperties(), this.searchFactoryImplementor.getServiceManager());
        JMXRegistrar.registerMBean((Object)indexCtrlBean, IndexControlMBean.class, (String)objectName);
        this.indexControlMBeanName = objectName;
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }
}

