/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.table.Block;
import org.iq80.leveldb.table.BlockHandle;
import org.iq80.leveldb.table.BlockTrailer;
import org.iq80.leveldb.table.Footer;
import org.iq80.leveldb.table.Table;
import org.iq80.leveldb.util.ByteBufferSupport;
import org.iq80.leveldb.util.Closeables;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.Slices;
import org.iq80.leveldb.util.Snappy;

public class MMapTable
extends Table {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private MappedByteBuffer data;

    public MMapTable(String name, FileChannel fileChannel, Comparator<Slice> comparator, boolean verifyChecksums) throws IOException {
        super(name, fileChannel, comparator, verifyChecksums);
    }

    @Override
    protected Footer init() throws IOException {
        long size = this.fileChannel.size();
        this.data = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        Slice footerSlice = Slices.copiedBuffer(this.data, (int)size - 48, 48);
        return Footer.readFooter(footerSlice);
    }

    @Override
    public Callable<?> closer() {
        return new Closer(this.name, this.fileChannel, this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Block readBlock(BlockHandle blockHandle) throws IOException {
        Slice uncompressedData;
        BlockTrailer blockTrailer = BlockTrailer.readBlockTrailer(Slices.copiedBuffer(this.data, (int)blockHandle.getOffset() + blockHandle.getDataSize(), 5));
        ByteBuffer uncompressedBuffer = MMapTable.read(this.data, (int)blockHandle.getOffset(), blockHandle.getDataSize());
        if (blockTrailer.getCompressionType() == CompressionType.SNAPPY) {
            Class<MMapTable> clazz = MMapTable.class;
            synchronized (MMapTable.class) {
                int uncompressedLength = this.uncompressedLength(uncompressedBuffer);
                if (uncompressedScratch.capacity() < uncompressedLength) {
                    uncompressedScratch = ByteBuffer.allocateDirect(uncompressedLength);
                }
                uncompressedScratch.clear();
                Snappy.uncompress(uncompressedBuffer, uncompressedScratch);
                uncompressedData = Slices.copiedBuffer(uncompressedScratch);
                // ** MonitorExit[var5_4] (shouldn't be in output)
            }
        } else {
            uncompressedData = Slices.copiedBuffer(uncompressedBuffer);
        }
        return new Block(uncompressedData, this.comparator);
    }

    public static ByteBuffer read(MappedByteBuffer data, int offset, int length) throws IOException {
        int newPosition = data.position() + offset;
        ByteBuffer block = (ByteBuffer)data.duplicate().order(ByteOrder.LITTLE_ENDIAN).clear().limit(newPosition + length).position(newPosition);
        return block;
    }

    private static class Closer
    implements Callable<Void> {
        private final String name;
        private final Closeable closeable;
        private final MappedByteBuffer data;

        public Closer(String name, Closeable closeable, MappedByteBuffer data) {
            this.name = name;
            this.closeable = closeable;
            this.data = data;
        }

        @Override
        public Void call() {
            ByteBufferSupport.unmap(this.data);
            Closeables.closeQuietly(this.closeable);
            return null;
        }
    }
}

