/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.commons.util.CloseableIterable;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.filter.AcceptAllKeyValueFilter;
import org.infinispan.filter.NullValueConverter;

public class SizeCommand
extends AbstractLocalCommand
implements VisitableCommand {
    private final Cache<Object, ?> cache;

    public SizeCommand(Cache<Object, ?> cache, Set<Flag> flags) {
        this.setFlags(flags);
        this.cache = cache;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitSizeCommand(ctx, this);
    }

    @Override
    public Integer perform(InvocationContext ctx) throws Throwable {
        int size = 0;
        Map<Object, CacheEntry> contextEntries = ctx.getLookedUpEntries();
        HashSet keys = new HashSet();
        try (CloseableIterable<CacheEntry<Object, Void>> iterator = this.cache.getAdvancedCache().withFlags(this.flags != null ? this.flags.toArray(new Flag[this.flags.size()]) : null).filterEntries(AcceptAllKeyValueFilter.getInstance()).converter(NullValueConverter.getInstance());){
            for (CacheEntry entry : iterator) {
                CacheEntry value = contextEntries.get(entry.getKey());
                if (value != null) {
                    keys.add(entry.getKey());
                    if (value.isRemoved()) continue;
                    ++size;
                    continue;
                }
                ++size;
            }
        }
        for (Map.Entry<Object, CacheEntry> entry : contextEntries.entrySet()) {
            if (keys.contains(entry.getKey()) || entry.getValue().isRemoved()) continue;
            ++size;
        }
        return size;
    }

    public String toString() {
        return "SizeCommand{}";
    }
}

