/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.TimeoutException;

public class Promise<T> {
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private T result = null;
    private volatile boolean hasResult = false;

    public Lock getLock() {
        return this.lock;
    }

    public Condition getCond() {
        return this.cond;
    }

    public T getResultWithTimeout(long timeout) throws TimeoutException {
        return this.getResultWithTimeout(timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResultWithTimeout(long timeout, boolean reset) throws TimeoutException {
        this.lock.lock();
        try {
            T t = this._getResultWithTimeout(timeout);
            return t;
        }
        finally {
            this.cond.signalAll();
            if (reset) {
                this.result = null;
                this.hasResult = false;
            }
            this.lock.unlock();
        }
    }

    public T getResult() {
        try {
            return this.getResultWithTimeout(0L);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public T getResult(long timeout) {
        return this.getResult(timeout, false);
    }

    public T getResult(long timeout, boolean reset) {
        try {
            return this.getResultWithTimeout(timeout, reset);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResult() {
        this.lock.lock();
        try {
            boolean bl = this.hasResult;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(T obj) {
        this.lock.lock();
        try {
            this.result = obj;
            this.hasResult = true;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.lock.lock();
        try {
            this.result = null;
            this.hasResult = false;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "hasResult=" + this.hasResult + ", result=" + this.result;
    }

    protected T _getResultWithTimeout(long timeout) throws TimeoutException {
        if (timeout <= 0L) {
            while (!this.hasResult) {
                try {
                    this.cond.await();
                }
                catch (Exception e) {}
            }
        } else {
            long wait_time = TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS);
            long target_time = System.nanoTime() + wait_time;
            while (wait_time > 0L && !this.hasResult) {
                wait_time = target_time - System.nanoTime();
                if (wait_time <= 0L) continue;
                try {
                    this.cond.await(wait_time, TimeUnit.NANOSECONDS);
                }
                catch (Exception e) {}
            }
            if (!this.hasResult && wait_time <= 0L) {
                throw new TimeoutException();
            }
        }
        return this.result;
    }
}

