/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.impl.lucene.IndexWriterHolder;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.impl.PropertiesParseHelper;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class AbstractWorkspaceImpl
implements Workspace {
    private static final Log log = LoggerFactory.make();
    private final OptimizerStrategy optimizerStrategy;
    private final Set<Class<?>> entitiesInIndexManager;
    private final DirectoryBasedIndexManager indexManager;
    protected final IndexWriterHolder writerHolder;
    private boolean indexMetadataIsComplete;
    private final AtomicLong operations = new AtomicLong(0L);

    public AbstractWorkspaceImpl(DirectoryBasedIndexManager indexManager, WorkerBuildContext context, Properties cfg) {
        this.indexManager = indexManager;
        this.optimizerStrategy = indexManager.getOptimizerStrategy();
        this.entitiesInIndexManager = indexManager.getContainedTypes();
        this.writerHolder = new IndexWriterHolder(context.getErrorHandler(), indexManager);
        this.indexMetadataIsComplete = PropertiesParseHelper.isIndexMetadataComplete(cfg, context);
    }

    @Override
    public DocumentBuilderIndexedEntity getDocumentBuilder(Class<?> entity) {
        return this.indexManager.getIndexBinding(entity).getDocumentBuilder();
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.indexManager.getAnalyzer(name);
    }

    @Override
    public void optimizerPhase() {
        this.optimizerStrategy.addOperationWithinTransactionCount(this.operations.getAndSet(0L));
        this.optimizerStrategy.optimize(this);
    }

    @Override
    public void performOptimization(IndexWriter writer) {
        this.optimizerStrategy.performOptimization(writer);
    }

    protected void incrementModificationCounter() {
        this.operations.addAndGet(1L);
    }

    @Override
    public Set<Class<?>> getEntitiesInIndexManager() {
        return this.entitiesInIndexManager;
    }

    @Override
    public void afterTransactionApplied(boolean someFailureHappened, boolean streaming) {
        this.getCommitPolicy().onChangeSetApplied(someFailureHappened, streaming);
    }

    public void shutDownNow() {
        this.getCommitPolicy().onClose();
        log.shuttingDownBackend(this.indexManager.getIndexName());
        this.writerHolder.closeIndexWriter();
    }

    @Override
    public IndexWriter getIndexWriter() {
        return this.writerHolder.getIndexWriter();
    }

    public IndexWriter getIndexWriter(ErrorContextBuilder errorContextBuilder) {
        return this.writerHolder.getIndexWriter(errorContextBuilder);
    }

    @Override
    public boolean areSingleTermDeletesSafe() {
        return this.indexMetadataIsComplete && this.entitiesInIndexManager.size() == 1;
    }

    @Override
    public void flush() {
        this.getCommitPolicy().onFlush();
    }
}

