/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.lang.reflect.AnnotatedElement;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class DateBridgeProvider
extends ExtendedBridgeProvider {
    private static final Log LOG = LoggerFactory.make();
    private static final FieldBridge DATE_YEAR = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_YEAR);
    private static final FieldBridge DATE_MONTH = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_MONTH);
    private static final FieldBridge DATE_DAY = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_DAY);
    private static final FieldBridge DATE_HOUR = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_HOUR);
    private static final FieldBridge DATE_MINUTE = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_MINUTE);
    private static final FieldBridge DATE_SECOND = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_SECOND);
    static final FieldBridge DATE_MILLISECOND = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_MILLISECOND);

    DateBridgeProvider() {
    }

    @Override
    public FieldBridge provideFieldBridge(ExtendedBridgeProvider.ExtendedBridgeProviderContext context) {
        AnnotatedElement annotatedElement = context.getAnnotatedElement();
        if (annotatedElement.isAnnotationPresent(DateBridge.class)) {
            Resolution resolution = annotatedElement.getAnnotation(DateBridge.class).resolution();
            return this.getDateField(resolution);
        }
        return null;
    }

    private FieldBridge getDateField(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return DATE_YEAR;
            }
            case MONTH: {
                return DATE_MONTH;
            }
            case DAY: {
                return DATE_DAY;
            }
            case HOUR: {
                return DATE_HOUR;
            }
            case MINUTE: {
                return DATE_MINUTE;
            }
            case SECOND: {
                return DATE_SECOND;
            }
            case MILLISECOND: {
                return DATE_MILLISECOND;
            }
        }
        throw LOG.unknownResolution(resolution.toString());
    }
}

