/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.EntityContext;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.dsl.impl.ConnectedQueryBuilder;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.util.impl.ScopedAnalyzer;

public class ConnectedQueryContextBuilder
implements QueryContextBuilder {
    private final SearchFactoryImplementor factory;

    public ConnectedQueryContextBuilder(SearchFactoryImplementor factory) {
        this.factory = factory;
    }

    @Override
    public EntityContext forEntity(Class<?> entityType) {
        return new HSearchEntityContext(entityType, this.factory);
    }

    public final class HSearchEntityContext
    implements EntityContext {
        private final ScopedAnalyzer queryAnalyzer;
        private final QueryBuildingContext context;

        public HSearchEntityContext(Class<?> entityType, SearchFactoryImplementor factory) {
            Class<?> indexBoundType = this.getIndexBoundType(entityType, factory);
            if (indexBoundType == null) {
                throw new SearchException(String.format("Can't build query for type %s which is neither indexed nor has any indexed sub-types.", entityType.getCanonicalName()));
            }
            this.queryAnalyzer = new ScopedAnalyzer(factory.getAnalyzer(indexBoundType));
            this.context = new QueryBuildingContext(factory, (Analyzer)this.queryAnalyzer, indexBoundType);
        }

        private Class<?> getIndexBoundType(Class<?> entityType, SearchFactoryImplementor factory) {
            if (factory.getIndexBinding(entityType) != null) {
                return entityType;
            }
            Set<Class<?>> indexedSubTypes = factory.getIndexedTypesPolymorphic(new Class[]{entityType});
            if (!indexedSubTypes.isEmpty()) {
                return indexedSubTypes.iterator().next();
            }
            return null;
        }

        @Override
        public EntityContext overridesForField(String field, String analyzerName) {
            this.queryAnalyzer.addScopedAnalyzer(field, ConnectedQueryContextBuilder.this.factory.getAnalyzer(analyzerName));
            return this;
        }

        @Override
        public QueryBuilder get() {
            return new ConnectedQueryBuilder(this.context);
        }
    }
}

