/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.impl.ProtoStreamReaderImpl;
import org.infinispan.protostream.impl.ProtoStreamWriterImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.infinispan.protostream.impl.WrappedMessageMarshaller;

public final class ProtobufUtil {
    private static final String WRAPPING_DEFINITIONS_RES = "/org/infinispan/protostream/message-wrapping.proto";

    public static SerializationContext newSerializationContext(Configuration configuration) {
        SerializationContextImpl serializationContext = new SerializationContextImpl(configuration);
        try {
            serializationContext.registerProtoFiles(FileDescriptorSource.fromResources(WRAPPING_DEFINITIONS_RES));
        }
        catch (IOException | DescriptorParserException e) {
            throw new RuntimeException("Failed to initialize serialization context", e);
        }
        serializationContext.registerMarshaller(new WrappedMessageMarshaller());
        return serializationContext;
    }

    public static <A> void writeTo(SerializationContext ctx, CodedOutputStream out, A t) throws IOException {
        if (t == null) {
            throw new IllegalArgumentException("Object to marshall cannot be null");
        }
        ProtoStreamWriterImpl writer = new ProtoStreamWriterImpl((SerializationContextImpl)ctx);
        writer.write(out, t);
    }

    public static void writeTo(SerializationContext ctx, OutputStream out, Object t) throws IOException {
        ProtobufUtil.writeTo(ctx, CodedOutputStream.newInstance((OutputStream)out), t);
    }

    public static byte[] toByteArray(SerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ProtobufUtil.writeTo(ctx, baos, t);
        return baos.toByteArray();
    }

    public static <A> A readFrom(SerializationContext ctx, CodedInputStream in, Class<A> clazz) throws IOException {
        ProtoStreamReaderImpl reader = new ProtoStreamReaderImpl((SerializationContextImpl)ctx);
        return reader.read(in, clazz);
    }

    public static <A> A readFrom(SerializationContext ctx, InputStream in, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, CodedInputStream.newInstance((InputStream)in), clazz);
    }

    public static <A> A fromByteArray(SerializationContext ctx, byte[] bytes, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, CodedInputStream.newInstance((byte[])bytes), clazz);
    }

    public static <A> A fromByteArray(SerializationContext ctx, byte[] bytes, int offset, int length, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, CodedInputStream.newInstance((byte[])bytes, (int)offset, (int)length), clazz);
    }

    public static Object fromWrappedByteArray(SerializationContext ctx, byte[] bytes) throws IOException {
        return ProtobufUtil.fromWrappedByteArray(ctx, bytes, 0, bytes.length);
    }

    public static Object fromWrappedByteArray(SerializationContext ctx, byte[] bytes, int offset, int length) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes, offset, length);
        return WrappedMessageMarshaller.readWrappedMessage(ctx, CodedInputStream.newInstance((InputStream)bais));
    }

    public static byte[] toWrappedByteArray(SerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WrappedMessageMarshaller.writeWrappedMessage(ctx, CodedOutputStream.newInstance((OutputStream)baos), t);
        return baos.toByteArray();
    }
}

