/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;

public enum IndexModificationStrategy {
    MANUAL{

        @Override
        public boolean shouldModifyIndexes(FlagAffectedCommand command, InvocationContext ctx) {
            return false;
        }
    }
    ,
    ALL{

        @Override
        public boolean shouldModifyIndexes(FlagAffectedCommand command, InvocationContext ctx) {
            return !command.hasFlag(Flag.SKIP_INDEXING);
        }
    }
    ,
    LOCAL_ONLY{

        @Override
        public boolean shouldModifyIndexes(FlagAffectedCommand command, InvocationContext ctx) {
            return ctx.isOriginLocal() && !command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER) && !command.hasFlag(Flag.SKIP_INDEXING);
        }
    };


    public abstract boolean shouldModifyIndexes(FlagAffectedCommand var1, InvocationContext var2);

    public static IndexModificationStrategy configuredStrategy(SearchFactoryIntegrator searchFactory, Configuration cfg) {
        if ("manual".equals(((SearchFactoryImplementor)searchFactory).getIndexingStrategy())) {
            return MANUAL;
        }
        if (cfg.indexing().index().isLocalOnly()) {
            return LOCAL_ONLY;
        }
        return ALL;
    }
}

