/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.FullTextFilter;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.EagerIterator;
import org.infinispan.query.impl.EntityLoader;
import org.infinispan.query.impl.LazyIterator;
import org.infinispan.query.impl.NullFilteringResultIterator;
import org.infinispan.query.impl.ProjectionConverter;
import org.infinispan.query.impl.ProjectionLoader;
import org.infinispan.query.impl.QueryResultLoader;

public class CacheQueryImpl
implements CacheQuery {
    private static final FetchOptions DEFAULT_FETCH_OPTIONS = new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER);
    protected final AdvancedCache<?, ?> cache;
    protected final KeyTransformationHandler keyTransformationHandler;
    protected HSQuery hSearchQuery;
    private ProjectionConverter projectionConverter;

    public CacheQueryImpl(Query luceneQuery, SearchFactoryIntegrator searchFactory, AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler, Class<?> ... classes) {
        this(luceneQuery, searchFactory, cache, keyTransformationHandler, (TimeoutExceptionFactory)null, classes);
    }

    public CacheQueryImpl(Query luceneQuery, SearchFactoryIntegrator searchFactory, AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler, TimeoutExceptionFactory timeoutExceptionFactory, Class<?> ... classes) {
        this.keyTransformationHandler = keyTransformationHandler;
        this.cache = cache;
        this.hSearchQuery = searchFactory.createHSQuery();
        this.hSearchQuery.luceneQuery(luceneQuery).targetedEntities(Arrays.asList(classes));
        if (timeoutExceptionFactory != null) {
            this.hSearchQuery.timeoutExceptionFactory(timeoutExceptionFactory);
        }
    }

    @Override
    public CacheQuery filter(Filter filter) {
        this.hSearchQuery.filter(filter);
        return this;
    }

    @Override
    public int getResultSize() {
        return this.hSearchQuery.queryResultSize();
    }

    @Override
    public CacheQuery sort(Sort sort) {
        this.hSearchQuery.sort(sort);
        return this;
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        return this.hSearchQuery.enableFullTextFilter(name);
    }

    @Override
    public CacheQuery disableFullTextFilter(String name) {
        this.hSearchQuery.disableFullTextFilter(name);
        return this;
    }

    @Override
    public CacheQuery firstResult(int firstResult) {
        this.hSearchQuery.firstResult(firstResult);
        return this;
    }

    @Override
    public CacheQuery maxResults(int maxResults) {
        this.hSearchQuery.maxResults(maxResults);
        return this;
    }

    @Override
    public ResultIterator iterator() throws SearchException {
        return this.iterator(DEFAULT_FETCH_OPTIONS);
    }

    @Override
    public ResultIterator iterator(FetchOptions fetchOptions) throws SearchException {
        if (fetchOptions.getFetchMode() == FetchOptions.FetchMode.EAGER) {
            this.hSearchQuery.getTimeoutManager().start();
            List entityInfos = this.hSearchQuery.queryEntityInfos();
            return this.filterNulls(new EagerIterator(entityInfos, this.getResultLoader(), fetchOptions.getFetchSize()));
        }
        if (fetchOptions.getFetchMode() == FetchOptions.FetchMode.LAZY) {
            DocumentExtractor extractor = this.hSearchQuery.queryDocumentExtractor();
            return this.filterNulls(new LazyIterator(extractor, this.getResultLoader(), fetchOptions.getFetchSize()));
        }
        throw new IllegalArgumentException("Unknown FetchMode " + (Object)((Object)fetchOptions.getFetchMode()));
    }

    private ResultIterator filterNulls(ResultIterator iterator) {
        return new NullFilteringResultIterator(iterator);
    }

    @Override
    public List<Object> list() throws SearchException {
        this.hSearchQuery.getTimeoutManager().start();
        List entityInfos = this.hSearchQuery.queryEntityInfos();
        return this.getResultLoader().load(entityInfos);
    }

    private QueryResultLoader getResultLoader() {
        return this.isProjected() ? this.getProjectionLoader() : this.getEntityLoader();
    }

    private boolean isProjected() {
        return this.hSearchQuery.getProjectedFields() != null;
    }

    private ProjectionLoader getProjectionLoader() {
        return new ProjectionLoader(this.projectionConverter, this.getEntityLoader());
    }

    private EntityLoader getEntityLoader() {
        return new EntityLoader(this.cache, this.keyTransformationHandler);
    }

    @Override
    public FacetManager getFacetManager() {
        return this.hSearchQuery.getFacetManager();
    }

    @Override
    public Explanation explain(int documentId) {
        return this.hSearchQuery.explain(documentId);
    }

    @Override
    public CacheQuery projection(String ... fields) {
        this.projectionConverter = new ProjectionConverter(fields, this.cache, this.keyTransformationHandler);
        this.hSearchQuery.projection(this.projectionConverter.getHSearchProjection());
        return this;
    }

    @Override
    public CacheQuery timeout(long timeout, TimeUnit timeUnit) {
        this.hSearchQuery.getTimeoutManager().setTimeout(timeout, timeUnit);
        return this;
    }
}

