/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.AvailabilityStrategy;
import org.infinispan.partitionhandling.impl.AvailabilityStrategyContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PreferConsistencyStrategy
implements AvailabilityStrategy {
    private static final Log log = LogFactory.getLog(PreferConsistencyStrategy.class);

    @Override
    public void onJoin(AvailabilityStrategyContext context, Address joiner) {
        if (context.getAvailabilityMode() != AvailabilityMode.AVAILABLE) {
            log.debugf("Cache %s not available (%s), postponing rebalance for joiner %s", context.getCacheName(), (Object)context.getAvailabilityMode(), joiner);
            return;
        }
        context.queueRebalance(context.getExpectedMembers());
    }

    @Override
    public void onGracefulLeave(AvailabilityStrategyContext context, Address leaver) {
        CacheTopology currentTopology = context.getCurrentTopology();
        ArrayList<Address> newMembers = new ArrayList<Address>(currentTopology.getMembers());
        newMembers.remove(leaver);
        if (newMembers.isEmpty()) {
            log.debugf("The last node of cache %s left", context.getCacheName());
            context.updateCurrentTopology(newMembers);
            return;
        }
        if (context.getAvailabilityMode() != AvailabilityMode.AVAILABLE) {
            log.debugf("Cache %s is not available, ignoring graceful leaver %s", context.getCacheName(), leaver);
            return;
        }
        if (this.isDataLost(context.getStableTopology().getCurrentCH(), newMembers)) {
            log.enteringUnavailableModeGracefulLeaver(context.getCacheName(), leaver);
            context.updateAvailabilityMode(AvailabilityMode.UNAVAILABLE, true);
            return;
        }
        this.updateMembersAndRebalance(context, newMembers);
    }

    @Override
    public void onClusterViewChange(AvailabilityStrategyContext context, List<Address> clusterMembers) {
        if (context.getAvailabilityMode() != AvailabilityMode.AVAILABLE) {
            log.debugf("Cache %s is not available, ignoring cluster view change", context.getCacheName());
            return;
        }
        CacheTopology currentTopology = context.getCurrentTopology();
        ArrayList<Address> newMembers = new ArrayList<Address>(currentTopology.getMembers());
        if (!newMembers.retainAll(clusterMembers)) {
            log.debugf("Cache %s did not lose any members, ignoring view change", context.getCacheName());
            return;
        }
        CacheTopology stableTopology = context.getStableTopology();
        List<Address> stableMembers = stableTopology.getMembers();
        ArrayList<Address> lostMembers = new ArrayList<Address>(stableMembers);
        lostMembers.removeAll(newMembers);
        if (this.isDataLost(stableTopology.getCurrentCH(), newMembers)) {
            log.enteringDegradedModeLostData(context.getCacheName(), lostMembers);
            context.updateAvailabilityMode(AvailabilityMode.DEGRADED_MODE, true);
            return;
        }
        if (this.isMinorityPartition(stableMembers, lostMembers)) {
            log.enteringDegradedModeMinorityPartition(context.getCacheName(), newMembers, lostMembers, stableMembers);
            context.updateAvailabilityMode(AvailabilityMode.DEGRADED_MODE, true);
            return;
        }
        this.updateMembersAndRebalance(context, newMembers);
    }

    protected boolean isMinorityPartition(List<Address> stableMembers, List<Address> lostMembers) {
        return (double)lostMembers.size() >= Math.ceil((double)stableMembers.size() / 2.0);
    }

    @Override
    public void onPartitionMerge(AvailabilityStrategyContext context, Collection<CacheStatusResponse> statusResponses) {
        ArrayList<Address> newMembers;
        CacheTopology mergedTopology;
        AvailabilityMode mergedAvailabilityMode;
        int maxTopologyId = 0;
        CacheTopology maxStableTopology = null;
        CacheTopology maxActiveTopology = null;
        HashSet<CacheTopology> unavailableTopologies = new HashSet<CacheTopology>();
        HashSet<CacheTopology> degradedTopologies = new HashSet<CacheTopology>();
        for (CacheStatusResponse response : statusResponses) {
            CacheTopology partitionTopology;
            CacheTopology partitionStableTopology = response.getStableTopology();
            if (partitionStableTopology == null) continue;
            if (maxStableTopology == null || maxStableTopology.getTopologyId() < partitionStableTopology.getTopologyId()) {
                maxStableTopology = partitionStableTopology;
            }
            if ((partitionTopology = response.getCacheTopology()) == null) continue;
            if (partitionTopology.getTopologyId() > maxTopologyId) {
                maxTopologyId = partitionTopology.getTopologyId();
            }
            if (response.getAvailabilityMode() == AvailabilityMode.AVAILABLE) {
                if (maxActiveTopology != null && maxActiveTopology.getTopologyId() >= partitionTopology.getTopologyId()) continue;
                maxActiveTopology = partitionTopology;
                continue;
            }
            if (response.getAvailabilityMode() == AvailabilityMode.DEGRADED_MODE) {
                degradedTopologies.add(partitionTopology);
                continue;
            }
            if (response.getAvailabilityMode() == AvailabilityMode.UNAVAILABLE) {
                unavailableTopologies.add(partitionTopology);
                continue;
            }
            log.unexpectedAvailabilityMode(context.getAvailabilityMode(), context.getCacheName(), response.getCacheTopology());
        }
        if (maxStableTopology != null) {
            log.tracef("Max stable partition topology: %s", maxStableTopology);
        }
        if (maxActiveTopology != null) {
            log.tracef("Max active partition topology: %s", maxActiveTopology);
        }
        if (!degradedTopologies.isEmpty()) {
            log.tracef("Found degraded partition topologies: %s", degradedTopologies);
        }
        if (!unavailableTopologies.isEmpty()) {
            log.tracef("Found unavailable partition topologies: %s", unavailableTopologies);
        }
        if (!unavailableTopologies.isEmpty()) {
            log.debugf("At least one of the partitions is unavailable, staying in unavailable mode", new Object[0]);
            mergedAvailabilityMode = AvailabilityMode.UNAVAILABLE;
            mergedTopology = (CacheTopology)unavailableTopologies.iterator().next();
        } else if (maxActiveTopology != null) {
            log.debugf("One of the partitions is available, using that partition's topology", new Object[0]);
            newMembers = new ArrayList<Address>(maxActiveTopology.getMembers());
            newMembers.retainAll(context.getExpectedMembers());
            mergedAvailabilityMode = this.computeAvailabilityAfterMerge(context, maxStableTopology, newMembers);
            mergedTopology = maxActiveTopology;
        } else if (!degradedTopologies.isEmpty()) {
            log.debugf("No active or unavailable partitions, so all the partitions must be in degraded mode.", new Object[0]);
            newMembers = new ArrayList<Address>(maxStableTopology.getMembers());
            newMembers.retainAll(context.getExpectedMembers());
            mergedAvailabilityMode = this.computeAvailabilityAfterMerge(context, maxStableTopology, newMembers);
            mergedTopology = maxStableTopology;
        } else {
            log.debugf("No current topology, recovered only joiners for cache %s", context.getCacheName());
            mergedAvailabilityMode = AvailabilityMode.AVAILABLE;
            mergedTopology = null;
        }
        if (mergedTopology != null) {
            mergedTopology = new CacheTopology(maxTopologyId + 1, mergedTopology.getRebalanceId(), mergedTopology.getCurrentCH(), null);
        }
        context.updateTopologiesAfterMerge(mergedTopology, maxStableTopology, mergedAvailabilityMode);
        if (mergedAvailabilityMode == AvailabilityMode.UNAVAILABLE) {
            log.debugf("After merge, cache %s is staying in unavailable mode", context.getCacheName());
            context.updateAvailabilityMode(AvailabilityMode.UNAVAILABLE, true);
            return;
        }
        if (mergedAvailabilityMode == AvailabilityMode.AVAILABLE) {
            log.debugf("After merge, cache %s has recovered and is entering available mode", new Object[0]);
            this.updateMembersAndRebalance(context, context.getExpectedMembers());
        }
    }

    protected AvailabilityMode computeAvailabilityAfterMerge(AvailabilityStrategyContext context, CacheTopology maxStableTopology, List<Address> newMembers) {
        if (maxStableTopology != null) {
            List<Address> stableMembers = maxStableTopology.getMembers();
            ArrayList<Address> lostMembers = new ArrayList<Address>(stableMembers);
            lostMembers.removeAll(context.getExpectedMembers());
            if (this.isDataLost(maxStableTopology.getCurrentCH(), newMembers)) {
                log.keepingDegradedModeAfterMergeDataLost(context.getCacheName(), newMembers, lostMembers, stableMembers);
                return AvailabilityMode.DEGRADED_MODE;
            }
            if ((double)lostMembers.size() >= Math.ceil((double)stableMembers.size() / 2.0)) {
                log.keepingDegradedModeAfterMergeMinorityPartition(context.getCacheName(), newMembers, lostMembers, stableMembers);
                return AvailabilityMode.DEGRADED_MODE;
            }
        }
        return AvailabilityMode.AVAILABLE;
    }

    @Override
    public void onRebalanceEnd(AvailabilityStrategyContext context) {
    }

    @Override
    public void onManualAvailabilityChange(AvailabilityStrategyContext context, AvailabilityMode newAvailabilityMode) {
        if (newAvailabilityMode == AvailabilityMode.AVAILABLE) {
            List<Address> newMembers = context.getExpectedMembers();
            context.updateCurrentTopology(newMembers);
            context.updateAvailabilityMode(newAvailabilityMode, false);
            context.queueRebalance(newMembers);
        } else {
            context.updateAvailabilityMode(newAvailabilityMode, true);
        }
    }

    private void updateMembersAndRebalance(AvailabilityStrategyContext context, List<Address> newMembers) {
        context.updateAvailabilityMode(AvailabilityMode.AVAILABLE, false);
        context.updateCurrentTopology(newMembers);
        context.queueRebalance(context.getExpectedMembers());
    }

    private boolean isDataLost(ConsistentHash currentCH, List<Address> newMembers) {
        for (int i = 0; i < currentCH.getNumSegments(); ++i) {
            if (InfinispanCollections.containsAny(newMembers, currentCH.locateOwnersForSegment(i))) continue;
            return true;
        }
        return false;
    }
}

