/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.NotSerializableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.context.Flag;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.topology.CacheTopologyControlCommand;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.BackupReceiverRepository;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.jgroups.Address;
import org.jgroups.AnycastAddress;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.Message;
import org.jgroups.SuspectedException;
import org.jgroups.UpHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.blocks.mux.Muxer;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.util.Buffer;
import org.jgroups.util.FutureListener;
import org.jgroups.util.NotifyingFuture;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class CommandAwareRpcDispatcher
extends RpcDispatcher {
    private final ExecutorService asyncExecutor;
    private final ExecutorService remoteCommandsExecutor;
    private final InboundInvocationHandler inboundInvocationHandler;
    private static final Log log = LogFactory.getLog(CommandAwareRpcDispatcher.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final boolean FORCE_MCAST = Boolean.getBoolean("infinispan.unsafe.force_multicast");
    private final JGroupsTransport transport;
    private final GlobalComponentRegistry gcr;
    private final BackupReceiverRepository backupReceiverRepository;

    public CommandAwareRpcDispatcher(Channel channel, JGroupsTransport transport, ExecutorService asyncExecutor, ExecutorService remoteCommandsExecutor, InboundInvocationHandler inboundInvocationHandler, GlobalComponentRegistry gcr, BackupReceiverRepository backupReceiverRepository) {
        this.server_obj = transport;
        this.asyncExecutor = asyncExecutor;
        this.remoteCommandsExecutor = remoteCommandsExecutor;
        this.inboundInvocationHandler = inboundInvocationHandler;
        this.transport = transport;
        this.gcr = gcr;
        this.backupReceiverRepository = backupReceiverRepository;
        this.setMembershipListener(transport);
        this.setChannel(channel);
        UpHandler handler = channel.getUpHandler();
        if (handler instanceof Muxer) {
            Muxer mux = (Muxer)handler;
            mux.setDefaultHandler((Object)this.prot_adapter);
        }
        channel.addChannelListener((ChannelListener)this);
        this.asyncDispatching(true);
    }

    private boolean isValid(Message req) {
        if (req == null || req.getLength() == 0) {
            log.msgOrMsgBufferEmpty();
            return false;
        }
        return true;
    }

    public RspList<Object> invokeRemoteCommands(final List<Address> recipients, final ReplicableCommand command, final ResponseMode mode, final long timeout, final boolean oob, final RspFilter filter, boolean asyncMarshalling, final boolean ignoreLeavers, final boolean totalOrder) throws InterruptedException {
        RspList<Object> response;
        if (asyncMarshalling) {
            this.asyncExecutor.submit(new Callable<RspList<Object>>(){

                @Override
                public RspList<Object> call() throws Exception {
                    return CommandAwareRpcDispatcher.processCalls(command, recipients == null, timeout, filter, recipients, mode, CommandAwareRpcDispatcher.this.req_marshaller, CommandAwareRpcDispatcher.this, oob, ignoreLeavers, totalOrder);
                }
            });
            return null;
        }
        try {
            response = CommandAwareRpcDispatcher.processCalls(command, recipients == null, timeout, filter, recipients, mode, this.req_marshaller, this, oob, ignoreLeavers, totalOrder);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (SuspectedException e) {
            throw new SuspectException("One of the nodes " + recipients + " was suspected", e);
        }
        catch (org.jgroups.TimeoutException e) {
            throw new org.infinispan.util.concurrent.TimeoutException("One of the nodes " + recipients + " timed out", e);
        }
        catch (Exception e) {
            throw Util.rewrapAsCacheException((Throwable)e);
        }
        if (mode == ResponseMode.GET_NONE) {
            return null;
        }
        if (response.isEmpty() || this.containsOnlyNulls(response)) {
            return null;
        }
        return response;
    }

    public Response invokeRemoteCommand(final Address recipient, final ReplicableCommand command, final ResponseMode mode, final long timeout, final boolean oob, boolean asyncMarshalling) throws InterruptedException {
        Response response;
        if (asyncMarshalling) {
            this.asyncExecutor.submit(new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    return CommandAwareRpcDispatcher.processSingleCall(command, timeout, recipient, mode, CommandAwareRpcDispatcher.this.req_marshaller, CommandAwareRpcDispatcher.this, oob, CommandAwareRpcDispatcher.this.transport);
                }
            });
            return null;
        }
        try {
            response = CommandAwareRpcDispatcher.processSingleCall(command, timeout, recipient, mode, this.req_marshaller, this, oob, this.transport);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (SuspectedException e) {
            throw new SuspectException("Node " + recipient + " was suspected", e);
        }
        catch (org.jgroups.TimeoutException e) {
            throw new org.infinispan.util.concurrent.TimeoutException("Node " + recipient + " timed out", e);
        }
        catch (Exception e) {
            throw Util.rewrapAsCacheException((Throwable)e);
        }
        if (mode == ResponseMode.GET_NONE) {
            return null;
        }
        return response;
    }

    public RspList<Object> broadcastRemoteCommands(ReplicableCommand command, ResponseMode mode, long timeout, boolean oob, RspFilter filter, boolean asyncMarshalling, boolean ignoreLeavers, boolean totalOrder) throws InterruptedException {
        return this.invokeRemoteCommands(null, command, mode, timeout, oob, filter, asyncMarshalling, ignoreLeavers, totalOrder);
    }

    private boolean containsOnlyNulls(RspList<Object> l) {
        for (Rsp r : l.values()) {
            if (r.getValue() == null && r.wasReceived() && !r.wasSuspected()) continue;
            return false;
        }
        return true;
    }

    public void handle(Message req, org.jgroups.blocks.Response response) throws Exception {
        block9: {
            if (this.isValid(req)) {
                boolean preserveOrder = !req.isFlagSet(Message.Flag.OOB);
                ReplicableCommand cmd = null;
                try {
                    cmd = (ReplicableCommand)this.req_marshaller.objectFromBuffer(req.getRawBuffer(), req.getOffset(), req.getLength());
                    if (cmd == null) {
                        throw new NullPointerException("Unable to execute a null command!  Message was " + req);
                    }
                    if (req.getSrc() instanceof SiteAddress) {
                        this.executeCommandFromRemoteSite(cmd, (SiteAddress)req.getSrc(), response, preserveOrder);
                        break block9;
                    }
                    this.executeCommandFromLocalCluster(cmd, req, response, preserveOrder);
                }
                catch (InterruptedException e) {
                    log.shutdownHandlingCommand(cmd);
                    this.reply(response, new ExceptionResponse((Exception)((Object)new CacheException("Cache is shutting down"))));
                }
                catch (Throwable x) {
                    if (cmd == null) {
                        log.errorUnMarshallingCommand(x);
                    } else {
                        log.exceptionHandlingCommand(cmd, x);
                    }
                    this.reply(response, new ExceptionResponse((Exception)((Object)new CacheException("Problems invoking command.", x))));
                }
            } else {
                this.reply(response, null);
            }
        }
    }

    private void executeCommandFromRemoteSite(final ReplicableCommand cmd, SiteAddress src, final org.jgroups.blocks.Response response, boolean preserveOrder) throws Throwable {
        if (!(cmd instanceof XSiteReplicateCommand)) {
            throw new IllegalStateException("Only XSiteReplicateCommand commands expected as a result of xsite calls but got " + cmd.getClass().getName());
        }
        if (trace) {
            log.tracef("Handling command %s from remote site %s", cmd, src);
        }
        ((XSiteReplicateCommand)cmd).setOriginSite(src.getSite());
        final BackupReceiver receiver = this.backupReceiverRepository.getBackupReceiver(src.getSite(), ((XSiteReplicateCommand)cmd).getCacheName());
        if (preserveOrder) {
            this.reply(response, ((XSiteReplicateCommand)cmd).performInLocalSite(receiver));
            return;
        }
        this.remoteCommandsExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CommandAwareRpcDispatcher.this.reply(response, ((XSiteReplicateCommand)cmd).performInLocalSite(receiver));
                }
                catch (InterruptedException e) {
                    log.shutdownHandlingCommand(cmd);
                    CommandAwareRpcDispatcher.this.reply(response, new ExceptionResponse((Exception)((Object)new CacheException("Cache is shutting down"))));
                }
                catch (Throwable throwable) {
                    log.exceptionHandlingCommand(cmd, throwable);
                    CommandAwareRpcDispatcher.this.reply(response, new ExceptionResponse((Exception)((Object)new CacheException("Problems invoking command.", throwable))));
                }
            }
        });
    }

    private void executeCommandFromLocalCluster(final ReplicableCommand cmd, final Message req, final org.jgroups.blocks.Response response, boolean preserveOrder) throws Throwable {
        if (cmd instanceof CacheRpcCommand) {
            if (trace) {
                log.tracef("Attempting to execute command: %s [sender=%s]", cmd, req.getSrc());
            }
            this.inboundInvocationHandler.handle((CacheRpcCommand)cmd, JGroupsTransport.fromJGroupsAddress(req.getSrc()), response, preserveOrder);
        } else if (!this.isTotalOrderStateTransferCommand(cmd) && !preserveOrder && cmd.canBlock()) {
            this.remoteCommandsExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (trace) {
                            log.tracef("Attempting to execute non-CacheRpcCommand command: %s [sender=%s]", cmd, req.getSrc());
                        }
                        CommandAwareRpcDispatcher.this.gcr.wireDependencies(cmd);
                        Object retVal = cmd.perform(null);
                        if (retVal != null && !(retVal instanceof Response)) {
                            retVal = SuccessfulResponse.create(retVal);
                        }
                        CommandAwareRpcDispatcher.this.reply(response, retVal);
                    }
                    catch (InterruptedException e) {
                        log.shutdownHandlingCommand(cmd);
                        CommandAwareRpcDispatcher.this.reply(response, new ExceptionResponse((Exception)((Object)new CacheException("Cache is shutting down"))));
                    }
                    catch (Throwable throwable) {
                        log.exceptionHandlingCommand(cmd, throwable);
                        CommandAwareRpcDispatcher.this.reply(response, new ExceptionResponse((Exception)((Object)new CacheException("Problems invoking command.", throwable))));
                    }
                }
            });
        } else {
            if (trace) {
                log.tracef("Attempting to execute non-CacheRpcCommand command: %s [sender=%s]", cmd, req.getSrc());
            }
            this.gcr.wireDependencies(cmd);
            Object retVal = cmd.perform(null);
            if (retVal != null && !(retVal instanceof Response)) {
                retVal = SuccessfulResponse.create(retVal);
            }
            this.reply(response, retVal);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[Outgoing marshaller: " + this.req_marshaller + "; incoming marshaller: " + this.rsp_marshaller + "]";
    }

    private void reply(org.jgroups.blocks.Response response, Object retVal) {
        if (response != null) {
            response.send(retVal, false);
        }
    }

    private boolean isTotalOrderStateTransferCommand(ReplicableCommand command) throws InterruptedException {
        boolean isTotalOrder = false;
        if (command instanceof CacheTopologyControlCommand) {
            CacheTopologyControlCommand controlCommand = (CacheTopologyControlCommand)command;
            switch (controlCommand.getType()) {
                case REBALANCE_START: 
                case CH_UPDATE: {
                    LocalTopologyManager topologyManager = this.gcr.getComponent(LocalTopologyManager.class);
                    isTotalOrder = topologyManager != null && topologyManager.isTotalOrderCache(controlCommand.getCacheName());
                }
            }
        }
        return isTotalOrder;
    }

    protected static Message constructMessage(Buffer buf, Address recipient, boolean oob, ResponseMode mode, boolean rsvp, boolean totalOrder) {
        Message msg = new Message();
        msg.setBuffer(buf);
        if (oob) {
            msg.setFlag(new Message.Flag[]{Message.Flag.OOB});
        }
        if (oob || mode != ResponseMode.GET_NONE) {
            msg.setFlag(new Message.Flag[]{Message.Flag.DONT_BUNDLE});
        }
        if (rsvp) {
            msg.setFlag(new Message.Flag[]{Message.Flag.RSVP});
        }
        if (!totalOrder) {
            msg.setFlag(new Message.Flag[]{Message.Flag.NO_TOTAL_ORDER});
        } else {
            msg.clearFlag(new Message.Flag[]{Message.Flag.OOB});
        }
        if (recipient != null) {
            msg.setDest(recipient);
        }
        return msg;
    }

    static Buffer marshallCall(RpcDispatcher.Marshaller marshaller, ReplicableCommand command) {
        Buffer buf;
        try {
            buf = marshaller.objectToBuffer((Object)command);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to marshal argument(s)", e);
        }
        return buf;
    }

    private static Response processSingleCall(ReplicableCommand command, long timeout, Address destination, ResponseMode mode, RpcDispatcher.Marshaller marshaller, CommandAwareRpcDispatcher card, boolean oob, JGroupsTransport transport) throws Exception {
        if (trace) {
            log.tracef("Replication task sending %s to single recipient %s with response mode %s", command, destination, mode);
        }
        boolean rsvp = CommandAwareRpcDispatcher.isRsvpCommand(command);
        Buffer buf = CommandAwareRpcDispatcher.marshallCall(marshaller, command);
        Response retval = (Response)card.sendMessage(CommandAwareRpcDispatcher.constructMessage(buf, destination, oob, mode, rsvp, false), new RequestOptions(mode, timeout));
        if (trace) {
            log.tracef("Response: %s", retval);
        }
        if (mode == ResponseMode.GET_NONE) {
            return null;
        }
        if (retval != null && !transport.checkResponse(retval, JGroupsTransport.fromJGroupsAddress(destination))) {
            if (trace) {
                log.tracef("Invalid response from %s", destination);
            }
            throw new org.infinispan.util.concurrent.TimeoutException("Received an invalid response " + retval + " from " + destination);
        }
        return retval;
    }

    private static RspList<Object> processCalls(ReplicableCommand command, boolean broadcast, long timeout, RspFilter filter, List<Address> dests, ResponseMode mode, RpcDispatcher.Marshaller marshaller, CommandAwareRpcDispatcher card, boolean oob, boolean ignoreLeavers, boolean totalOrder) throws Exception {
        if (trace) {
            log.tracef("Replication task sending %s to addresses %s with response mode %s", command, dests, mode);
        }
        boolean rsvp = CommandAwareRpcDispatcher.isRsvpCommand(command);
        RspList<Object> retval = null;
        if (totalOrder) {
            Buffer buf = CommandAwareRpcDispatcher.marshallCall(marshaller, command);
            Message message = CommandAwareRpcDispatcher.constructMessage(buf, null, oob, mode, rsvp, true);
            AnycastAddress address = new AnycastAddress(dests);
            message.setDest((Address)address);
            retval = card.castMessage(dests, message, new RequestOptions(mode, timeout, false, filter));
        } else if (broadcast || FORCE_MCAST) {
            Buffer buf = CommandAwareRpcDispatcher.marshallCall(marshaller, command);
            RequestOptions opts = new RequestOptions(mode, timeout, false, filter);
            opts.setExclusionList(new Address[]{card.getChannel().getAddress()});
            retval = card.castMessage(dests, CommandAwareRpcDispatcher.constructMessage(buf, null, oob, mode, rsvp, false), opts);
        } else {
            RequestOptions opts = new RequestOptions(mode, timeout);
            opts.setExclusionList(new Address[]{card.getChannel().getAddress()});
            if (dests.isEmpty()) {
                return new RspList();
            }
            Buffer buf = CommandAwareRpcDispatcher.marshallCall(marshaller, command);
            if (filter != null) {
                FutureCollator futureCollator = new FutureCollator(filter, dests.size(), timeout, card.gcr.getTimeService());
                for (Address address : dests) {
                    NotifyingFuture f = card.sendMessageWithFuture(CommandAwareRpcDispatcher.constructMessage(buf, address, oob, mode, rsvp, false), opts);
                    futureCollator.watchFuture((NotifyingFuture<Object>)f, address);
                }
                retval = futureCollator.getResponseList();
            } else if (mode == ResponseMode.GET_ALL) {
                HashMap<Address, NotifyingFuture> futures = new HashMap<Address, NotifyingFuture>(dests.size());
                for (Address address : dests) {
                    futures.put(address, card.sendMessageWithFuture(CommandAwareRpcDispatcher.constructMessage(buf, address, oob, mode, rsvp, false), opts));
                }
                retval = new RspList();
                for (Map.Entry entry : futures.entrySet()) {
                    Address target = (Address)entry.getKey();
                    try {
                        retval.addRsp(target, ((Future)entry.getValue()).get(timeout, TimeUnit.MILLISECONDS));
                    }
                    catch (TimeoutException te) {
                        throw new org.infinispan.util.concurrent.TimeoutException(Util.formatString((Object)"Timed out after %s waiting for a response from %s", (Object[])new Object[]{Util.prettyPrintTime((long)timeout), target}));
                    }
                    catch (ExecutionException e) {
                        if (ignoreLeavers && e.getCause() instanceof SuspectedException) {
                            log.tracef(Util.formatString((Object)"Ignoring node %s that left during the remote call", (Object[])new Object[]{target}), new Object[0]);
                            continue;
                        }
                        throw CommandAwareRpcDispatcher.wrapThrowableInException(e.getCause());
                    }
                }
            } else if (mode == ResponseMode.GET_NONE) {
                for (Address dest : dests) {
                    card.sendMessage(CommandAwareRpcDispatcher.constructMessage(buf, dest, oob, mode, rsvp, false), opts);
                }
            }
        }
        if (mode != ResponseMode.GET_NONE) {
            if (trace) {
                log.tracef("Responses: %s", retval);
            }
            if (retval == null) {
                throw new NotSerializableException("RpcDispatcher returned a null.  This is most often caused by args for " + command.getClass().getSimpleName() + " not being serializable.");
            }
        }
        return retval;
    }

    private static Exception wrapThrowableInException(Throwable t) {
        if (t instanceof Exception) {
            return (Exception)t;
        }
        return new CacheException(t);
    }

    private static boolean isRsvpCommand(ReplicableCommand command) {
        return command instanceof FlagAffectedCommand && ((FlagAffectedCommand)command).hasFlag(Flag.GUARANTEED_DELIVERY);
    }

    static final class FutureCollator
    implements FutureListener<Object> {
        final RspFilter filter;
        final Map<Future<Object>, SenderContainer> futures = new HashMap<Future<Object>, SenderContainer>(4);
        final long timeout;
        @GuardedBy(value="this")
        private RspList<Object> retval;
        @GuardedBy(value="this")
        private Exception exception;
        @GuardedBy(value="this")
        private int expectedResponses;
        private final TimeService timeService;

        FutureCollator(RspFilter filter, int expectedResponses, long timeout, TimeService timeService) {
            this.filter = filter;
            this.expectedResponses = expectedResponses;
            this.timeout = timeout;
            this.timeService = timeService;
        }

        public void watchFuture(NotifyingFuture<Object> f, Address address) {
            this.futures.put((Future<Object>)f, new SenderContainer(address));
            f.setListener((FutureListener)this);
        }

        public synchronized RspList<Object> getResponseList() throws Exception {
            long waitingTime;
            long expectedEndTime = this.timeService.expectedEndTime(this.timeout, TimeUnit.MILLISECONDS);
            while (this.expectedResponses > 0 && this.retval == null && (waitingTime = this.timeService.remainingTime(expectedEndTime, TimeUnit.MILLISECONDS)) > 0L) {
                try {
                    this.wait(waitingTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.expectedResponses = -1;
                }
            }
            if (this.retval != null) {
                return this.retval;
            }
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.expectedResponses == 0) {
                throw new RpcException(String.format("No more valid responses.  Received invalid responses from all of %s", this.futures.values()));
            }
            throw new org.infinispan.util.concurrent.TimeoutException(String.format("Timed out waiting for %s for valid responses from any of %s.", Util.prettyPrintTime((long)this.timeout), this.futures.values()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void futureDone(Future<Object> objectFuture) {
            SenderContainer sc = this.futures.get(objectFuture);
            if (sc.processed) {
                if (trace) {
                    log.tracef("Not processing callback; already processed callback for sender %s", sc.address);
                }
            } else {
                sc.processed = true;
                Address sender = sc.address;
                boolean done = false;
                try {
                    if (this.retval == null) {
                        Object response = objectFuture.get();
                        if (trace) {
                            log.tracef("Received response: %s from %s", response, sender);
                        }
                        this.filter.isAcceptable(response, sender);
                        if (!this.filter.needMoreResponses()) {
                            this.retval = new RspList(Collections.singleton(new Rsp(sender, response)));
                            done = true;
                        }
                    } else if (trace) {
                        log.tracef("Skipping response from %s since a valid response for this request has already been received", sender);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    this.exception = e;
                    this.exception = e.getCause() instanceof org.jgroups.TimeoutException ? new org.infinispan.util.concurrent.TimeoutException("Timeout!", e) : (e.getCause() instanceof Exception ? (Exception)e.getCause() : new CacheException("Caught a throwable", e.getCause()));
                    if (log.isDebugEnabled()) {
                        log.debugf("Caught exception %s from sender %s.  Will skip this response.", this.exception.getClass().getName(), sender);
                    }
                    log.trace("Exception caught: ", this.exception);
                }
                finally {
                    --this.expectedResponses;
                    if (this.expectedResponses == 0 || done) {
                        this.notify();
                    }
                }
            }
        }
    }

    static class SenderContainer {
        final Address address;
        volatile boolean processed = false;

        SenderContainer(Address address) {
            this.address = address;
        }

        public String toString() {
            return "Sender{address=" + this.address + ", responded=" + this.processed + '}';
        }
    }
}

