/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.LazyRemovalCache;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.TpHeader;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AsciiString;
import org.jgroups.util.Average;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.DefaultTimeScheduler;
import org.jgroups.util.DirectExecutor;
import org.jgroups.util.ExpiryCache;
import org.jgroups.util.HashedTimingWheel;
import org.jgroups.util.LazyThreadFactory;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Responses;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.SingletonAddress;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.SuppressLog;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.TimeScheduler2;
import org.jgroups.util.TimeScheduler3;
import org.jgroups.util.TimeService;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="Transport protocol")
public abstract class TP
extends Protocol
implements DiagnosticsHandler.ProbeHandler {
    protected static final byte LIST = 1;
    protected static final byte MULTICAST = 2;
    protected static final int MSG_OFFSET = 4;
    protected static final int MSG_OVERHEAD = 3;
    protected static final boolean can_bind_to_mcast_addr;
    protected static final String BUNDLE_MSG = "%s: sending %d msgs (%d bytes (%.2f of max_bundle_size) to %d dests(s): %s";
    protected static final long MIN_WAIT_BETWEEN_DISCOVERIES;
    protected static NumberFormat f;
    @LocalAddress
    @Property(name="bind_addr", description="The bind address which should be used by this transport. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL, NON_LOOPBACK, match-interface, match-host, match-address", defaultValueIPv4="NON_LOOPBACK_ADDRESS", defaultValueIPv6="NON_LOOPBACK_ADDRESS", systemProperty={"jgroups.bind_addr"}, writable=false)
    protected InetAddress bind_addr = null;
    @Property(description="Use \"external_addr\" if you have hosts on different networks, behind firewalls. On each firewall, set up a port forwarding rule (sometimes called \"virtual server\") to the local IP (e.g. 192.168.1.100) of the host then on each host, set \"external_addr\" TCP transport parameter to the external (public IP) address of the firewall.", systemProperty={"jgroups.external_addr"}, writable=false)
    protected InetAddress external_addr = null;
    @Property(description="Used to map the internal port (bind_port) to an external port. Only used if > 0", systemProperty={"jgroups.external_port"}, writable=false)
    protected int external_port = 0;
    @Property(name="bind_interface", converter=PropertyConverters.BindInterface.class, description="The interface (NIC) which should be used by this transport", dependsUpon="bind_addr", exposeAsManagedAttribute=false)
    protected String bind_interface_str = null;
    @Property(description="If true, the transport should use all available interfaces to receive multicast messages")
    protected boolean receive_on_all_interfaces = false;
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="Comma delimited list of interfaces (IP addresses or interface names) to receive multicasts on")
    protected List<NetworkInterface> receive_interfaces = null;
    @Property(description="Max number of elements in the logical address cache before eviction starts")
    protected int logical_addr_cache_max_size = 2000;
    @Property(description="Time (in ms) after which entries in the logical address cache marked as removable can be removed. 0 never removes any entries (not recommended)")
    protected long logical_addr_cache_expiration = 120000L;
    @Property(description="Interval (in ms) at which the reaper task scans logical_addr_cache and removes entries marked as removable. 0 disables reaping.")
    protected long logical_addr_cache_reaper_interval = 60000L;
    @Property(description="The port to which the transport binds. Default of 0 binds to any (ephemeral) port", writable=false)
    protected int bind_port = 0;
    @Property(description="The range of valid ports, from bind_port to end_port. 0 only binds to bind_port and fails if taken")
    protected int port_range = 50;
    @Property(description="Messages to self are looped back immediately if true", deprecatedMessage="enabled by default")
    @Deprecated
    protected boolean loopback = true;
    @Property(description="Whether or not to make a copy of a message before looping it back up. Don't use this; might get removed without warning")
    protected boolean loopback_copy = false;
    @Property(description="Loop back the message on a separate thread or use the current thread. Don't use this; might get removed without warning")
    protected boolean loopback_separate_thread = true;
    @Deprecated
    @Property(description="Discard packets with a different version if true", deprecatedMessage="incompatible packets are discarded anyway", writable=false)
    protected boolean discard_incompatible_packets = true;
    @Property(description="Thread naming pattern for threads in this channel. Valid values are \"pcl\": \"p\": includes the thread name, e.g. \"Incoming thread-1\", \"UDP ucast receiver\", \"c\": includes the cluster name, e.g. \"MyCluster\", \"l\": includes the local address of the current member, e.g. \"192.168.5.1:5678\"")
    protected String thread_naming_pattern = "cl";
    @Property(name="oob_thread_pool.enabled", description="Switch for enabling thread pool for OOB messages. Default=true", writable=false)
    protected boolean oob_thread_pool_enabled = true;
    @Property(name="oob_thread_pool.min_threads", description="Minimum thread pool size for the OOB thread pool")
    protected int oob_thread_pool_min_threads = 2;
    @Property(name="oob_thread_pool.max_threads", description="Max thread pool size for the OOB thread pool")
    protected int oob_thread_pool_max_threads = 10;
    @Property(name="oob_thread_pool.keep_alive_time", description="Timeout in ms to remove idle threads from the OOB pool")
    protected long oob_thread_pool_keep_alive_time = 30000L;
    @Property(name="oob_thread_pool.queue_enabled", description="Use queue to enqueue incoming OOB messages")
    protected boolean oob_thread_pool_queue_enabled = false;
    @Property(name="oob_thread_pool.queue_max_size", description="Maximum queue size for incoming OOB messages")
    protected int oob_thread_pool_queue_max_size = 500;
    @Property(name="oob_thread_pool.rejection_policy", description="Thread rejection policy. Possible values are Abort, Discard, DiscardOldest and Run")
    protected String oob_thread_pool_rejection_policy = "discard";
    @Property(name="thread_pool.min_threads", description="Minimum thread pool size for the regular thread pool")
    protected int thread_pool_min_threads = 2;
    @Property(name="thread_pool.max_threads", description="Maximum thread pool size for the regular thread pool")
    protected int thread_pool_max_threads = 10;
    @Property(name="thread_pool.keep_alive_time", description="Timeout in milliseconds to remove idle thread from regular pool")
    protected long thread_pool_keep_alive_time = 30000L;
    @Property(name="thread_pool.enabled", description="Switch for enabling thread pool for regular messages")
    protected boolean thread_pool_enabled = true;
    @Property(name="thread_pool.queue_enabled", description="Queue to enqueue incoming regular messages")
    protected boolean thread_pool_queue_enabled = true;
    @Property(name="thread_pool.queue_max_size", description="Maximum queue size for incoming regular messages")
    protected int thread_pool_queue_max_size = 10000;
    @Property(name="thread_pool.rejection_policy", description="Thread rejection policy. Possible values are Abort, Discard, DiscardOldest and Run")
    protected String thread_pool_rejection_policy = "Discard";
    @Property(name="internal_thread_pool.enabled", description="Switch for enabling thread pool for internal messages", writable=false)
    protected boolean internal_thread_pool_enabled = true;
    @Property(name="internal_thread_pool.min_threads", description="Minimum thread pool size for the internal thread pool")
    protected int internal_thread_pool_min_threads = 2;
    @Property(name="internal_thread_pool.max_threads", description="Maximum thread pool size for the internal thread pool")
    protected int internal_thread_pool_max_threads = 4;
    @Property(name="internal_thread_pool.keep_alive_time", description="Timeout in ms to remove idle threads from the internal pool")
    protected long internal_thread_pool_keep_alive_time = 30000L;
    @Property(name="internal_thread_pool.queue_enabled", description="Queue to enqueue incoming internal messages")
    protected boolean internal_thread_pool_queue_enabled = true;
    @Property(name="internal_thread_pool.queue_max_size", description="Maximum queue size for incoming internal messages")
    protected int internal_thread_pool_queue_max_size = 500;
    @Property(name="internal_thread_pool.rejection_policy", description="Thread rejection policy. Possible values are Abort, Discard, DiscardOldest and Run")
    protected String internal_thread_pool_rejection_policy = "discard";
    @Property(description="Type of timer to be used. Valid values are \"old\" (DefaultTimeScheduler, used up to 2.10), \"new\" or \"new2\" (TimeScheduler2), \"new3\" (TimeScheduler3) and \"wheel\". Note that this property might disappear in future releases, if one of the 3 timers is chosen as default timer")
    protected String timer_type = "new3";
    @Property(name="timer.min_threads", description="Minimum thread pool size for the timer thread pool")
    protected int timer_min_threads = 2;
    @Property(name="timer.max_threads", description="Max thread pool size for the timer thread pool")
    protected int timer_max_threads = 4;
    @Property(name="timer.keep_alive_time", description="Timeout in ms to remove idle threads from the timer pool")
    protected long timer_keep_alive_time = 5000L;
    @Property(name="timer.queue_max_size", description="Max number of elements on a timer queue")
    protected int timer_queue_max_size = 500;
    @Property(name="timer.rejection_policy", description="Timer rejection policy. Possible values are Abort, Discard, DiscardOldest and Run")
    protected String timer_rejection_policy = "abort";
    @Property(name="timer.wheel_size", description="Number of ticks in the HashedTimingWheel timer. Only applicable if timer_type is \"wheel\"")
    protected int wheel_size = 200;
    @Property(name="timer.tick_time", description="Tick duration in the HashedTimingWheel timer. Only applicable if timer_type is \"wheel\"")
    protected long tick_time = 50L;
    @Property(description="Interval (in ms) at which the time service updates its timestamp. 0 disables the time service")
    protected long time_service_interval = 500L;
    @Property(description="Enable bundling of smaller messages into bigger ones. Default is true", deprecatedMessage="will be ignored as bundling is on by default")
    @Deprecated
    protected boolean enable_bundling = true;
    @Property(description="Enable bundling of smaller messages into bigger ones for unicast messages. Default is true", deprecatedMessage="will be ignored")
    @Deprecated
    protected boolean enable_unicast_bundling = true;
    @Property(description="Allows the transport to pass received message batches up as MessagesBatch instances (up(MessageBatch)), rather than individual messages. This flag will be removed in a future version when batching has been implemented by all protocols")
    protected boolean enable_batching = true;
    @Property(description="Whether or not messages with DONT_BUNDLE set should be ignored by default (JGRP-1737). This property will be removed in a future release, so don't use it")
    protected boolean ignore_dont_bundle = true;
    @Property(description="Switch to enable diagnostic probing. Default is true")
    protected boolean enable_diagnostics = true;
    @Property(description="Address for diagnostic probing. Default is 224.0.75.75", defaultValueIPv4="224.0.75.75", defaultValueIPv6="ff0e::0:75:75")
    protected InetAddress diagnostics_addr = null;
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="Comma delimited list of interfaces (IP addresses or interface names) that the diagnostics multicast socket should bind to")
    protected List<NetworkInterface> diagnostics_bind_interfaces = null;
    @Property(description="Port for diagnostic probing. Default is 7500")
    protected int diagnostics_port = 7500;
    @Property(description="TTL of the diagnostics multicast socket")
    protected int diagnostics_ttl = 8;
    @Property(description="Authorization passcode for diagnostics. If specified every probe query will be authorized")
    protected String diagnostics_passcode;
    @Property(description="If assigned enable this transport to be a singleton (shared) transport")
    protected String singleton_name = null;
    @Property(description="whether or not warnings about messages from different groups are logged")
    protected boolean log_discard_msgs = true;
    @Property(description="whether or not warnings about messages from members with a different version are discarded")
    protected boolean log_discard_msgs_version = true;
    @Property(description="Timeout (in ms) to determine how long to wait until a request to fetch the physical address for a given logical address will be sent again. Subsequent requests for the same physical address will therefore be spaced at least who_has_cache_timeout ms apart")
    protected long who_has_cache_timeout = 2000L;
    @Property(description="Max number of attempts to fetch a physical address (when not in the cache) before giving up", deprecatedMessage="will be ignored")
    protected int physical_addr_max_fetch_attempts = 1;
    @Property(description="Time during which identical warnings about messages from a member with a different version will be suppressed. 0 disables this (every warning will be logged). Setting the log level to ERROR also disables this.")
    protected long suppress_time_different_version_warnings = 60000L;
    @Property(description="Time during which identical warnings about messages from a member from a different cluster will be suppressed. 0 disables this (every warning will be logged). Setting the log level to ERROR also disables this.")
    protected long suppress_time_different_cluster_warnings = 60000L;
    @Property(name="max_bundle_size", description="Maximum number of bytes for messages to be queued until they are sent")
    protected int max_bundle_size = 64000;
    @Property(name="max_bundle_timeout", description="Max number of milliseconds until queued messages are sent")
    protected long max_bundle_timeout = 20L;
    @Property(description="The type of bundler used. Has to be \"sender-sends-with-timer\", \"transfer-queue\" (default) or \"sender-sends\"")
    protected String bundler_type = "transfer-queue";
    @Property(description="The max number of elements in a bundler if the bundler supports size limitations")
    protected int bundler_capacity = 20000;
    @ManagedAttribute(description="Number of messages sent")
    protected long num_msgs_sent = 0L;
    @ManagedAttribute(description="Number of messages received")
    protected long num_msgs_received = 0L;
    @ManagedAttribute(description="Number of single messages received")
    protected long num_single_msgs_received = 0L;
    @ManagedAttribute(description="Number of single messages sent")
    protected long num_single_msgs_sent = 0L;
    @ManagedAttribute(description="Number of message batches received")
    protected long num_batches_received = 0L;
    @ManagedAttribute(description="Number of message batches sent")
    protected long num_batches_sent = 0L;
    @ManagedAttribute(description="Number of bytes sent")
    protected long num_bytes_sent = 0L;
    @ManagedAttribute(description="Number of bytes received")
    protected long num_bytes_received = 0L;
    @ManagedAttribute(description="Number of messages rejected by the thread pool")
    protected int num_rejected_msgs = 0;
    @ManagedAttribute(description="Channel (cluster) name")
    protected AsciiString cluster_name;
    @ManagedAttribute(description="Number of OOB messages received")
    protected long num_oob_msgs_received;
    @ManagedAttribute(description="Number of regular messages received")
    protected long num_incoming_msgs_received;
    @ManagedAttribute(description="Number of internal messages received")
    protected long num_internal_msgs_received;
    protected Address local_addr;
    protected PhysicalAddress local_physical_addr;
    protected final Set<Address> members = new CopyOnWriteArraySet<Address>();
    protected int connect_count = 0;
    protected final ReentrantLock connectLock = new ReentrantLock();
    protected Executor oob_thread_pool;
    protected ThreadFactory oob_thread_factory;
    protected BlockingQueue<Runnable> oob_thread_pool_queue;
    protected Executor thread_pool;
    protected ThreadFactory default_thread_factory;
    protected BlockingQueue<Runnable> thread_pool_queue;
    protected Executor internal_thread_pool;
    protected ThreadFactory internal_thread_factory;
    protected BlockingQueue<Runnable> internal_thread_pool_queue;
    protected TimeScheduler timer;
    protected ThreadFactory timer_thread_factory;
    protected TimeService time_service;
    protected ThreadFactory global_thread_factory = null;
    protected SocketFactory socket_factory = new DefaultSocketFactory();
    protected Bundler bundler;
    protected DiagnosticsHandler diag_handler;
    protected final List<DiagnosticsHandler.ProbeHandler> preregistered_probe_handlers = new LinkedList<DiagnosticsHandler.ProbeHandler>();
    protected final ConcurrentMap<AsciiString, Protocol> up_prots = Util.createConcurrentMap(16, 0.75f, 16);
    protected TpHeader header;
    protected LazyRemovalCache<Address, PhysicalAddress> logical_addr_cache;
    protected long last_discovery_request = 0L;
    Future<?> logical_addr_cache_reaper;
    protected final Average avg_batch_size = new Average(20);
    protected static final LazyRemovalCache.Printable<Address, LazyRemovalCache.Entry<PhysicalAddress>> print_function;
    protected ExpiryCache<Address> who_has_cache;
    protected SuppressLog<Address> suppress_log_different_version;
    protected SuppressLog<Address> suppress_log_different_cluster;

    public void setMaxBundleSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("max_bundle_size (" + size + ") is <= 0");
        }
        this.max_bundle_size = size;
    }

    public long getMaxBundleTimeout() {
        return this.max_bundle_timeout;
    }

    public void setMaxBundleTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("max_bundle_timeout of " + timeout + " is invalid");
        }
        this.max_bundle_timeout = timeout;
    }

    public int getMaxBundleSize() {
        return this.max_bundle_size;
    }

    @ManagedAttribute
    public int getBundlerBufferSize() {
        if (this.bundler instanceof TransferQueueBundler) {
            return ((TransferQueueBundler)this.bundler).getBufferSize();
        }
        return 0;
    }

    @ManagedAttribute(description="Is the logical_addr_cache reaper task running")
    public boolean isLogicalAddressCacheReaperRunning() {
        return this.logical_addr_cache_reaper != null && !this.logical_addr_cache_reaper.isDone();
    }

    @ManagedAttribute(description="Returns the average batch size of received batches")
    public double getAvgBatchSize() {
        return this.avg_batch_size.getAverage();
    }

    public void setOOBThreadPoolKeepAliveTime(long time) {
        this.oob_thread_pool_keep_alive_time = time;
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setKeepAliveTime(time, TimeUnit.MILLISECONDS);
        }
    }

    public long getOOBThreadPoolKeepAliveTime() {
        return this.oob_thread_pool_keep_alive_time;
    }

    public void setOOBThreadPoolMinThreads(int size) {
        this.oob_thread_pool_min_threads = size;
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setCorePoolSize(size);
        }
    }

    public int getOOBThreadPoolMinThreads() {
        return this.oob_thread_pool_min_threads;
    }

    public void setOOBThreadPoolMaxThreads(int size) {
        this.oob_thread_pool_max_threads = size;
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setMaximumPoolSize(size);
        }
    }

    public int getOOBThreadPoolMaxThreads() {
        return this.oob_thread_pool_max_threads;
    }

    public void setOOBThreadPoolQueueEnabled(boolean flag) {
        this.oob_thread_pool_queue_enabled = flag;
    }

    public void setThreadPoolMinThreads(int size) {
        this.thread_pool_min_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setCorePoolSize(size);
        }
    }

    public int getThreadPoolMinThreads() {
        return this.thread_pool_min_threads;
    }

    public void setThreadPoolMaxThreads(int size) {
        this.thread_pool_max_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setMaximumPoolSize(size);
        }
    }

    public int getThreadPoolMaxThreads() {
        return this.thread_pool_max_threads;
    }

    public void setThreadPoolKeepAliveTime(long time) {
        this.thread_pool_keep_alive_time = time;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setKeepAliveTime(time, TimeUnit.MILLISECONDS);
        }
    }

    public long getThreadPoolKeepAliveTime() {
        return this.thread_pool_keep_alive_time;
    }

    public void setTimerMinThreads(int size) {
        this.timer_min_threads = size;
        if (this.timer != null) {
            this.timer.setMinThreads(size);
        }
    }

    public int getTimerMinThreads() {
        return this.timer_min_threads;
    }

    public void setTimerMaxThreads(int size) {
        this.timer_max_threads = size;
        if (this.timer != null) {
            this.timer.setMaxThreads(size);
        }
    }

    public int getTimerMaxThreads() {
        return this.timer_max_threads;
    }

    public void setTimerKeepAliveTime(long time) {
        this.timer_keep_alive_time = time;
        if (this.timer != null) {
            this.timer.setKeepAliveTime(time);
        }
    }

    public long getTimerKeepAliveTime() {
        return this.timer_keep_alive_time;
    }

    @ManagedAttribute
    public int getTimerQueueSize() {
        if (this.timer instanceof TimeScheduler2) {
            return ((TimeScheduler2)this.timer).getQueueSize();
        }
        return 0;
    }

    @ManagedAttribute(description="Class of the timer implementation")
    public String getTimerClass() {
        return this.timer != null ? this.timer.getClass().getSimpleName() : "null";
    }

    @ManagedAttribute(description="Name of the cluster to which this transport is connected")
    public String getClusterName() {
        return this.cluster_name != null ? this.cluster_name.toString() : null;
    }

    @ManagedAttribute(description="Number of messages from members in a different cluster")
    public int getDifferentClusterMessages() {
        return this.suppress_log_different_cluster != null ? this.suppress_log_different_cluster.getCache().size() : 0;
    }

    @ManagedAttribute(description="Number of messages from members with a different JGroups version")
    public int getDifferentVersionMessages() {
        return this.suppress_log_different_version != null ? this.suppress_log_different_version.getCache().size() : 0;
    }

    @ManagedOperation(description="Clears the cache for messages from different clusters")
    public void clearDifferentClusterCache() {
        if (this.suppress_log_different_cluster != null) {
            this.suppress_log_different_cluster.getCache().clear();
        }
    }

    @ManagedOperation(description="Clears the cache for messages from members with different versions")
    public void clearDifferentVersionCache() {
        if (this.suppress_log_different_version != null) {
            this.suppress_log_different_version.getCache().clear();
        }
    }

    @ManagedAttribute(description="Type of logger used")
    public static String loggerType() {
        return LogFactory.loggerType();
    }

    protected TP() {
    }

    public abstract boolean supportsMulticasting();

    public boolean isMulticastCapable() {
        return this.supportsMulticasting();
    }

    public String toString() {
        if (!this.isSingleton()) {
            return this.local_addr != null ? this.name + "(local address: " + this.local_addr + ')' : this.name;
        }
        return this.name + " (singleton=" + this.singleton_name + ")";
    }

    @ManagedAttribute(description="The address of the channel")
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : null;
    }

    @ManagedAttribute(description="The physical address of the channel")
    public String getLocalPhysicalAddress() {
        return this.local_physical_addr != null ? this.local_physical_addr.toString() : null;
    }

    @Override
    public void resetStats() {
        this.num_bytes_received = 0L;
        this.num_bytes_sent = 0L;
        this.num_batches_received = 0L;
        this.num_single_msgs_received = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
        this.num_batches_sent = 0L;
        this.num_single_msgs_sent = 0L;
        this.num_internal_msgs_received = 0L;
        this.num_incoming_msgs_received = 0L;
        this.num_oob_msgs_received = 0L;
        this.avg_batch_size.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProbeHandler(DiagnosticsHandler.ProbeHandler handler) {
        if (this.diag_handler != null) {
            this.diag_handler.registerProbeHandler(handler);
        } else {
            List<DiagnosticsHandler.ProbeHandler> list = this.preregistered_probe_handlers;
            synchronized (list) {
                this.preregistered_probe_handlers.add(handler);
            }
        }
    }

    public void unregisterProbeHandler(DiagnosticsHandler.ProbeHandler handler) {
        if (this.diag_handler != null) {
            this.diag_handler.unregisterProbeHandler(handler);
        }
    }

    public void setDiagnosticsHandler(DiagnosticsHandler handler) {
        if (handler != null) {
            if (this.diag_handler != null) {
                this.diag_handler.stop();
            }
            this.diag_handler = handler;
        }
    }

    public void setBundler(Bundler bundler) {
        this.bundler = bundler;
    }

    public void setThreadPoolQueueEnabled(boolean flag) {
        this.thread_pool_queue_enabled = flag;
    }

    public Executor getDefaultThreadPool() {
        return this.thread_pool;
    }

    public void setDefaultThreadPool(Executor thread_pool) {
        if (this.thread_pool != null) {
            TP.shutdownThreadPool(this.thread_pool);
        }
        this.thread_pool = thread_pool;
    }

    public ThreadFactory getDefaultThreadPoolThreadFactory() {
        return this.default_thread_factory;
    }

    public void setDefaultThreadPoolThreadFactory(ThreadFactory factory) {
        this.default_thread_factory = factory;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setThreadFactory(factory);
        }
    }

    public Executor getOOBThreadPool() {
        return this.oob_thread_pool;
    }

    public void setOOBThreadPool(Executor oob_thread_pool) {
        if (this.oob_thread_pool != null) {
            TP.shutdownThreadPool(this.oob_thread_pool);
        }
        this.oob_thread_pool = oob_thread_pool;
    }

    public ThreadFactory getOOBThreadPoolThreadFactory() {
        return this.oob_thread_factory;
    }

    public void setOOBThreadPoolThreadFactory(ThreadFactory factory) {
        this.oob_thread_factory = factory;
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setThreadFactory(factory);
        }
    }

    public Executor getInternalThreadPool() {
        return this.internal_thread_pool;
    }

    public void setInternalThreadPool(Executor internal_thread_pool) {
        if (this.internal_thread_pool != null) {
            TP.shutdownThreadPool(this.internal_thread_pool);
        }
        this.internal_thread_pool = internal_thread_pool;
    }

    public ThreadFactory getInternalThreadPoolThreadFactory() {
        return this.internal_thread_factory;
    }

    public void setInternalThreadPoolThreadFactory(ThreadFactory factory) {
        this.internal_thread_factory = factory;
        if (this.internal_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.internal_thread_pool).setThreadFactory(factory);
        }
    }

    public ThreadFactory getTimerThreadFactory() {
        return this.timer_thread_factory;
    }

    public void setTimerThreadFactory(ThreadFactory factory) {
        this.timer_thread_factory = factory;
        this.timer.setThreadFactory(factory);
    }

    public TimeScheduler getTimer() {
        return this.timer;
    }

    public void setTimer(TimeScheduler timer) {
        this.timer = timer;
    }

    public TimeService getTimeService() {
        return this.time_service;
    }

    public void setTimeService(TimeService ts) {
        if (ts == null) {
            return;
        }
        if (this.time_service != null) {
            this.time_service.stop();
        }
        this.time_service = ts;
        this.time_service.start();
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.global_thread_factory;
    }

    public void setThreadFactory(ThreadFactory factory) {
        this.global_thread_factory = factory;
    }

    @Override
    public SocketFactory getSocketFactory() {
        return this.socket_factory;
    }

    @Override
    public void setSocketFactory(SocketFactory factory) {
        if (factory != null) {
            this.socket_factory = factory;
        }
    }

    public String getThreadNamingPattern() {
        return this.thread_naming_pattern;
    }

    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    public long getNumBytesSent() {
        return this.num_bytes_sent;
    }

    public long getNumBytesReceived() {
        return this.num_bytes_received;
    }

    public InetAddress getBindAddress() {
        return this.bind_addr;
    }

    public void setBindAddress(InetAddress bind_addr) {
        this.bind_addr = bind_addr;
    }

    public int getBindPort() {
        return this.bind_port;
    }

    public void setBindPort(int port) {
        this.bind_port = port;
    }

    public void setBindToAllInterfaces(boolean flag) {
        this.receive_on_all_interfaces = flag;
    }

    public boolean isReceiveOnAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public List<NetworkInterface> getReceiveInterfaces() {
        return this.receive_interfaces;
    }

    public static boolean isDiscardIncompatiblePackets() {
        return true;
    }

    public static void setDiscardIncompatiblePackets(boolean flag) {
    }

    @Deprecated
    public static boolean isEnableBundling() {
        return true;
    }

    @Deprecated
    public void setEnableBundling(boolean flag) {
    }

    @Deprecated
    public static boolean isEnableUnicastBundling() {
        return true;
    }

    @Deprecated
    public void setEnableUnicastBundling(boolean enable_unicast_bundling) {
    }

    public void setPortRange(int range) {
        this.port_range = range;
    }

    public int getPortRange() {
        return this.port_range;
    }

    public boolean isOOBThreadPoolEnabled() {
        return this.oob_thread_pool_enabled;
    }

    public boolean isDefaulThreadPoolEnabled() {
        return this.thread_pool_enabled;
    }

    @Deprecated
    public boolean isLoopback() {
        return true;
    }

    @Deprecated
    public void setLoopback(boolean b) {
    }

    public ConcurrentMap<AsciiString, Protocol> getUpProtocols() {
        return this.up_prots;
    }

    @ManagedAttribute(description="Current number of threads in the OOB thread pool")
    public int getOOBPoolSize() {
        return this.oob_thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.oob_thread_pool).getPoolSize() : 0;
    }

    @ManagedAttribute(description="Current number of active threads in the OOB thread pool")
    public int getOOBPoolSizeActive() {
        return this.oob_thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.oob_thread_pool).getActiveCount() : 0;
    }

    public long getOOBMessages() {
        return this.num_oob_msgs_received;
    }

    @ManagedAttribute(description="Number of messages in the OOB thread pool's queue")
    public int getOOBQueueSize() {
        return this.oob_thread_pool_queue != null ? this.oob_thread_pool_queue.size() : 0;
    }

    public int getOOBMaxQueueSize() {
        return this.oob_thread_pool_queue_max_size;
    }

    public void setOOBRejectionPolicy(String rejection_policy) {
        RejectedExecutionHandler handler = Util.parseRejectionPolicy(rejection_policy);
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(handler));
        }
    }

    @ManagedAttribute(description="Current number of threads in the default thread pool")
    public int getRegularPoolSize() {
        return this.thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.thread_pool).getPoolSize() : 0;
    }

    @ManagedAttribute(description="Current number of active threads in the default thread pool")
    public int getRegularPoolSizeActive() {
        return this.thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.thread_pool).getActiveCount() : 0;
    }

    public long getRegularMessages() {
        return this.num_incoming_msgs_received;
    }

    @ManagedAttribute(description="Number of messages in the default thread pool's queue")
    public int getRegularQueueSize() {
        return this.thread_pool_queue != null ? this.thread_pool_queue.size() : 0;
    }

    public int getRegularMaxQueueSize() {
        return this.thread_pool_queue_max_size;
    }

    @ManagedAttribute(description="Current number of threads in the internal thread pool")
    public int getInternalPoolSize() {
        return this.internal_thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.internal_thread_pool).getPoolSize() : 0;
    }

    @ManagedAttribute(description="Current number of active threads in the internal thread pool")
    public int getInternalPoolSizeActive() {
        return this.internal_thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.internal_thread_pool).getActiveCount() : 0;
    }

    public long getInternalMessages() {
        return this.num_internal_msgs_received;
    }

    @ManagedAttribute(description="Number of messages in the internal thread pool's queue")
    public int getInternalQueueSize() {
        return this.internal_thread_pool_queue != null ? this.internal_thread_pool_queue.size() : 0;
    }

    public int getInternalMaxQueueSize() {
        return this.internal_thread_pool_queue_max_size;
    }

    @ManagedAttribute(name="timer_tasks", description="Number of timer tasks queued up for execution")
    public int getNumTimerTasks() {
        return this.timer != null ? this.timer.size() : -1;
    }

    @ManagedOperation
    public String dumpTimerTasks() {
        return this.timer.dumpTimerTasks();
    }

    @ManagedAttribute(description="Number of threads currently in the pool")
    public int getTimerThreads() {
        return this.timer.getCurrentThreads();
    }

    @ManagedAttribute(description="Returns the number of live threads in the JVM")
    public static int getNumThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @ManagedAttribute(description="Whether the diagnostics handler is running or not")
    public boolean isDiagnosticsHandlerRunning() {
        return this.diag_handler != null && this.diag_handler.isRunning();
    }

    public void setRegularRejectionPolicy(String rejection_policy) {
        RejectedExecutionHandler handler = Util.parseRejectionPolicy(rejection_policy);
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(handler));
        }
    }

    public void setLogDiscardMessages(boolean flag) {
        this.log_discard_msgs = flag;
    }

    public boolean getLogDiscardMessages() {
        return this.log_discard_msgs;
    }

    public void setLogDiscardMessagesVersion(boolean flag) {
        this.log_discard_msgs_version = flag;
    }

    public boolean getLogDiscardMessagesVersion() {
        return this.log_discard_msgs_version;
    }

    @ManagedOperation(description="Dumps the contents of the logical address cache")
    public String printLogicalAddressCache() {
        return this.logical_addr_cache.size() + " elements:\n" + this.logical_addr_cache.printCache(print_function);
    }

    @ManagedOperation(description="Prints the contents of the who-has cache")
    public String printWhoHasCache() {
        return this.who_has_cache.toString();
    }

    @ManagedOperation(description="Evicts elements in the logical address cache which have expired")
    public void evictLogicalAddressCache() {
        this.evictLogicalAddressCache(false);
    }

    public void evictLogicalAddressCache(boolean force) {
        this.logical_addr_cache.removeMarkedElements(force);
        this.fetchLocalAddresses();
    }

    public abstract void sendMulticast(AsciiString var1, byte[] var2, int var3, int var4) throws Exception;

    public abstract void sendUnicast(PhysicalAddress var1, byte[] var2, int var3, int var4) throws Exception;

    public abstract String getInfo();

    @Override
    public void init() throws Exception {
        super.init();
        if (this.global_thread_factory == null) {
            this.global_thread_factory = new DefaultThreadFactory("", false);
        }
        if (this.timer_thread_factory == null) {
            this.timer_thread_factory = new LazyThreadFactory("Timer", true, true);
        }
        if (this.isSingleton()) {
            this.timer_thread_factory.setIncludeClusterName(false);
        }
        if (this.default_thread_factory == null) {
            this.default_thread_factory = new DefaultThreadFactory("Incoming", false, true);
        }
        if (this.oob_thread_factory == null) {
            this.oob_thread_factory = new DefaultThreadFactory("OOB", false, true);
        }
        if (this.internal_thread_factory == null) {
            this.internal_thread_factory = new DefaultThreadFactory("INT", false, true);
        }
        this.setInAllThreadFactories(this.cluster_name != null ? this.cluster_name.toString() : null, this.local_addr, this.thread_naming_pattern);
        if (this.diag_handler == null) {
            this.diag_handler = new DiagnosticsHandler(this.diagnostics_addr, this.diagnostics_port, this.diagnostics_bind_interfaces, this.diagnostics_ttl, this.log, this.getSocketFactory(), this.getThreadFactory(), this.diagnostics_passcode);
        }
        if (this.timer == null) {
            if (this.timer_type.equalsIgnoreCase("old")) {
                if (this.timer_min_threads < 2) {
                    this.log.warn(Util.getMessage("TimerMinThreads"), this.timer_min_threads);
                    this.timer_min_threads = 2;
                }
                this.timer = new DefaultTimeScheduler(this.timer_thread_factory, this.timer_min_threads);
            } else if (this.timer_type.equalsIgnoreCase("new") || this.timer_type.equalsIgnoreCase("new2")) {
                this.timer = new TimeScheduler2(this.timer_thread_factory, this.timer_min_threads, this.timer_max_threads, this.timer_keep_alive_time, this.timer_queue_max_size, this.timer_rejection_policy);
            } else if (this.timer_type.equalsIgnoreCase("new3")) {
                this.timer = new TimeScheduler3(this.timer_thread_factory, this.timer_min_threads, this.timer_max_threads, this.timer_keep_alive_time, this.timer_queue_max_size, this.timer_rejection_policy);
            } else if (this.timer_type.equalsIgnoreCase("wheel")) {
                this.timer = new HashedTimingWheel(this.timer_thread_factory, this.timer_min_threads, this.timer_max_threads, this.timer_keep_alive_time, this.timer_queue_max_size, this.wheel_size, this.tick_time);
            } else {
                throw new Exception("timer_type has to be either \"old\", \"new\", \"new2\", \"new3\" or \"wheel\"");
            }
        }
        if (this.time_service_interval > 0L) {
            this.time_service = new TimeService(this.timer, this.time_service_interval).start();
        }
        this.who_has_cache = new ExpiryCache(this.who_has_cache_timeout);
        if (this.suppress_time_different_version_warnings > 0L) {
            this.suppress_log_different_version = new SuppressLog(this.log, "VersionMismatch", "SuppressMsg");
        }
        if (this.suppress_time_different_cluster_warnings > 0L) {
            this.suppress_log_different_cluster = new SuppressLog(this.log, "MsgDroppedDiffCluster", "SuppressMsg");
        }
        if (this.oob_thread_pool == null || this.oob_thread_pool instanceof ThreadPoolExecutor && ((ThreadPoolExecutor)this.oob_thread_pool).isShutdown()) {
            if (this.oob_thread_pool_enabled) {
                this.oob_thread_pool_queue = this.oob_thread_pool_queue_enabled ? new LinkedBlockingQueue<Runnable>(this.oob_thread_pool_queue_max_size) : new SynchronousQueue<Runnable>();
                this.oob_thread_pool = TP.createThreadPool(this.oob_thread_pool_min_threads, this.oob_thread_pool_max_threads, this.oob_thread_pool_keep_alive_time, this.oob_thread_pool_rejection_policy, this.oob_thread_pool_queue, this.oob_thread_factory);
            } else {
                this.oob_thread_pool = new DirectExecutor();
            }
        }
        if (this.thread_pool == null || this.thread_pool instanceof ThreadPoolExecutor && ((ThreadPoolExecutor)this.thread_pool).isShutdown()) {
            if (this.thread_pool_enabled) {
                this.thread_pool_queue = this.thread_pool_queue_enabled ? new LinkedBlockingQueue<Runnable>(this.thread_pool_queue_max_size) : new SynchronousQueue<Runnable>();
                this.thread_pool = TP.createThreadPool(this.thread_pool_min_threads, this.thread_pool_max_threads, this.thread_pool_keep_alive_time, this.thread_pool_rejection_policy, this.thread_pool_queue, this.default_thread_factory);
            } else {
                this.thread_pool = new DirectExecutor();
            }
        }
        if ((this.internal_thread_pool == null || this.internal_thread_pool instanceof ThreadPoolExecutor && ((ThreadPoolExecutor)this.internal_thread_pool).isShutdown()) && this.internal_thread_pool_enabled) {
            this.internal_thread_pool_queue = this.internal_thread_pool_queue_enabled ? new LinkedBlockingQueue<Runnable>(this.internal_thread_pool_queue_max_size) : new SynchronousQueue<Runnable>();
            this.internal_thread_pool = TP.createThreadPool(this.internal_thread_pool_min_threads, this.internal_thread_pool_max_threads, this.internal_thread_pool_keep_alive_time, this.internal_thread_pool_rejection_policy, this.internal_thread_pool_queue, this.internal_thread_factory);
            if (this.internal_thread_pool_min_threads < 2) {
                this.log.warn("The internal thread pool was configured with only %d min_threads; this might lead to problems when more than 1 thread is needed, e.g. when merging", this.internal_thread_pool_min_threads);
            }
        }
        HashMap<String, Serializable> m = new HashMap<String, Serializable>(2);
        if (this.bind_addr != null) {
            m.put("bind_addr", this.bind_addr);
        }
        if (this.external_addr != null) {
            m.put("external_addr", this.external_addr);
        }
        if (this.external_port > 0) {
            m.put("external_port", Integer.valueOf(this.external_port));
        }
        if (!m.isEmpty()) {
            this.up(new Event(56, m));
        }
        this.logical_addr_cache = new LazyRemovalCache(this.logical_addr_cache_max_size, this.logical_addr_cache_expiration);
        if (this.logical_addr_cache_reaper_interval > 0L && (this.logical_addr_cache_reaper == null || this.logical_addr_cache_reaper.isDone())) {
            this.logical_addr_cache_reaper = this.timer.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    TP.this.evictLogicalAddressCache();
                }

                public String toString() {
                    return TP.this.getClass().getSimpleName() + ": LogicalAddressCacheReaper (interval=" + TP.this.logical_addr_cache_expiration + " ms)";
                }
            }, this.logical_addr_cache_reaper_interval, this.logical_addr_cache_reaper_interval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.logical_addr_cache_reaper != null) {
            this.logical_addr_cache_reaper.cancel(false);
            this.logical_addr_cache_reaper = null;
        }
        if (this.time_service != null) {
            this.time_service.stop();
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            TP.shutdownThreadPool(this.oob_thread_pool);
        }
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            TP.shutdownThreadPool(this.thread_pool);
        }
        if (this.internal_thread_pool instanceof ThreadPoolExecutor) {
            TP.shutdownThreadPool(this.internal_thread_pool);
        }
    }

    @Override
    public void start() throws Exception {
        this.fetchLocalAddresses();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        this.startDiagnostics();
        if (this.bundler == null) {
            if (this.bundler_type.startsWith("sender-sends-with-timer") || this.bundler_type.startsWith("old")) {
                if (this.bundler_type.startsWith("old")) {
                    this.log.warn(Util.getMessage("OldBundlerType"), this.bundler_type, "sender-sends-with-timer");
                }
                this.bundler = new SenderSendsWithTimerBundler();
            } else if (this.bundler_type.startsWith("transfer-queue") || this.bundler_type.startsWith("new")) {
                if (this.bundler_type.startsWith("new")) {
                    this.log.warn(Util.getMessage("OldBundlerType"), this.bundler_type, "transfer-queue");
                }
                this.bundler = new TransferQueueBundler(this.bundler_capacity);
            } else if (this.bundler_type.startsWith("sender-sends")) {
                this.bundler = new SenderSendsBundler();
            } else {
                this.log.warn(Util.getMessage("UnknownBundler"), this.bundler_type);
            }
            if (this.bundler == null) {
                this.bundler = new TransferQueueBundler(this.bundler_capacity);
            }
        }
        this.bundler.start();
        this.setInAllThreadFactories(this.cluster_name != null ? this.cluster_name.toString() : null, this.local_addr, this.thread_naming_pattern);
    }

    @Override
    public void stop() {
        this.stopDiagnostics();
        if (this.bundler != null) {
            this.bundler.stop();
        }
    }

    @ManagedOperation(description="Enables diagnostics and starts DiagnosticsHandler (if not running)")
    public void enableDiagnostics() {
        this.enable_diagnostics = true;
        try {
            this.startDiagnostics();
        }
        catch (Exception e) {
            this.log.error("failed starting diagnostics", e);
        }
    }

    @ManagedOperation(description="Disables diagnostics and stops DiagnosticsHandler (if running)")
    public void disableDiagnostics() {
        this.enable_diagnostics = false;
        this.stopDiagnostics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startDiagnostics() throws Exception {
        List<DiagnosticsHandler.ProbeHandler> list;
        if (this.enable_diagnostics) {
            this.diag_handler.registerProbeHandler(this);
            this.diag_handler.start();
            list = this.preregistered_probe_handlers;
            synchronized (list) {
                for (DiagnosticsHandler.ProbeHandler handler : this.preregistered_probe_handlers) {
                    this.diag_handler.registerProbeHandler(handler);
                }
            }
        }
        list = this.preregistered_probe_handlers;
        synchronized (list) {
            this.preregistered_probe_handlers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopDiagnostics() {
        this.diag_handler.unregisterProbeHandler(this);
        this.diag_handler.stop();
        List<DiagnosticsHandler.ProbeHandler> list = this.preregistered_probe_handlers;
        synchronized (list) {
            this.preregistered_probe_handlers.clear();
        }
    }

    @Override
    public Map<String, String> handleProbe(String ... keys) {
        HashMap<String, String> retval = new HashMap<String, String>(2);
        for (String key : keys) {
            if (key.equals("dump")) {
                retval.put("dump", Util.dumpThreads());
                continue;
            }
            if (key.equals("uuids")) {
                retval.put("uuids", this.printLogicalAddressCache());
                if (this.isSingleton() || retval.containsKey("local_addr")) continue;
                retval.put("local_addr", this.local_addr != null ? this.local_addr.toString() : null);
                continue;
            }
            if (key.equals("keys")) {
                StringBuilder sb = new StringBuilder();
                for (DiagnosticsHandler.ProbeHandler handler : this.diag_handler.getProbeHandlers()) {
                    String[] tmp = handler.supportedKeys();
                    if (tmp == null || tmp.length <= 0) continue;
                    for (String s : tmp) {
                        sb.append(s).append(" ");
                    }
                }
                retval.put("keys", sb.toString());
            }
            if (key.equals("info") && this.singleton_name != null && !this.singleton_name.isEmpty()) {
                retval.put("singleton_name", this.singleton_name);
            }
            if (key.equals("addrs")) {
                Set<PhysicalAddress> physical_addrs = this.logical_addr_cache.nonRemovedValues();
                String list = Util.print(physical_addrs);
                retval.put("addrs", list);
            }
            if (!key.startsWith("cluster")) continue;
            String cluster_name_pattern = key.substring("cluster".length() + 1).trim();
            if (!this.isSingleton()) {
                if (cluster_name_pattern == null || Util.patternMatch(cluster_name_pattern, this.cluster_name != null ? this.cluster_name.toString() : null)) continue;
                throw new IllegalArgumentException("Request dropped as cluster name " + this.cluster_name + " does not match cluster name pattern " + cluster_name_pattern);
            }
            if (this.up_prots == null) continue;
            boolean match = false;
            ArrayList<String> cluster_names = new ArrayList<String>();
            for (Protocol prot : this.up_prots.values()) {
                if (!(prot instanceof ProtocolAdapter)) continue;
                cluster_names.add(((ProtocolAdapter)prot).getClusterName());
            }
            for (String cname : cluster_names) {
                if (!Util.patternMatch(cluster_name_pattern, cname)) continue;
                match = true;
                break;
            }
            if (match) continue;
            throw new IllegalArgumentException("Request dropped as cluster names " + cluster_names + " do not match cluster name pattern " + cluster_name_pattern);
        }
        return retval;
    }

    @Override
    public String[] supportedKeys() {
        return new String[]{"dump", "keys", "uuids", "info", "addrs", "cluster"};
    }

    protected void handleConnect() throws Exception {
        ++this.connect_count;
    }

    protected void handleDisconnect() {
        this.connect_count = Math.max(0, this.connect_count - 1);
    }

    public String getSingletonName() {
        return this.singleton_name;
    }

    public boolean isSingleton() {
        return this.singleton_name != null;
    }

    @Override
    public Object up(Event evt) {
        if (this.isSingleton()) {
            this.passToAllUpProtocols(evt);
            return null;
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        boolean loop_back;
        if (evt.getType() != 1) {
            return this.handleDownEvent(evt);
        }
        Message msg = (Message)evt.getArg();
        if (this.header != null) {
            msg.putHeaderIfAbsent(this.id, this.header);
        }
        if (!this.isSingleton()) {
            this.setSourceAddress(msg);
        }
        Address dest = msg.getDest();
        Address sender = msg.getSrc();
        if (dest instanceof PhysicalAddress) {
            msg.dest(null).setFlag(Message.Flag.DONT_BUNDLE);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s: sending msg to %s, src=%s, headers are %s", this.local_addr, dest, sender, msg.printHeaders());
        }
        boolean multicast = dest == null;
        boolean do_send = multicast || !dest.equals(sender);
        boolean bl = loop_back = (multicast || dest.equals(sender)) && !msg.isTransientFlagSet(Message.TransientFlag.DONT_LOOPBACK);
        if (dest instanceof PhysicalAddress && dest.equals(this.local_physical_addr)) {
            loop_back = true;
            do_send = false;
        }
        if (this.loopback_separate_thread) {
            if (loop_back) {
                this.loopback(msg, multicast);
            }
            if (do_send) {
                this._send(msg, dest);
            }
        } else {
            if (do_send) {
                this._send(msg, dest);
            }
            if (loop_back) {
                this.loopback(msg, multicast);
            }
        }
        return null;
    }

    protected void loopback(Message msg, final boolean multicast) {
        AsciiString tmp_cluster_name;
        Message copy;
        Message message = copy = this.loopback_copy ? msg.copy() : msg;
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s: looping back message %s", this.local_addr, copy);
        }
        AsciiString asciiString = tmp_cluster_name = this.isSingleton() ? new AsciiString(((TpHeader)msg.getHeader((short)this.id)).cluster_name) : null;
        if (!this.loopback_separate_thread) {
            this.passMessageUp(copy, tmp_cluster_name, false, multicast, false);
            return;
        }
        boolean internal = msg.isFlagSet(Message.Flag.INTERNAL);
        Executor pool = internal && this.internal_thread_pool != null ? this.internal_thread_pool : (internal || msg.isFlagSet(Message.Flag.OOB) ? this.oob_thread_pool : this.thread_pool);
        pool.execute(new Runnable(){

            @Override
            public void run() {
                TP.this.passMessageUp(copy, tmp_cluster_name, false, multicast, false);
            }
        });
    }

    protected void _send(Message msg, Address dest) {
        try {
            this.send(msg, dest);
        }
        catch (InterruptedIOException iex) {
        }
        catch (InterruptedException interruptedEx) {
            Thread.currentThread().interrupt();
        }
        catch (SocketException sock_ex) {
            this.log.trace(Util.getMessage("SendFailure"), this.local_addr, dest == null ? "cluster" : dest, msg.size(), sock_ex.toString(), msg.printHeaders());
        }
        catch (Throwable e) {
            this.log.error(Util.getMessage("SendFailure"), this.local_addr, dest == null ? "cluster" : dest, msg.size(), e.toString(), msg.printHeaders());
        }
    }

    protected void setSourceAddress(Message msg) {
        if (msg.getSrc() == null && this.local_addr != null) {
            msg.setSrc(this.local_addr);
        }
    }

    protected void passMessageUp(Message msg, AsciiString cluster_name, boolean perform_cluster_name_matching, boolean multicast, boolean discard_own_mcast) {
        Protocol tmp_prot;
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s: received %s, headers are %s", this.local_addr, msg, msg.printHeaders());
        }
        Protocol protocol = tmp_prot = this.isSingleton() ? (Protocol)this.up_prots.get(cluster_name) : this.up_prot;
        if (tmp_prot == null) {
            return;
        }
        boolean is_protocol_adapter = tmp_prot instanceof ProtocolAdapter;
        if (!is_protocol_adapter && perform_cluster_name_matching && this.cluster_name != null && !this.cluster_name.equals(cluster_name)) {
            if (this.log_discard_msgs && this.log.isWarnEnabled()) {
                Address sender = msg.getSrc();
                if (this.suppress_log_different_cluster != null) {
                    this.suppress_log_different_cluster.log(SuppressLog.Level.warn, sender, this.suppress_time_different_cluster_warnings, cluster_name, this.cluster_name, sender);
                } else {
                    this.log.warn(Util.getMessage("MsgDroppedDiffCluster"), cluster_name, this.cluster_name, sender);
                }
            }
            return;
        }
        if (multicast && discard_own_mcast) {
            Address local;
            Address address = local = is_protocol_adapter ? ((ProtocolAdapter)tmp_prot).getAddress() : this.local_addr;
            if (local != null && local.equals(msg.getSrc())) {
                return;
            }
        }
        tmp_prot.up(new Event(1, msg));
    }

    protected void passBatchUp(MessageBatch batch, boolean perform_cluster_name_matching, boolean discard_own_mcast) {
        Protocol tmp_prot;
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s: received message batch of %d messages from %s", this.local_addr, batch.size(), batch.sender());
        }
        AsciiString ch_name = batch.clusterName();
        Protocol protocol = tmp_prot = this.isSingleton() ? (Protocol)this.up_prots.get(ch_name) : this.up_prot;
        if (tmp_prot == null) {
            return;
        }
        boolean is_protocol_adapter = tmp_prot instanceof ProtocolAdapter;
        if (!is_protocol_adapter && perform_cluster_name_matching && this.cluster_name != null && !this.cluster_name.equals(ch_name)) {
            if (this.log_discard_msgs && this.log.isWarnEnabled()) {
                Address sender = batch.sender();
                if (this.suppress_log_different_cluster != null) {
                    this.suppress_log_different_cluster.log(SuppressLog.Level.warn, sender, this.suppress_time_different_cluster_warnings, ch_name, this.cluster_name, sender);
                } else {
                    this.log.warn(Util.getMessage("BatchDroppedDiffCluster"), ch_name, this.cluster_name, sender);
                }
            }
            return;
        }
        if (batch.multicast() && discard_own_mcast) {
            Address local;
            Address address = local = is_protocol_adapter ? ((ProtocolAdapter)tmp_prot).getAddress() : this.local_addr;
            if (local != null && local.equals(batch.sender())) {
                return;
            }
        }
        tmp_prot.up(batch);
    }

    public void receive(Address sender, byte[] data, int offset, int length) {
        boolean is_message_list;
        if (data == null) {
            return;
        }
        if (this.local_physical_addr != null && this.local_physical_addr.equals(sender)) {
            return;
        }
        byte flags = data[2];
        boolean bl = is_message_list = (flags & 1) == 1;
        if (is_message_list) {
            this.handleMessageBatch(sender, data, offset, length);
        } else {
            this.handleSingleMessage(sender, data, offset, length);
        }
    }

    protected void handleMessageBatch(Address sender, byte[] data, int offset, int length) {
        try {
            Executor pool;
            ByteArrayDataInputStream in = new ByteArrayDataInputStream(data, offset, length);
            short version = in.readShort();
            if (!this.versionMatch(version, sender)) {
                return;
            }
            byte flags = in.readByte();
            boolean multicast = (flags & 2) == 2;
            MessageBatch[] batches = TP.readMessageBatch(in, multicast);
            MessageBatch batch = batches[0];
            MessageBatch oob_batch = batches[1];
            MessageBatch internal_batch_oob = batches[2];
            MessageBatch internal_batch = batches[3];
            this.removeAndDispatchNonBundledMessages(oob_batch, internal_batch_oob);
            if (oob_batch != null && !oob_batch.isEmpty()) {
                this.num_oob_msgs_received += (long)oob_batch.size();
                this.oob_thread_pool.execute(new BatchHandler(oob_batch));
            }
            if (batch != null) {
                this.num_incoming_msgs_received += (long)batch.size();
                this.thread_pool.execute(new BatchHandler(batch));
            }
            if (internal_batch_oob != null && !internal_batch_oob.isEmpty()) {
                this.num_oob_msgs_received += (long)internal_batch_oob.size();
                pool = this.internal_thread_pool != null ? this.internal_thread_pool : this.oob_thread_pool;
                pool.execute(new BatchHandler(internal_batch_oob));
            }
            if (internal_batch != null) {
                this.num_internal_msgs_received += (long)internal_batch.size();
                pool = this.internal_thread_pool != null ? this.internal_thread_pool : this.oob_thread_pool;
                pool.execute(new BatchHandler(internal_batch));
            }
        }
        catch (RejectedExecutionException rejected) {
            ++this.num_rejected_msgs;
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("IncomingMsgFailure"), this.local_addr, t);
        }
    }

    protected void handleSingleMessage(Address sender, byte[] data, int offset, int length) {
        boolean oob;
        short msg_flags = Bits.makeShort(data[offset + 4], data[offset + 4 + 1]);
        boolean internal = (msg_flags & Message.Flag.INTERNAL.value()) == Message.Flag.INTERNAL.value();
        boolean bl = oob = (msg_flags & Message.Flag.OOB.value()) == Message.Flag.OOB.value();
        if (oob) {
            ++this.num_oob_msgs_received;
        } else if (internal) {
            ++this.num_internal_msgs_received;
        } else {
            ++this.num_incoming_msgs_received;
        }
        Executor pool = this.pickThreadPool(oob, internal);
        try {
            if (pool instanceof DirectExecutor) {
                pool.execute(new MyHandler(sender, data, offset, length));
            } else {
                byte[] tmp = new byte[length];
                System.arraycopy(data, offset, tmp, 0, length);
                pool.execute(new MyHandler(sender, tmp, 0, tmp.length));
            }
        }
        catch (RejectedExecutionException ex) {
            ++this.num_rejected_msgs;
        }
    }

    protected void removeAndDispatchNonBundledMessages(MessageBatch ... oob_batches) {
        for (MessageBatch oob_batch : oob_batches) {
            if (oob_batch == null) continue;
            for (Message msg : oob_batch) {
                if (!msg.isFlagSet(Message.Flag.DONT_BUNDLE) || !msg.isFlagSet(Message.Flag.OOB)) continue;
                boolean oob = msg.isFlagSet(Message.Flag.OOB);
                boolean internal = msg.isFlagSet(Message.Flag.INTERNAL);
                msg.putHeader(this.id, new TpHeader(oob_batch.clusterName()));
                Executor pool = this.pickThreadPool(oob, internal);
                try {
                    pool.execute(new SingleMessageHandler(msg));
                    oob_batch.remove(msg);
                    ++this.num_oob_msgs_received;
                }
                catch (Throwable t) {
                    this.log.error("%s: failed submitting DONT_BUNDLE message to thread pool: %s. Msg: %s", this.local_addr, t, msg.printHeaders());
                }
            }
        }
    }

    protected Executor pickThreadPool(boolean oob, boolean internal) {
        return internal && this.internal_thread_pool != null ? this.internal_thread_pool : (internal || oob ? this.oob_thread_pool : this.thread_pool);
    }

    protected boolean versionMatch(short version, Address sender) {
        boolean match = Version.isBinaryCompatible(version);
        if (!match && this.log_discard_msgs_version && this.log.isWarnEnabled()) {
            if (this.suppress_log_different_version != null) {
                this.suppress_log_different_version.log(SuppressLog.Level.warn, sender, this.suppress_time_different_version_warnings, sender, Version.print(version), Version.printVersion());
            } else {
                this.log.warn(Util.getMessage("VersionMismatch"), sender, Version.print(version), Version.printVersion());
            }
        }
        return match;
    }

    protected void send(Message msg, Address dest) throws Exception {
        boolean bypass_bundling;
        boolean bl = bypass_bundling = msg.isFlagSet(Message.Flag.DONT_BUNDLE) && (!this.ignore_dont_bundle || this.bundler instanceof SenderSendsWithTimerBundler || dest instanceof PhysicalAddress);
        if (!bypass_bundling) {
            this.bundler.send(msg);
            return;
        }
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream((int)(msg.size() + 3L));
        TP.writeMessage(msg, out, dest == null);
        this.doSend(this.getClusterName(msg), out.buffer(), 0, out.position(), dest);
        if (this.stats) {
            ++this.num_single_msgs_sent;
        }
    }

    protected void doSend(AsciiString cluster_name, byte[] buf, int offset, int length, Address dest) throws Exception {
        if (this.stats) {
            ++this.num_msgs_sent;
            this.num_bytes_sent += (long)length;
        }
        if (dest == null) {
            this.sendMulticast(cluster_name, buf, offset, length);
        } else {
            this.sendToSingleMember(dest, buf, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToSingleMember(Address dest, byte[] buf, int offset, int length) throws Exception {
        if (dest instanceof PhysicalAddress) {
            this.sendUnicast((PhysicalAddress)dest, buf, offset, length);
            return;
        }
        PhysicalAddress physical_dest = this.getPhysicalAddressFromCache(dest);
        if (physical_dest != null) {
            this.sendUnicast(physical_dest, buf, offset, length);
            return;
        }
        if (this.who_has_cache.addIfAbsentOrExpired(dest)) {
            Responses responses = this.fetchResponsesFromDiscoveryProtocol(Arrays.asList(dest));
            try {
                for (PingData data : responses) {
                    if (data.getAddress() == null || !data.getAddress().equals(dest) || (physical_dest = data.getPhysicalAddr()) == null) continue;
                    this.sendUnicast(physical_dest, buf, offset, length);
                    return;
                }
                this.log.warn(Util.getMessage("PhysicalAddrMissing"), this.local_addr, dest);
            }
            finally {
                responses.done();
            }
        }
    }

    protected void sendToMembers(Collection<Address> mbrs, byte[] buf, int offset, int length) throws Exception {
        ArrayList<Address> missing = null;
        if (mbrs == null || mbrs.isEmpty()) {
            mbrs = this.logical_addr_cache.keySet();
        }
        for (Address mbr : mbrs) {
            PhysicalAddress target = this.logical_addr_cache.get(mbr);
            if (target == null) {
                if (missing == null) {
                    missing = new ArrayList<Address>(mbrs.size());
                }
                missing.add(mbr);
                continue;
            }
            try {
                if (this.local_physical_addr != null && this.local_physical_addr.equals(target)) continue;
                this.sendUnicast(target, buf, offset, length);
            }
            catch (SocketException sock_ex) {
                this.log.debug(Util.getMessage("FailureSendingToPhysAddr"), this.local_addr, mbr, sock_ex);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("FailureSendingToPhysAddr"), this.local_addr, mbr, t);
            }
        }
        if (missing != null) {
            this.fetchPhysicalAddrs(missing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchPhysicalAddrs(List<Address> missing) {
        long current_time = 0L;
        boolean do_send = false;
        TP tP = this;
        synchronized (tP) {
            if (this.last_discovery_request == 0L || (current_time = this.time_service.timestamp()) - this.last_discovery_request >= MIN_WAIT_BETWEEN_DISCOVERIES) {
                this.last_discovery_request = current_time == 0L ? this.time_service.timestamp() : current_time;
                do_send = true;
            }
        }
        if (do_send) {
            missing.removeAll(this.logical_addr_cache.keySet());
            if (!missing.isEmpty()) {
                Responses rsps = this.fetchResponsesFromDiscoveryProtocol(missing);
                rsps.done();
            }
        }
    }

    protected Responses fetchResponsesFromDiscoveryProtocol(List<Address> missing) {
        if (!this.isSingleton()) {
            return (Responses)this.up_prot.up(new Event(11, missing));
        }
        int size = missing == null ? 16 : missing.size();
        Responses rsps = new Responses(size, false, size);
        Collection prots = this.up_prots.values();
        if (prots != null) {
            for (Protocol prot : prots) {
                Responses tmp_rsp = (Responses)prot.up(new Event(11, missing));
                if (tmp_rsp == null) continue;
                for (PingData data : tmp_rsp) {
                    rsps.addResponse(data, true);
                }
            }
        }
        return rsps;
    }

    protected AsciiString getClusterName(Message msg) {
        if (msg == null || !this.isSingleton()) {
            return null;
        }
        TpHeader hdr = (TpHeader)msg.getHeader(this.id);
        return hdr != null ? new AsciiString(hdr.cluster_name) : null;
    }

    protected void setPingData(PingData data) {
        if (data.getAddress() != null) {
            if (data.getPhysicalAddr() != null) {
                this.addPhysicalAddressToCache(data.getAddress(), data.getPhysicalAddr());
            }
            if (data.getLogicalName() != null) {
                UUID.add(data.getAddress(), data.getLogicalName());
            }
        }
    }

    protected static void writeMessage(Message msg, DataOutput dos, boolean multicast) throws Exception {
        int flags = 0;
        dos.writeShort(Version.version);
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        dos.writeByte(flags);
        msg.writeTo(dos);
    }

    public static Message readMessage(DataInput instream) throws Exception {
        Message msg = new Message(false);
        msg.readFrom(instream);
        return msg;
    }

    public static void writeMessageList(Address dest, Address src, byte[] cluster_name, List<Message> msgs, DataOutput dos, boolean multicast, short transport_id) throws Exception {
        dos.writeShort(Version.version);
        int flags = 1;
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        dos.writeByte(flags);
        Util.writeAddress(dest, dos);
        Util.writeAddress(src, dos);
        dos.writeShort(cluster_name != null ? cluster_name.length : -1);
        if (cluster_name != null) {
            dos.write(cluster_name);
        }
        dos.writeInt(msgs != null ? msgs.size() : 0);
        if (msgs != null) {
            for (Message msg : msgs) {
                msg.writeToNoAddrs(src, dos, transport_id);
            }
        }
    }

    public static List<Message> readMessageList(DataInput in, short transport_id) throws Exception {
        byte[] cluster_name;
        LinkedList<Message> list = new LinkedList<Message>();
        Address dest = Util.readAddress(in);
        Address src = Util.readAddress(in);
        short length = in.readShort();
        byte[] byArray = cluster_name = length >= 0 ? new byte[length] : null;
        if (cluster_name != null) {
            in.readFully(cluster_name, 0, cluster_name.length);
        }
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            Message msg = new Message(false);
            msg.readFrom(in);
            msg.setDest(dest);
            if (msg.getSrc() == null) {
                msg.setSrc(src);
            }
            msg.putHeader(transport_id, new TpHeader(cluster_name));
            list.add(msg);
        }
        return list;
    }

    public static MessageBatch[] readMessageBatch(DataInput in, boolean multicast) throws Exception {
        byte[] cluster_name;
        MessageBatch[] batches = new MessageBatch[4];
        Address dest = Util.readAddress(in);
        Address src = Util.readAddress(in);
        short length = in.readShort();
        byte[] byArray = cluster_name = length >= 0 ? new byte[length] : null;
        if (cluster_name != null) {
            in.readFully(cluster_name, 0, cluster_name.length);
        }
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            Message msg = new Message(false);
            msg.readFrom(in);
            msg.setDest(dest);
            if (msg.getSrc() == null) {
                msg.setSrc(src);
            }
            boolean oob = msg.isFlagSet(Message.Flag.OOB);
            boolean internal = msg.isFlagSet(Message.Flag.INTERNAL);
            int index = 0;
            MessageBatch.Mode mode = MessageBatch.Mode.REG;
            if (oob && !internal) {
                index = 1;
                mode = MessageBatch.Mode.OOB;
            } else if (oob && internal) {
                index = 2;
                mode = MessageBatch.Mode.OOB;
            } else if (!oob && internal) {
                index = 3;
                mode = MessageBatch.Mode.INTERNAL;
            }
            if (batches[index] == null) {
                batches[index] = new MessageBatch(dest, src, new AsciiString(cluster_name), multicast, mode, len);
            }
            batches[index].add(msg);
        }
        return batches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Set<Address> set = this.members;
                synchronized (set) {
                    View view = (View)evt.getArg();
                    ArrayList<Address> old_members = new ArrayList<Address>(this.members);
                    this.members.clear();
                    if (!this.isSingleton()) {
                        List<Address> tmpvec = view.getMembers();
                        this.members.addAll(tmpvec);
                    } else {
                        for (Protocol prot : this.up_prots.values()) {
                            if (!(prot instanceof ProtocolAdapter)) continue;
                            ProtocolAdapter ad = (ProtocolAdapter)prot;
                            Set<Address> tmp = ad.getMembers();
                            this.members.addAll(tmp);
                        }
                    }
                    this.logical_addr_cache.retainAll(this.members);
                    this.fetchLocalAddresses();
                    List<Address> left_mbrs = Util.leftMembers(old_members, this.members);
                    if (left_mbrs != null && !left_mbrs.isEmpty()) {
                        UUID.removeAll(left_mbrs);
                    }
                    if (this.suppress_log_different_version != null) {
                        this.suppress_log_different_version.removeExpired(this.suppress_time_different_version_warnings);
                    }
                    if (this.suppress_log_different_cluster != null) {
                        this.suppress_log_different_cluster.removeExpired(this.suppress_time_different_cluster_warnings);
                    }
                }
                this.who_has_cache.removeExpiredElements();
                break;
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.cluster_name = new AsciiString((String)evt.getArg());
                this.header = new TpHeader(this.cluster_name);
                this.setInAllThreadFactories(this.cluster_name != null ? this.cluster_name.toString() : null, this.local_addr, this.thread_naming_pattern);
                this.setThreadNames();
                this.connectLock.lock();
                try {
                    this.handleConnect();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.connectLock.unlock();
                }
                return null;
            }
            case 4: {
                this.unsetThreadNames();
                this.connectLock.lock();
                try {
                    this.handleDisconnect();
                    break;
                }
                finally {
                    this.connectLock.unlock();
                }
            }
            case 87: {
                Address addr = (Address)evt.getArg();
                PhysicalAddress physical_addr = this.getPhysicalAddressFromCache(addr);
                if (physical_addr != null) {
                    return physical_addr;
                }
                if (addr != null && this.local_addr != null && addr.equals(this.local_addr) && (physical_addr = this.getPhysicalAddress()) != null) {
                    this.addPhysicalAddressToCache(addr, physical_addr);
                }
                return physical_addr;
            }
            case 102: {
                return this.getAllPhysicalAddressesFromCache();
            }
            case 88: {
                Object arg = evt.getArg();
                boolean skip_removed_values = arg instanceof Boolean && (Boolean)arg != false;
                return this.logical_addr_cache.contents(skip_removed_values);
            }
            case 89: {
                Tuple tuple = (Tuple)evt.getArg();
                return this.addPhysicalAddressToCache((Address)tuple.getVal1(), (PhysicalAddress)tuple.getVal2());
            }
            case 90: {
                this.removeLogicalAddressFromCache((Address)evt.getArg());
                break;
            }
            case 8: {
                if (!this.isSingleton()) {
                    this.local_addr = (Address)evt.getArg();
                }
                this.registerLocalAddress((Address)evt.getArg());
            }
        }
        return null;
    }

    protected void registerLocalAddress(Address addr) {
        PhysicalAddress physical_addr = this.getPhysicalAddress();
        if (physical_addr != null && addr != null) {
            this.local_physical_addr = physical_addr;
            this.addPhysicalAddressToCache(addr, physical_addr);
        }
    }

    protected void fetchLocalAddresses() {
        if (!this.isSingleton()) {
            if (this.local_addr != null) {
                this.registerLocalAddress(this.local_addr);
            } else {
                Address addr;
                this.local_addr = addr = (Address)this.up_prot.up(new Event(91));
                this.registerLocalAddress(addr);
            }
        } else {
            for (Protocol prot : this.up_prots.values()) {
                Address addr = (Address)prot.up(new Event(91));
                this.registerLocalAddress(addr);
            }
        }
    }

    protected void setThreadNames() {
        if (this.diag_handler != null) {
            this.global_thread_factory.renameThread("DiagnosticsHandler", this.diag_handler.getThread());
        }
        if (this.bundler instanceof TransferQueueBundler) {
            this.global_thread_factory.renameThread("TransferQueueBundler", ((TransferQueueBundler)this.bundler).getThread());
        }
    }

    protected void unsetThreadNames() {
        Thread thread;
        if (this.diag_handler != null && this.diag_handler.getThread() != null) {
            this.diag_handler.getThread().setName("DiagnosticsHandler");
        }
        if (this.bundler instanceof TransferQueueBundler && (thread = ((TransferQueueBundler)this.bundler).getThread()) != null) {
            this.global_thread_factory.renameThread("TransferQueueBundler", thread);
        }
    }

    protected void setInAllThreadFactories(String cluster_name, Address local_address, String pattern) {
        ThreadFactory[] factories = new ThreadFactory[]{this.timer_thread_factory, this.default_thread_factory, this.oob_thread_factory, this.internal_thread_factory, this.global_thread_factory};
        boolean is_shared_transport = this.isSingleton();
        for (ThreadFactory factory : factories) {
            if (pattern != null && !is_shared_transport) {
                factory.setPattern(pattern);
            }
            if (cluster_name != null) {
                factory.setClusterName(is_shared_transport ? this.singleton_name : cluster_name);
            }
            if (local_address == null) continue;
            factory.setAddress(local_address.toString());
        }
    }

    protected static ExecutorService createThreadPool(int min_threads, int max_threads, long keep_alive_time, String rejection_policy, BlockingQueue<Runnable> queue, ThreadFactory factory) {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, queue);
        pool.setThreadFactory(factory);
        RejectedExecutionHandler handler = Util.parseRejectionPolicy(rejection_policy);
        pool.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(handler));
        return pool;
    }

    protected static void shutdownThreadPool(Executor thread_pool) {
        if (thread_pool instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)thread_pool;
            service.shutdownNow();
            try {
                service.awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void passToAllUpProtocols(Event evt) {
        for (Protocol prot : this.up_prots.values()) {
            try {
                prot.up(evt);
            }
            catch (Exception e) {
                this.log.error(Util.getMessage("PassUpFailureEvent"), this.local_addr, evt, e);
            }
        }
    }

    protected boolean addPhysicalAddressToCache(Address logical_addr, PhysicalAddress physical_addr) {
        if (logical_addr != null && physical_addr != null) {
            return this.logical_addr_cache.add(logical_addr, physical_addr);
        }
        return false;
    }

    protected PhysicalAddress getPhysicalAddressFromCache(Address logical_addr) {
        return logical_addr != null ? this.logical_addr_cache.get(logical_addr) : null;
    }

    protected Collection<PhysicalAddress> getAllPhysicalAddressesFromCache() {
        return this.logical_addr_cache.nonRemovedValues();
    }

    protected void removeLogicalAddressFromCache(Address logical_addr) {
        if (logical_addr != null) {
            this.logical_addr_cache.remove(logical_addr);
            this.fetchLocalAddresses();
        }
    }

    @ManagedOperation(description="Clears the logical address cache; only used for testing")
    public void clearLogicalAddressCache() {
        this.logical_addr_cache.clear(true);
        this.fetchLocalAddresses();
    }

    protected abstract PhysicalAddress getPhysicalAddress();

    static {
        MIN_WAIT_BETWEEN_DISCOVERIES = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.SECONDS);
        can_bind_to_mcast_addr = Util.checkForLinux() && !Util.checkForAndroid() || Util.checkForSolaris() || Util.checkForHp() || Util.checkForMac();
        f = NumberFormat.getNumberInstance();
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
        print_function = new LazyRemovalCache.Printable<Address, LazyRemovalCache.Entry<PhysicalAddress>>(){

            @Override
            public String print(Address logical_addr, LazyRemovalCache.Entry<PhysicalAddress> entry) {
                StringBuilder sb = new StringBuilder();
                String tmp_logical_name = UUID.get(logical_addr);
                if (tmp_logical_name != null) {
                    sb.append(tmp_logical_name).append(": ");
                }
                if (logical_addr instanceof UUID) {
                    sb.append(((UUID)logical_addr).toStringLong());
                } else {
                    sb.append(logical_addr);
                }
                sb.append(": ").append(entry).append("\n");
                return sb.toString();
            }
        };
    }

    @MBean(description="Protocol adapter (used when the shared transport is enabled)")
    public static class ProtocolAdapter
    extends Protocol
    implements DiagnosticsHandler.ProbeHandler {
        AsciiString cluster_name;
        final short transport_id;
        TpHeader header;
        final Set<Address> members = new CopyOnWriteArraySet<Address>();
        final ThreadFactory factory;
        protected SocketFactory socket_factory = new DefaultSocketFactory();
        Address local_addr;

        public ProtocolAdapter(AsciiString cluster_name, Address local_addr, short transport_id, Protocol up2, Protocol down2, String pattern) {
            this.cluster_name = cluster_name;
            this.local_addr = local_addr;
            this.transport_id = transport_id;
            this.up_prot = up2;
            this.down_prot = down2;
            this.header = new TpHeader(cluster_name);
            this.factory = new DefaultThreadFactory("", false);
            this.factory.setPattern(pattern);
            if (local_addr != null) {
                this.factory.setAddress(local_addr.toString());
            }
            if (cluster_name != null) {
                this.factory.setClusterName(cluster_name != null ? cluster_name.toString() : null);
            }
        }

        @ManagedAttribute(description="Name of the cluster to which this adapter proxies")
        public String getClusterName() {
            return this.cluster_name != null ? this.cluster_name.toString() : null;
        }

        public Address getAddress() {
            return this.local_addr;
        }

        @ManagedAttribute(name="address", description="local address")
        public String getAddressAsString() {
            return this.local_addr != null ? this.local_addr.toString() : null;
        }

        @ManagedAttribute(name="address_uuid", description="local address")
        public String getAddressAsUUID() {
            return this.local_addr instanceof UUID ? ((UUID)this.local_addr).toStringLong() : null;
        }

        @ManagedAttribute(description="ID of the transport")
        public short getTransportName() {
            return this.transport_id;
        }

        public Set<Address> getMembers() {
            return this.members;
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.factory;
        }

        @Override
        public SocketFactory getSocketFactory() {
            return this.socket_factory;
        }

        @Override
        public void setSocketFactory(SocketFactory factory) {
            if (factory != null) {
                this.socket_factory = factory;
            }
        }

        @Override
        public void start() throws Exception {
            TP tp = this.getTransport();
            if (tp != null) {
                tp.registerProbeHandler(this);
            }
        }

        @Override
        public void stop() {
            TP tp = this.getTransport();
            if (tp != null) {
                tp.unregisterProbeHandler(this);
            }
        }

        @Override
        public Object down(Event evt) {
            switch (evt.getType()) {
                case 1: {
                    Message msg = (Message)evt.getArg();
                    msg.putHeader(this.transport_id, this.header);
                    if (msg.getSrc() != null) break;
                    msg.setSrc(this.local_addr);
                    break;
                }
                case 6: {
                    View view = (View)evt.getArg();
                    List<Address> tmp = view.getMembers();
                    this.members.clear();
                    this.members.addAll(tmp);
                    break;
                }
                case 2: 
                case 80: 
                case 92: 
                case 93: {
                    this.cluster_name = new AsciiString((String)evt.getArg());
                    this.factory.setClusterName(this.getClusterName());
                    this.header = new TpHeader(this.cluster_name);
                    break;
                }
                case 8: {
                    Address addr = (Address)evt.getArg();
                    if (addr == null) break;
                    this.local_addr = addr;
                    this.factory.setAddress(addr.toString());
                }
            }
            return this.down_prot.down(evt);
        }

        @Override
        public Object up(Event evt) {
            Message msg;
            Address dest;
            if (evt.getType() == 1 && (dest = (msg = (Message)evt.getArg()).getDest()) != null && this.local_addr != null && !dest.equals(this.local_addr)) {
                return null;
            }
            return this.up_prot.up(evt);
        }

        @Override
        public void up(MessageBatch batch) {
            Address dest = batch.dest();
            if (dest != null && this.local_addr != null && !dest.equals(this.local_addr)) {
                return;
            }
            this.up_prot.up(batch);
        }

        @Override
        public String getName() {
            return "TP.ProtocolAdapter";
        }

        public String toString() {
            return this.cluster_name + " (" + this.transport_id + ")";
        }

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            HashMap<String, String> retval = new HashMap<String, String>();
            retval.put("cluster", this.getClusterName());
            retval.put("local_addr", this.local_addr != null ? this.local_addr.toString() : null);
            retval.put("local_addr (UUID)", this.local_addr instanceof UUID ? ((UUID)this.local_addr).toStringLong() : null);
            retval.put("transport_id", Short.toString(this.transport_id));
            return retval;
        }

        @Override
        public String[] supportedKeys() {
            return null;
        }
    }

    protected class TransferQueueBundler
    extends BaseBundler
    implements Runnable {
        protected final int threshold;
        protected final BlockingQueue<Message> queue;
        protected volatile Thread bundler_thread;
        protected static final String THREAD_NAME = "TransferQueueBundler";

        protected TransferQueueBundler(int capacity) {
            if (capacity <= 0) {
                throw new IllegalArgumentException("bundler capacity cannot be " + capacity);
            }
            this.queue = new LinkedBlockingQueue<Message>(capacity);
            this.threshold = (int)((double)capacity * 0.9);
        }

        public Thread getThread() {
            return this.bundler_thread;
        }

        public int getBufferSize() {
            return this.queue.size();
        }

        @Override
        public synchronized void start() {
            if (this.bundler_thread != null) {
                this.stop();
            }
            this.bundler_thread = TP.this.getThreadFactory().newThread(this, THREAD_NAME);
            this.bundler_thread.start();
        }

        @Override
        public synchronized void stop() {
            Thread tmp = this.bundler_thread;
            this.bundler_thread = null;
            if (tmp != null) {
                tmp.interrupt();
                if (tmp.isAlive()) {
                    try {
                        tmp.join(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.queue.clear();
        }

        @Override
        public void send(Message msg) throws Exception {
            long size = msg.size();
            this.checkLength(size);
            if (this.bundler_thread != null) {
                this.queue.put(msg);
            }
        }

        @Override
        public void run() {
            while (Thread.currentThread() == this.bundler_thread) {
                Message msg = null;
                try {
                    long size;
                    if (this.count == 0L) {
                        msg = this.queue.take();
                        if (msg == null) continue;
                        size = msg.size();
                        if (this.count + size >= (long)TP.this.max_bundle_size || this.queue.size() >= this.threshold) {
                            this.sendBundledMessages(this.msgs, this.output);
                        }
                        this.addMessage(msg, size);
                    }
                    while (null != (msg = (Message)this.queue.poll())) {
                        size = msg.size();
                        if (this.count + size >= (long)TP.this.max_bundle_size || this.queue.size() >= this.threshold) {
                            this.sendBundledMessages(this.msgs, this.output);
                        }
                        this.addMessage(msg, size);
                    }
                    if (this.count <= 0L) continue;
                    this.sendBundledMessages(this.msgs, this.output);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected class SenderSendsBundler
    extends BaseBundler
    implements Bundler {
        protected final AtomicInteger num_senders;

        protected SenderSendsBundler() {
            this.num_senders = new AtomicInteger(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Message msg) throws Exception {
            long size = msg.size();
            this.checkLength(size);
            this.num_senders.incrementAndGet();
            this.lock.lock();
            try {
                this.num_senders.decrementAndGet();
                if (this.count + size >= (long)TP.this.max_bundle_size) {
                    this.sendBundledMessages(this.msgs, this.output);
                }
                if (this.num_senders.get() == 0) {
                    if (this.count == 0L) {
                        this.sendSingleMessage(msg, true, this.output);
                    } else {
                        this.addMessage(msg, size);
                        this.sendBundledMessages(this.msgs, this.output);
                    }
                } else {
                    this.addMessage(msg, size);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected class SenderSendsWithTimerBundler
    extends BaseBundler
    implements Runnable {
        protected static final int MIN_NUMBER_OF_BUNDLING_TASKS = 2;
        protected int num_bundling_tasks;

        protected SenderSendsWithTimerBundler() {
            this.num_bundling_tasks = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Message msg) throws Exception {
            long size = msg.size();
            boolean do_schedule = false;
            this.checkLength(size);
            this.lock.lock();
            try {
                if (this.count + size >= (long)TP.this.max_bundle_size) {
                    this.sendBundledMessages(this.msgs, this.output);
                }
                this.addMessage(msg, size);
                if (this.num_bundling_tasks < 2) {
                    ++this.num_bundling_tasks;
                    do_schedule = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (do_schedule) {
                TP.this.timer.schedule(this, TP.this.max_bundle_timeout, TimeUnit.MILLISECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.lock.lock();
            try {
                if (!this.msgs.isEmpty()) {
                    try {
                        this.sendBundledMessages(this.msgs, this.output);
                    }
                    catch (Exception e) {
                        TP.this.log.error(Util.getMessage("FailureSendingMsgBundle"), TP.this.local_addr, e);
                    }
                }
            }
            finally {
                --this.num_bundling_tasks;
                this.lock.unlock();
            }
        }

        public String toString() {
            return TP.this.getClass() + ": BundlingTimer";
        }
    }

    protected class BaseBundler
    implements Bundler {
        final Map<SingletonAddress, List<Message>> msgs = new HashMap<SingletonAddress, List<Message>>(24);
        final ByteArrayDataOutputStream output = new ByteArrayDataOutputStream(1024);
        long count;
        final ReentrantLock lock = new ReentrantLock();

        protected BaseBundler() {
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void send(Message msg) throws Exception {
        }

        protected void sendBundledMessages(Map<SingletonAddress, List<Message>> msgs, ByteArrayDataOutputStream out) {
            if (TP.this.log.isTraceEnabled()) {
                double percentage = 100.0 / (double)TP.this.max_bundle_size * (double)this.count;
                TP.this.log.trace(TP.BUNDLE_MSG, TP.this.local_addr, this.numMessages(msgs), this.count, percentage, msgs.size(), msgs.keySet());
            }
            for (Map.Entry<SingletonAddress, List<Message>> entry : msgs.entrySet()) {
                List<Message> list = entry.getValue();
                if (list.isEmpty()) continue;
                out.position(0);
                if (list.size() == 1) {
                    this.sendSingleMessage(list.get(0), false, out);
                    continue;
                }
                SingletonAddress dst = entry.getKey();
                this.sendMessageList(dst.getAddress(), list.get(0).getSrc(), dst.getClusterName(), list, false, out);
                if (!TP.this.stats) continue;
                ++TP.this.num_batches_sent;
            }
            msgs.clear();
            this.count = 0L;
        }

        protected int numMessages(Map<SingletonAddress, List<Message>> msgs) {
            int num = 0;
            Collection<List<Message>> values = msgs.values();
            for (List<Message> list : values) {
                num += list.size();
            }
            return num;
        }

        protected void sendSingleMessage(Message msg, boolean reset, ByteArrayDataOutputStream out) {
            Address dest = msg.getDest();
            try {
                if (reset) {
                    out.position(0);
                }
                TP.writeMessage(msg, out, dest == null);
                TP.this.doSend(TP.this.getClusterName(msg), out.buffer(), 0, out.position(), dest);
                if (TP.this.stats) {
                    ++TP.this.num_single_msgs_sent;
                }
            }
            catch (SocketException sock_ex) {
                TP.this.log.trace(Util.getMessage("SendFailure"), TP.this.local_addr, dest == null ? "cluster" : dest, msg.size(), sock_ex.toString(), msg.printHeaders());
            }
            catch (Throwable e) {
                TP.this.log.error(Util.getMessage("SendFailure"), TP.this.local_addr, dest == null ? "cluster" : dest, msg.size(), e.toString(), msg.printHeaders());
            }
        }

        protected void sendMessageList(Address dest, Address src, byte[] cluster_name, List<Message> list, boolean reset, ByteArrayDataOutputStream out) {
            try {
                if (reset) {
                    out.position(0);
                }
                TP.writeMessageList(dest, src, cluster_name, list, out, dest == null, TP.this.id);
                TP.this.doSend(TP.this.isSingleton() ? new AsciiString(cluster_name) : null, out.buffer(), 0, out.position(), dest);
            }
            catch (SocketException sock_ex) {
                TP.this.log.debug(Util.getMessage("FailureSendingMsgBundle"), TP.this.local_addr, sock_ex);
            }
            catch (Throwable e) {
                TP.this.log.error(Util.getMessage("FailureSendingMsgBundle"), TP.this.local_addr, e);
            }
        }

        protected void addMessage(Message msg, long size) {
            byte[] cname = !TP.this.isSingleton() ? TP.this.cluster_name.chars() : ((TpHeader)msg.getHeader((short)((TP)TP.this).id)).cluster_name;
            SingletonAddress dest = new SingletonAddress(cname, msg.getDest());
            List<Message> tmp = this.msgs.get(dest);
            if (tmp == null) {
                tmp = new LinkedList<Message>();
                this.msgs.put(dest, tmp);
            }
            tmp.add(msg);
            this.count += size;
        }

        protected void checkLength(long len) throws Exception {
            if (len > (long)TP.this.max_bundle_size) {
                throw new Exception("message size (" + len + ") is greater than max bundling size (" + TP.this.max_bundle_size + "). Set the fragmentation/bundle size in FRAG/FRAG2 and TP correctly");
            }
        }
    }

    protected static interface Bundler {
        public void start();

        public void stop();

        public void send(Message var1) throws Exception;
    }

    protected class BatchHandler
    implements Runnable {
        protected final MessageBatch batch;

        public BatchHandler(MessageBatch batch) {
            this.batch = batch;
        }

        @Override
        public void run() {
            if (TP.this.stats) {
                int batch_size = this.batch.size();
                TP.this.num_msgs_received += (long)batch_size;
                ++TP.this.num_batches_received;
                TP.this.num_bytes_received += (long)this.batch.length();
                TP.this.avg_batch_size.add(batch_size);
            }
            if (!this.batch.multicast()) {
                Address dest = this.batch.dest();
                Address target = TP.this.local_addr;
                if (dest != null && target != null && !dest.equals(target)) {
                    return;
                }
            }
            TP.this.passBatchUp(this.batch, true, true);
        }
    }

    protected class SingleMessageHandler
    implements Runnable {
        protected final Message msg;

        protected SingleMessageHandler(Message msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            boolean multicast = this.msg.getDest() == null;
            try {
                if (!multicast) {
                    Address dest = this.msg.getDest();
                    Address target = TP.this.local_addr;
                    if (target != null && !dest.equals(target)) {
                        return;
                    }
                }
                if (TP.this.stats) {
                    ++TP.this.num_msgs_received;
                    ++TP.this.num_single_msgs_received;
                    TP.this.num_bytes_received += (long)this.msg.getLength();
                }
                TpHeader hdr = (TpHeader)this.msg.getHeader(TP.this.id);
                AsciiString cname = new AsciiString(hdr.cluster_name);
                TP.this.passMessageUp(this.msg, cname, true, multicast, true);
            }
            catch (Throwable t) {
                TP.this.log.error(Util.getMessage("PassUpFailure"), t);
            }
        }
    }

    protected class MyHandler
    implements Runnable {
        protected final Address sender;
        protected final byte[] data;
        protected final int offset;
        protected final int length;

        protected MyHandler(Address sender, byte[] data, int offset, int length) {
            this.sender = sender;
            this.data = data;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public void run() {
            try {
                ByteArrayDataInputStream in = new ByteArrayDataInputStream(this.data, this.offset, this.length);
                short version = in.readShort();
                if (!TP.this.versionMatch(version, this.sender)) {
                    return;
                }
                byte flags = in.readByte();
                boolean multicast = (flags & 2) == 2;
                Message msg = new Message(false);
                int payload_offset = msg.readFromSkipPayload(in);
                if (!multicast) {
                    Address dest = msg.getDest();
                    Address target = TP.this.local_addr;
                    if (dest != null && target != null && !dest.equals(target)) {
                        return;
                    }
                }
                if (payload_offset >= 0) {
                    msg.setBuffer(this.data, payload_offset, this.length - payload_offset);
                }
                if (TP.this.stats) {
                    ++TP.this.num_msgs_received;
                    ++TP.this.num_single_msgs_received;
                    TP.this.num_bytes_received += (long)this.length;
                }
                TpHeader hdr = (TpHeader)msg.getHeader(TP.this.id);
                AsciiString cname = new AsciiString(hdr.cluster_name);
                TP.this.passMessageUp(msg, cname, true, multicast, true);
            }
            catch (Throwable t) {
                TP.this.log.error(Util.getMessage("IncomingMsgFailure"), TP.this.local_addr, t);
            }
        }
    }
}

