/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.iteration.impl;

import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterable;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.iteration.impl.EntryRetriever;
import org.infinispan.iteration.impl.RemovableEntryIterator;
import org.infinispan.util.concurrent.ConcurrentHashSet;

public class TrackingEntryIterable<K, V, C>
implements CloseableIterable<CacheEntry<K, C>> {
    protected final EntryRetriever<K, V> entryRetriever;
    protected final KeyValueFilter<? super K, ? super V> filter;
    protected final Converter<? super K, ? super V, ? extends C> converter;
    protected final EnumSet<Flag> flags;
    protected final Cache<K, V> cache;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final Set<CloseableIterator<CacheEntry<K, C>>> iterators = new ConcurrentHashSet<CloseableIterator<CacheEntry<K, C>>>();

    public TrackingEntryIterable(EntryRetriever<K, V> retriever, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, ? extends C> converter, EnumSet<Flag> flags, Cache<K, V> cache) {
        if (retriever == null) {
            throw new NullPointerException("Retriever cannot be null!");
        }
        if (filter == null) {
            throw new NullPointerException("Filter cannot be null!");
        }
        this.entryRetriever = retriever;
        this.filter = filter;
        this.converter = converter;
        this.flags = flags;
        this.cache = cache;
    }

    public void close() {
        this.closed.set(true);
        for (CloseableIterator<CacheEntry<K, C>> iterator : this.iterators) {
            iterator.close();
        }
    }

    public CloseableIterator<CacheEntry<K, C>> iterator() {
        if (this.closed.get()) {
            throw new IllegalStateException("Iterable has been closed - cannot be reused");
        }
        CloseableIterator<CacheEntry<? super K, ? extends C>> iterator = this.entryRetriever.retrieveEntries(this.filter, this.converter, this.flags, null);
        this.iterators.add(iterator);
        if (this.closed.get()) {
            iterator.close();
            throw new IllegalStateException("Iterable has been closed - cannot be reused");
        }
        return new RemovableEntryIterator<K, C>(iterator, this.cache, true);
    }
}

