/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateConsumerImpl;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InboundTransferTask {
    private static final Log log = LogFactory.getLog(InboundTransferTask.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Set<Integer> segments = new HashSet<Integer>();
    private final Set<Integer> finishedSegments = new HashSet<Integer>();
    private final Address source;
    private volatile boolean isCancelled = false;
    private final AtomicBoolean isStarted = new AtomicBoolean();
    private boolean isStartedSuccessfully = false;
    private volatile boolean isCompletedSuccessfully = false;
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final StateConsumerImpl stateConsumer;
    private final int topologyId;
    private final RpcManager rpcManager;
    private final CommandsFactory commandsFactory;
    private final long timeout;
    private final String cacheName;
    private final RpcOptions rpcOptions;

    public InboundTransferTask(Set<Integer> segments, Address source, int topologyId, StateConsumerImpl stateConsumer, RpcManager rpcManager, CommandsFactory commandsFactory, long timeout, String cacheName) {
        if (segments == null || segments.isEmpty()) {
            throw new IllegalArgumentException("segments must not be null or empty");
        }
        if (source == null) {
            throw new IllegalArgumentException("Source address cannot be null");
        }
        this.segments.addAll(segments);
        this.source = source;
        this.topologyId = topologyId;
        this.stateConsumer = stateConsumer;
        this.rpcManager = rpcManager;
        this.commandsFactory = commandsFactory;
        this.timeout = timeout;
        this.cacheName = cacheName;
        this.rpcOptions = rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS).timeout(timeout, TimeUnit.MILLISECONDS).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getSegments() {
        Set<Integer> set = this.segments;
        synchronized (set) {
            return new HashSet<Integer>(this.segments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getUnfinishedSegments() {
        Set<Integer> set = this.segments;
        synchronized (set) {
            HashSet<Integer> unfinishedSegments = new HashSet<Integer>(this.segments);
            unfinishedSegments.removeAll(this.finishedSegments);
            return unfinishedSegments;
        }
    }

    public Address getSource() {
        return this.source;
    }

    public boolean requestSegments() {
        if (!this.isCancelled && this.isStarted.compareAndSet(false, true)) {
            Set<Integer> segmentsCopy = this.getSegments();
            if (segmentsCopy.isEmpty()) {
                log.debugf("Segments list is empty, skipping source %s", this.source);
                return true;
            }
            if (trace) {
                log.tracef("Requesting segments %s of cache %s from node %s", segmentsCopy, this.cacheName, this.source);
            }
            try {
                StateRequestCommand cmd = this.commandsFactory.buildStateRequestCommand(StateRequestCommand.Type.START_STATE_TRANSFER, this.rpcManager.getAddress(), this.topologyId, segmentsCopy);
                Map<Address, Response> responses = this.rpcManager.invokeRemotely(Collections.singleton(this.source), (ReplicableCommand)cmd, this.rpcOptions);
                Response response = responses.get(this.source);
                if (response instanceof SuccessfulResponse) {
                    this.isStartedSuccessfully = true;
                    if (trace) {
                        log.tracef("Successfully requested segments %s of cache %s from node %s", segmentsCopy, this.cacheName, this.source);
                    }
                    return true;
                }
                log.failedToRequestSegments(segmentsCopy, this.cacheName, this.source, new CacheException(String.valueOf(response)));
            }
            catch (CacheException e) {
                log.failedToRequestSegments(segmentsCopy, this.cacheName, this.source, e);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSegments(Set<Integer> cancelledSegments) {
        if (this.isCancelled) {
            throw new IllegalArgumentException("The task is already cancelled.");
        }
        if (trace) {
            log.tracef("Cancelling inbound state transfer of segments %s of cache %s", cancelledSegments, this.cacheName);
        }
        Set<Integer> set = this.segments;
        synchronized (set) {
            if (!this.segments.containsAll(cancelledSegments)) {
                throw new IllegalArgumentException("Some of the specified segments cannot be cancelled because they were not previously requested");
            }
            this.segments.removeAll(cancelledSegments);
            this.finishedSegments.removeAll(cancelledSegments);
            if (this.segments.isEmpty()) {
                this.isCancelled = true;
            }
        }
        this.sendCancelCommand(cancelledSegments);
        if (this.isCancelled) {
            this.notifyCompletion();
        }
    }

    public void cancel() {
        if (!this.isCancelled) {
            this.isCancelled = true;
            Set<Integer> segmentsCopy = this.getSegments();
            if (trace) {
                log.tracef("Cancelling inbound state transfer of segments %s of cache %s", segmentsCopy, this.cacheName);
            }
            this.sendCancelCommand(segmentsCopy);
            this.notifyCompletion();
        }
    }

    private void sendCancelCommand(Set<Integer> cancelledSegments) {
        StateRequestCommand cmd = this.commandsFactory.buildStateRequestCommand(StateRequestCommand.Type.CANCEL_STATE_TRANSFER, this.rpcManager.getAddress(), this.topologyId, cancelledSegments);
        try {
            this.rpcManager.invokeRemotely(Collections.singleton(this.source), (ReplicableCommand)cmd, this.rpcManager.getDefaultRpcOptions(false, DeliverOrder.NONE));
        }
        catch (Exception e) {
            log.debugf("Caught an exception while cancelling state transfer for segments %s from %s", cancelledSegments, this.source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStateReceived(int segmentId, boolean isLastChunk) {
        if (!this.isCancelled && isLastChunk) {
            boolean isCompleted = false;
            Set<Integer> set = this.segments;
            synchronized (set) {
                if (this.segments.contains(segmentId)) {
                    this.finishedSegments.add(segmentId);
                    if (this.finishedSegments.size() == this.segments.size()) {
                        log.debugf("Finished receiving state for segments %s of cache %s", this.segments, this.cacheName);
                        isCompleted = true;
                    }
                }
            }
            if (isCompleted) {
                this.notifyCompletion();
            }
        }
    }

    private void notifyCompletion() {
        this.isCompletedSuccessfully = true;
        this.stateConsumer.onTaskCompletion(this);
        this.completionLatch.countDown();
    }

    public boolean awaitCompletion() throws InterruptedException {
        if (!this.isStartedSuccessfully) {
            throw new IllegalStateException("Cannot await completion unless the request was previously sent to source node successfully.");
        }
        this.completionLatch.await();
        return this.isCompletedSuccessfully;
    }

    public void terminate() {
        this.completionLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Set<Integer> set = this.segments;
        synchronized (set) {
            return "InboundTransferTask{segments=" + this.segments + ", finishedSegments=" + this.finishedSegments + ", unfinishedSegments=" + this.getUnfinishedSegments() + ", source=" + this.source + ", isCancelled=" + this.isCancelled + ", isStartedSuccessfully=" + this.isStartedSuccessfully + ", isCompletedSuccessfully=" + this.isCompletedSuccessfully + ", topologyId=" + this.topologyId + ", timeout=" + this.timeout + ", cacheName=" + this.cacheName + '}';
        }
    }
}

