/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public enum ParsedCacheMode {
    LOCAL("l", "local"),
    REPL("r", "repl", "replication"),
    DIST("d", "dist", "distribution"),
    INVALIDATION("i", "invl", "invalidation");

    private static final Log log;
    private final List<String> synonyms = new ArrayList<String>();

    private ParsedCacheMode(String ... synonyms) {
        for (String synonym : synonyms) {
            this.synonyms.add(synonym.toUpperCase());
        }
    }

    public boolean matches(String candidate) {
        String c = candidate.toUpperCase();
        for (String synonym : this.synonyms) {
            if (!c.equals(synonym)) continue;
            return true;
        }
        if (c.toUpperCase().startsWith(this.name().toUpperCase().substring(0, 1))) {
            log.randomCacheModeSynonymsDeprecated(candidate, this.name(), this.synonyms);
            return true;
        }
        return false;
    }

    static {
        log = LogFactory.getLog(ParsedCacheMode.class);
    }
}

