/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.Version;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.RemoteCacheManagerNotStartedException;
import org.infinispan.client.hotrod.impl.MetadataValueImpl;
import org.infinispan.client.hotrod.impl.RemoteCacheSupport;
import org.infinispan.client.hotrod.impl.ServerStatisticsImpl;
import org.infinispan.client.hotrod.impl.VersionedOperationResponse;
import org.infinispan.client.hotrod.impl.VersionedValueImpl;
import org.infinispan.client.hotrod.impl.operations.AddClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.BulkGetKeysOperation;
import org.infinispan.client.hotrod.impl.operations.BulkGetOperation;
import org.infinispan.client.hotrod.impl.operations.ClearOperation;
import org.infinispan.client.hotrod.impl.operations.ContainsKeyOperation;
import org.infinispan.client.hotrod.impl.operations.ExecuteOperation;
import org.infinispan.client.hotrod.impl.operations.GetOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithVersionOperation;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.operations.PutIfAbsentOperation;
import org.infinispan.client.hotrod.impl.operations.PutOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceOperation;
import org.infinispan.client.hotrod.impl.operations.SizeOperation;
import org.infinispan.client.hotrod.impl.operations.StatsOperation;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.commons.util.concurrent.NotifyingFutureImpl;

public class RemoteCacheImpl<K, V>
extends RemoteCacheSupport<K, V> {
    private static final Log log = LogFactory.getLog(RemoteCacheImpl.class, Log.class);
    private Marshaller marshaller;
    private final String name;
    private final RemoteCacheManager remoteCacheManager;
    private volatile ExecutorService executorService;
    private OperationsFactory operationsFactory;
    private int estimateKeySize;
    private int estimateValueSize;

    public RemoteCacheImpl(RemoteCacheManager rcm, String name) {
        if (log.isTraceEnabled()) {
            log.tracef("Creating remote cache: %s", name);
        }
        this.name = name;
        this.remoteCacheManager = rcm;
    }

    public void init(Marshaller marshaller, ExecutorService executorService, OperationsFactory operationsFactory, int estimateKeySize, int estimateValueSize) {
        this.marshaller = marshaller;
        this.executorService = executorService;
        this.operationsFactory = operationsFactory;
        this.estimateKeySize = estimateKeySize;
        this.estimateValueSize = estimateValueSize;
    }

    public OperationsFactory getOperationsFactory() {
        return this.operationsFactory;
    }

    @Override
    public RemoteCacheManager getRemoteCacheManager() {
        return this.remoteCacheManager;
    }

    @Override
    public boolean removeWithVersion(K key, long version) {
        this.assertRemoteCacheManagerIsStarted();
        RemoveIfUnmodifiedOperation op = this.operationsFactory.newRemoveIfUnmodifiedOperation(this.obj2bytes(key, true), version);
        VersionedOperationResponse response = (VersionedOperationResponse)op.execute();
        return response.getCode().isUpdated();
    }

    @Override
    public NotifyingFuture<Boolean> removeWithVersionAsync(final K key, final long version) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future<Boolean> future = this.executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    boolean removed = RemoteCacheImpl.this.removeWithVersion(key, version);
                    try {
                        result.notifyDone((Object)removed);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return removed;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(future);
        return result;
    }

    @Override
    public boolean replaceWithVersion(K key, V newValue, long version, int lifespanSeconds, int maxIdleTimeSeconds) {
        this.assertRemoteCacheManagerIsStarted();
        ReplaceIfUnmodifiedOperation op = this.operationsFactory.newReplaceIfUnmodifiedOperation(this.obj2bytes(key, true), this.obj2bytes(newValue, false), lifespanSeconds, maxIdleTimeSeconds, version);
        VersionedOperationResponse response = (VersionedOperationResponse)op.execute();
        return response.getCode().isUpdated();
    }

    @Override
    public NotifyingFuture<Boolean> replaceWithVersionAsync(final K key, final V newValue, final long version, final int lifespanSeconds, final int maxIdleSeconds) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future<Boolean> future = this.executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    boolean removed = RemoteCacheImpl.this.replaceWithVersion(key, newValue, version, lifespanSeconds, maxIdleSeconds);
                    try {
                        result.notifyDone((Object)removed);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return removed;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(future);
        return result;
    }

    @Override
    public VersionedValue<V> getVersioned(K key) {
        this.assertRemoteCacheManagerIsStarted();
        GetWithVersionOperation op = this.operationsFactory.newGetWithVersionOperation(this.obj2bytes(key, true));
        VersionedValue value = (VersionedValue)op.execute();
        return this.binary2VersionedValue(value);
    }

    @Override
    public MetadataValue<V> getWithMetadata(K key) {
        this.assertRemoteCacheManagerIsStarted();
        GetWithMetadataOperation op = this.operationsFactory.newGetWithMetadataOperation(this.obj2bytes(key, true));
        MetadataValue value = (MetadataValue)op.execute();
        return this.binary2MetadataValue(value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        }
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(final Map<? extends K, ? extends V> data, final long lifespan, final TimeUnit lifespanUnit, final long maxIdle, final TimeUnit maxIdleUnit) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future<Void> future = this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    RemoteCacheImpl.this.putAll(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
                    try {
                        result.notifyDone(null);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return null;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(future);
        return result;
    }

    @Override
    public int size() {
        this.assertRemoteCacheManagerIsStarted();
        SizeOperation op = this.operationsFactory.newSizeOperation();
        return (Integer)op.execute();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ServerStatistics stats() {
        this.assertRemoteCacheManagerIsStarted();
        StatsOperation op = this.operationsFactory.newStatsOperation();
        Map statsMap = (Map)op.execute();
        ServerStatisticsImpl stats = new ServerStatisticsImpl();
        for (Map.Entry entry : statsMap.entrySet()) {
            stats.addStats((String)entry.getKey(), (String)entry.getValue());
        }
        return stats;
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        int lifespanSecs = RemoteCacheImpl.toSeconds(lifespan, lifespanUnit);
        int maxIdleSecs = RemoteCacheImpl.toSeconds(maxIdleTime, maxIdleTimeUnit);
        this.applyDefaultExpirationFlags(lifespan, maxIdleTime);
        if (log.isTraceEnabled()) {
            log.tracef("About to add (K,V): (%s, %s) lifespanSecs:%d, maxIdleSecs:%d", new Object[]{key, value, lifespanSecs, maxIdleSecs});
        }
        PutOperation op = this.operationsFactory.newPutKeyValueOperation(this.obj2bytes(key, true), this.obj2bytes(value, false), lifespanSecs, maxIdleSecs);
        byte[] result = (byte[])op.execute();
        return (V)MarshallerUtil.bytes2obj(this.marshaller, result);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        int lifespanSecs = RemoteCacheImpl.toSeconds(lifespan, lifespanUnit);
        int maxIdleSecs = RemoteCacheImpl.toSeconds(maxIdleTime, maxIdleTimeUnit);
        this.applyDefaultExpirationFlags(lifespan, maxIdleTime);
        PutIfAbsentOperation op = this.operationsFactory.newPutIfAbsentOperation(this.obj2bytes(key, true), this.obj2bytes(value, false), lifespanSecs, maxIdleSecs);
        byte[] bytes = (byte[])op.execute();
        return (V)MarshallerUtil.bytes2obj(this.marshaller, bytes);
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        int lifespanSecs = RemoteCacheImpl.toSeconds(lifespan, lifespanUnit);
        int maxIdleSecs = RemoteCacheImpl.toSeconds(maxIdleTime, maxIdleTimeUnit);
        this.applyDefaultExpirationFlags(lifespan, maxIdleTime);
        ReplaceOperation op = this.operationsFactory.newReplaceOperation(this.obj2bytes(key, true), this.obj2bytes(value, false), lifespanSecs, maxIdleSecs);
        byte[] bytes = (byte[])op.execute();
        return (V)MarshallerUtil.bytes2obj(this.marshaller, bytes);
    }

    public NotifyingFuture<V> putAsync(final K key, final V value, final long lifespan, final TimeUnit lifespanUnit, final long maxIdle, final TimeUnit maxIdleUnit) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future future = this.executorService.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    Object prevValue = RemoteCacheImpl.this.put(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
                    try {
                        result.notifyDone(prevValue);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return prevValue;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(future);
        return result;
    }

    public NotifyingFuture<Void> clearAsync() {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future<Void> future = this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    RemoteCacheImpl.this.clear();
                    try {
                        result.notifyDone(null);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return null;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(future);
        return result;
    }

    public NotifyingFuture<V> putIfAbsentAsync(final K key, final V value, final long lifespan, final TimeUnit lifespanUnit, final long maxIdle, final TimeUnit maxIdleUnit) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future future = this.executorService.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    Object prevValue = RemoteCacheImpl.this.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
                    try {
                        result.notifyDone(prevValue);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return prevValue;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(future);
        return result;
    }

    public NotifyingFuture<V> removeAsync(final Object key) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future future = this.executorService.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    Object toReturn = RemoteCacheImpl.this.remove(key);
                    try {
                        result.notifyDone(toReturn);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return toReturn;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(future);
        return result;
    }

    public NotifyingFuture<V> replaceAsync(final K key, final V value, final long lifespan, final TimeUnit lifespanUnit, final long maxIdle, final TimeUnit maxIdleUnit) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future future = this.executorService.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    Object old = RemoteCacheImpl.this.replace(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
                    try {
                        result.notifyDone(old);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return old;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(future);
        return result;
    }

    public boolean containsKey(Object key) {
        this.assertRemoteCacheManagerIsStarted();
        ContainsKeyOperation op = this.operationsFactory.newContainsKeyOperation(this.obj2bytes(key, true));
        return (Boolean)op.execute();
    }

    public V get(Object key) {
        this.assertRemoteCacheManagerIsStarted();
        byte[] keyBytes = this.obj2bytes(key, true);
        GetOperation gco = this.operationsFactory.newGetKeyOperation(keyBytes);
        byte[] bytes = (byte[])gco.execute();
        Object result = MarshallerUtil.bytes2obj(this.marshaller, bytes);
        if (log.isTraceEnabled()) {
            log.tracef("For key(%s) returning %s", key, result);
        }
        return (V)result;
    }

    @Override
    public Map<K, V> getBulk() {
        return this.getBulk(0);
    }

    @Override
    public Map<K, V> getBulk(int size) {
        this.assertRemoteCacheManagerIsStarted();
        BulkGetOperation op = this.operationsFactory.newBulkGetOperation(size);
        Map result = (Map)op.execute();
        HashMap toReturn = new HashMap();
        for (Map.Entry entry : result.entrySet()) {
            Object value = MarshallerUtil.bytes2obj(this.marshaller, (byte[])entry.getValue());
            Object key = MarshallerUtil.bytes2obj(this.marshaller, (byte[])entry.getKey());
            toReturn.put(key, value);
        }
        return Collections.unmodifiableMap(toReturn);
    }

    public V remove(Object key) {
        this.assertRemoteCacheManagerIsStarted();
        RemoveOperation removeOperation = this.operationsFactory.newRemoveOperation(this.obj2bytes(key, true));
        byte[] existingValue = (byte[])removeOperation.execute();
        return (V)MarshallerUtil.bytes2obj(this.marshaller, existingValue);
    }

    public void clear() {
        this.assertRemoteCacheManagerIsStarted();
        ClearOperation op = this.operationsFactory.newClearOperation();
        op.execute();
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debugf("Start called, nothing to do here(%s)", this.getName());
        }
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debugf("Stop called, nothing to do here(%s)", this.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return RemoteCacheImpl.class.getPackage().getImplementationVersion();
    }

    @Override
    public String getProtocolVersion() {
        return Version.getProtocolVersion();
    }

    @Override
    public void addClientListener(Object listener) {
        this.assertRemoteCacheManagerIsStarted();
        AddClientListenerOperation op = this.operationsFactory.newAddClientListenerOperation(listener);
        op.execute();
    }

    @Override
    public void addClientListener(Object listener, Object[] filterFactoryParams, Object[] converterFactoryParams) {
        this.assertRemoteCacheManagerIsStarted();
        byte[][] marshalledFilterParams = this.marshallParams(filterFactoryParams);
        byte[][] marshalledConverterParams = this.marshallParams(converterFactoryParams);
        AddClientListenerOperation op = this.operationsFactory.newAddClientListenerOperation(listener, marshalledFilterParams, marshalledConverterParams);
        op.execute();
    }

    private byte[][] marshallParams(Object[] params) {
        if (params == null) {
            return new byte[0][];
        }
        byte[][] marshalledParams = new byte[params.length][];
        for (int i = 0; i < marshalledParams.length; ++i) {
            byte[] bytes = this.obj2bytes(params[i], true);
            marshalledParams[i] = bytes;
        }
        return marshalledParams;
    }

    @Override
    public void removeClientListener(Object listener) {
        this.assertRemoteCacheManagerIsStarted();
        RemoveClientListenerOperation op = this.operationsFactory.newRemoveClientListenerOperation(listener);
        op.execute();
    }

    @Override
    public Set<Object> getListeners() {
        ClientListenerNotifier listenerNotifier = this.operationsFactory.getListenerNotifier();
        return listenerNotifier.getListeners(this.operationsFactory.getCacheName());
    }

    @Override
    public RemoteCache<K, V> withFlags(Flag ... flags) {
        this.operationsFactory.setFlags(flags);
        return this;
    }

    public NotifyingFuture<V> getAsync(final K key) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future future = this.executorService.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    Object toReturn = RemoteCacheImpl.this.get(key);
                    try {
                        result.notifyDone(toReturn);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return toReturn;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(future);
        return result;
    }

    public PingOperation.PingResult ping() {
        return (PingOperation.PingResult)((Object)this.operationsFactory.newFaultTolerantPingOperation().execute());
    }

    private byte[] obj2bytes(Object o, boolean isKey) {
        try {
            return this.marshaller.objectToByteBuffer(o, isKey ? this.estimateKeySize : this.estimateValueSize);
        }
        catch (IOException ioe) {
            throw new HotRodClientException("Unable to marshall object of type [" + o.getClass().getName() + "]", ioe);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private VersionedValue<V> binary2VersionedValue(VersionedValue<byte[]> value) {
        if (value == null) {
            return null;
        }
        Object valueObj = MarshallerUtil.bytes2obj(this.marshaller, value.getValue());
        return new VersionedValueImpl(value.getVersion(), valueObj);
    }

    private MetadataValue<V> binary2MetadataValue(MetadataValue<byte[]> value) {
        if (value == null) {
            return null;
        }
        Object valueObj = MarshallerUtil.bytes2obj(this.marshaller, (byte[])value.getValue());
        return new MetadataValueImpl(value.getCreated(), value.getLifespan(), value.getLastUsed(), value.getMaxIdle(), value.getVersion(), valueObj);
    }

    protected static int toSeconds(long duration, TimeUnit timeUnit) {
        int seconds = (int)timeUnit.toSeconds(duration);
        long inverseDuration = timeUnit.convert(seconds, TimeUnit.SECONDS);
        if (duration > inverseDuration) {
            ++seconds;
        }
        return seconds;
    }

    private void assertRemoteCacheManagerIsStarted() {
        if (!this.remoteCacheManager.isStarted()) {
            String message = "Cannot perform operations on a cache associated with an unstarted RemoteCacheManager. Use RemoteCacheManager.start before using the remote cache.";
            if (log.isInfoEnabled()) {
                log.unstartedRemoteCacheManager();
            }
            throw new RemoteCacheManagerNotStartedException(message);
        }
    }

    @Override
    protected void set(K key, V value) {
        this.put(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    private void applyDefaultExpirationFlags(long lifespan, long maxIdle) {
        if (lifespan == 0L) {
            this.operationsFactory.addFlags(Flag.DEFAULT_LIFESPAN);
        }
        if (maxIdle == 0L) {
            this.operationsFactory.addFlags(Flag.DEFAULT_MAXIDLE);
        }
    }

    @Override
    public Set<K> keySet() {
        this.assertRemoteCacheManagerIsStarted();
        BulkGetKeysOperation op = this.operationsFactory.newBulkGetKeysOperation(0);
        Set result = (Set)op.execute();
        HashSet toReturn = new HashSet();
        for (byte[] keyBytes : result) {
            Object key = MarshallerUtil.bytes2obj(this.marshaller, keyBytes);
            toReturn.add(key);
        }
        return Collections.unmodifiableSet(toReturn);
    }

    @Override
    public <T> T execute(String taskName, Map<String, ?> params) {
        this.assertRemoteCacheManagerIsStarted();
        HashMap<String, byte[]> marshalledParams = new HashMap<String, byte[]>();
        if (params != null) {
            for (Map.Entry<String, ?> entry : params.entrySet()) {
                marshalledParams.put(entry.getKey(), this.obj2bytes(entry.getValue(), false));
            }
        }
        ExecuteOperation op = this.operationsFactory.newExecuteOperation(taskName, marshalledParams);
        return MarshallerUtil.bytes2obj(this.marshaller, (byte[])op.execute());
    }
}

